/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.settings;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.button.DocsButton;
import org.tinymediamanager.ui.components.button.SquareIconButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.panel.CollapsiblePanel;
import org.tinymediamanager.ui.components.table.PostProcessTable;
import org.tinymediamanager.ui.components.table.TmmTable;
import org.tinymediamanager.ui.dialogs.PostProcessDialog;
import org.tinymediamanager.ui.dialogs.SettingsDialog;

public class MoviePostProcessingSettingsPanel
extends JPanel {
    private final EventList<PostProcess> postProcessEventList;
    private TmmTable tablePostProcesses;
    private JButton btnRemoveProcess;
    private JButton btnAddProcess;
    private JButton btnMoveProcessUp;
    private JButton btnMoveProcessDown;

    MoviePostProcessingSettingsPanel() {
        MovieSettings settings = MovieModuleManager.getInstance().getSettings();
        this.postProcessEventList = GlazedLists.eventList(settings.getPostProcess());
        GlazedLists.syncEventListToList(this.postProcessEventList, settings.getPostProcess());
        this.initComponents();
        this.tablePostProcesses.getSelectionModel().setSelectionMode(0);
        this.btnAddProcess.addActionListener(e -> {
            MoviePostProcessDialog dialog = new MoviePostProcessDialog();
            dialog.pack();
            dialog.setLocationRelativeTo(SettingsDialog.getInstance());
            dialog.setVisible(true);
            this.tablePostProcesses.adjustColumnPreferredWidths(5);
        });
        this.btnRemoveProcess.addActionListener(e -> {
            int row = this.tablePostProcesses.convertRowIndexToModel(this.tablePostProcesses.getSelectedRow());
            if (row >= 0 && row < this.postProcessEventList.size()) {
                this.postProcessEventList.remove(row);
                MovieModuleManager.getInstance().getSettings().forceSaveSettings();
            }
            this.tablePostProcesses.adjustColumnPreferredWidths(5);
        });
        this.btnMoveProcessUp.addActionListener(e -> {
            int row = this.tablePostProcesses.convertRowIndexToModel(this.tablePostProcesses.getSelectedRow());
            if (row != -1 && row != 0) {
                ListUtils.swap(this.postProcessEventList, row, row - 1);
                MovieModuleManager.getInstance().getSettings().forceSaveSettings();
                this.tablePostProcesses.getSelectionModel().setSelectionInterval(row - 1, row - 1);
            }
        });
        this.btnMoveProcessDown.addActionListener(e -> {
            int row = this.tablePostProcesses.convertRowIndexToModel(this.tablePostProcesses.getSelectedRow());
            if (row != -1 && row != this.postProcessEventList.size() - 1) {
                ListUtils.swap(this.postProcessEventList, row, row + 1);
                MovieModuleManager.getInstance().getSettings().forceSaveSettings();
                this.tablePostProcesses.getSelectionModel().setSelectionInterval(row + 1, row + 1);
            }
        });
    }

    private void initComponents() {
        this.setLayout((LayoutManager)new MigLayout("", "[grow]", "[]"));
        JPanel panelProcess = new JPanel((LayoutManager)new MigLayout("hidemode 1, insets 0", "[20lp!][600lp,grow]10lp[]", "[500lp,grow]"));
        TmmLabel lblProcess = new TmmLabel(TmmResourceBundle.getString("Settings.postprocessing"), 1.16667);
        CollapsiblePanel collapsiblePanel = new CollapsiblePanel((JComponent)panelProcess, lblProcess, true);
        collapsiblePanel.addExtraTitleComponent(new DocsButton("/movies/settings#post-processing"));
        this.add((Component)collapsiblePanel, "growx,wmin 0");
        JScrollPane spProcesses = new JScrollPane();
        panelProcess.add((Component)spProcesses, "cell 1 0,grow");
        this.tablePostProcesses = new PostProcessTable(this.postProcessEventList){

            @Override
            protected void editButtonClicked(int row) {
                int index = this.convertRowIndexToModel(row);
                PostProcess postProcess = (PostProcess)this.postProcessList.get(index);
                if (postProcess != null) {
                    MoviePostProcessDialog dialog = new MoviePostProcessDialog();
                    dialog.setProcess(postProcess);
                    dialog.pack();
                    dialog.setLocationRelativeTo(SettingsDialog.getInstance());
                    dialog.setVisible(true);
                    MoviePostProcessingSettingsPanel.this.tablePostProcesses.adjustColumnPreferredWidths(5);
                }
            }
        };
        this.tablePostProcesses.configureScrollPane(spProcesses);
        this.btnAddProcess = new SquareIconButton(IconManager.ADD_INV);
        panelProcess.add((Component)this.btnAddProcess, "flowy,cell 2 0,aligny top");
        this.btnRemoveProcess = new SquareIconButton(IconManager.REMOVE_INV);
        panelProcess.add((Component)this.btnRemoveProcess, "cell 2 0");
        this.btnMoveProcessUp = new SquareIconButton(IconManager.ARROW_UP_INV);
        panelProcess.add((Component)this.btnMoveProcessUp, "cell 2 0");
        this.btnMoveProcessDown = new SquareIconButton(IconManager.ARROW_DOWN_INV);
        panelProcess.add((Component)this.btnMoveProcessDown, "cell 2 0");
    }

    private class MoviePostProcessDialog
    extends PostProcessDialog {
        @Override
        public void save() {
            if (StringUtils.isBlank((CharSequence)this.tfProcessName.getText()) || StringUtils.isBlank((CharSequence)this.tfCommand.getText()) && StringUtils.isBlank((CharSequence)this.tfPath.getText())) {
                this.showErrorToast(TmmResourceBundle.getString("message.missingitems"));
                return;
            }
            if (this.process == null) {
                this.process = new PostProcess();
                MoviePostProcessingSettingsPanel.this.postProcessEventList.add((Object)this.process);
            }
            this.process.setName(this.tfProcessName.getText());
            this.process.setCommand(this.tfCommand.getText());
            this.process.setPath(this.tfPath.getText());
            MovieModuleManager.getInstance().getSettings().forceSaveSettings();
            this.setVisible(false);
        }
    }
}

