/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.dialogs;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractSettings;
import org.tinymediamanager.core.TmmProperties;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.MainWindow;
import org.tinymediamanager.ui.TmmFontHelper;
import org.tinymediamanager.ui.components.NoBorderScrollPane;
import org.tinymediamanager.ui.components.button.FlatButton;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.tabbedpane.TmmTabbedPane;
import org.tinymediamanager.ui.dialogs.TmmDialog;
import org.tinymediamanager.ui.movies.MovieSelectionModel;
import org.tinymediamanager.ui.movies.filters.IMovieUIFilter;
import org.tinymediamanager.ui.movies.filters.MovieAllInOneFilter;
import org.tinymediamanager.ui.movies.filters.MovieAspectRatioFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioChannelFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioCodecFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioLanguageFilter;
import org.tinymediamanager.ui.movies.filters.MovieAudioTitleFilter;
import org.tinymediamanager.ui.movies.filters.MovieBannerSizeFilter;
import org.tinymediamanager.ui.movies.filters.MovieCastFilter;
import org.tinymediamanager.ui.movies.filters.MovieCertificationFilter;
import org.tinymediamanager.ui.movies.filters.MovieClearArtSizeFilter;
import org.tinymediamanager.ui.movies.filters.MovieClearLogoSizeFilter;
import org.tinymediamanager.ui.movies.filters.MovieCountAudioStreamFilter;
import org.tinymediamanager.ui.movies.filters.MovieCountSubtitleFilter;
import org.tinymediamanager.ui.movies.filters.MovieCountryFilter;
import org.tinymediamanager.ui.movies.filters.MovieDatasourceFilter;
import org.tinymediamanager.ui.movies.filters.MovieDateAddedFilter;
import org.tinymediamanager.ui.movies.filters.MovieDecadesFilter;
import org.tinymediamanager.ui.movies.filters.MovieDifferentRuntimeFilter;
import org.tinymediamanager.ui.movies.filters.MovieDiscArtSizeFilter;
import org.tinymediamanager.ui.movies.filters.MovieDuplicateFilter;
import org.tinymediamanager.ui.movies.filters.MovieEditionFilter;
import org.tinymediamanager.ui.movies.filters.MovieFanartSizeFilter;
import org.tinymediamanager.ui.movies.filters.MovieFilenameFilter;
import org.tinymediamanager.ui.movies.filters.MovieFrameRateFilter;
import org.tinymediamanager.ui.movies.filters.MovieGenreFilter;
import org.tinymediamanager.ui.movies.filters.MovieHDRFormatFilter;
import org.tinymediamanager.ui.movies.filters.MovieImdbIdFilter;
import org.tinymediamanager.ui.movies.filters.MovieInMovieSetFilter;
import org.tinymediamanager.ui.movies.filters.MovieKeyArtSizeFilter;
import org.tinymediamanager.ui.movies.filters.MovieLanguageFilter;
import org.tinymediamanager.ui.movies.filters.MovieLockedFilter;
import org.tinymediamanager.ui.movies.filters.MovieMediaFilesFilter;
import org.tinymediamanager.ui.movies.filters.MovieMediaSourceFilter;
import org.tinymediamanager.ui.movies.filters.MovieMissingArtworkFilter;
import org.tinymediamanager.ui.movies.filters.MovieMissingMetadataFilter;
import org.tinymediamanager.ui.movies.filters.MovieMissingSubtitlesFilter;
import org.tinymediamanager.ui.movies.filters.MovieNewMoviesFilter;
import org.tinymediamanager.ui.movies.filters.MovieNoteFilter;
import org.tinymediamanager.ui.movies.filters.MoviePathFilter;
import org.tinymediamanager.ui.movies.filters.MoviePosterSizeFilter;
import org.tinymediamanager.ui.movies.filters.MovieProductionCompanyFilter;
import org.tinymediamanager.ui.movies.filters.MovieReleaseDateFilter;
import org.tinymediamanager.ui.movies.filters.MovieRuntimeFilter;
import org.tinymediamanager.ui.movies.filters.MovieSubtitleFormatFilter;
import org.tinymediamanager.ui.movies.filters.MovieSubtitleLanguageFilter;
import org.tinymediamanager.ui.movies.filters.MovieSubtitleTypeFilter;
import org.tinymediamanager.ui.movies.filters.MovieTagFilter;
import org.tinymediamanager.ui.movies.filters.MovieThumbSizeFilter;
import org.tinymediamanager.ui.movies.filters.MovieTmdbIdFilter;
import org.tinymediamanager.ui.movies.filters.MovieTrailerFormatFilter;
import org.tinymediamanager.ui.movies.filters.MovieTraktIdFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideo3DFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoBitdepthFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoBitrateFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoCodecFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoContainerFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoCrc32Filter;
import org.tinymediamanager.ui.movies.filters.MovieVideoExtrasFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoFilenameFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoFilesizeFilter;
import org.tinymediamanager.ui.movies.filters.MovieVideoFormatFilter;
import org.tinymediamanager.ui.movies.filters.MovieWatchedFilter;
import org.tinymediamanager.ui.movies.filters.MovieYearFilter;
import org.tinymediamanager.ui.panels.FilterSavePanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;

public class MovieFilterDialog
extends TmmDialog {
    private static final String PANEL_COL_CONSTRAINTS = "[][][][200lp:250lp,grow]";
    private final MovieSelectionModel selectionModel;
    private final Map<JPanel, Set<IMovieUIFilter>> filterMap;
    private final Set<IMovieUIFilter> filters;
    private final JCheckBox chkbxEnableAll;
    private final JTabbedPane tabbedPane;
    private JComboBox<String> cbPreset;

    public MovieFilterDialog(MovieSelectionModel selectionModel) {
        super(TmmResourceBundle.getString("movieextendedsearch.options") + " - " + TmmResourceBundle.getString("tmm.movies"), "movieFilter");
        this.setModalityType(Dialog.ModalityType.MODELESS);
        this.selectionModel = selectionModel;
        this.filterMap = new HashMap<JPanel, Set<IMovieUIFilter>>();
        this.filters = new HashSet<IMovieUIFilter>();
        this.selectionModel.addPropertyChangeListener("filterChanged", evt -> this.filterChanged());
        ActionListener actionListener = e -> SwingUtilities.invokeLater(() -> {
            String filterName = (String)this.cbPreset.getSelectedItem();
            if (StringUtils.isNotBlank((CharSequence)filterName)) {
                selectionModel.setFilterValues(MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets().get(filterName));
            } else {
                selectionModel.clearFilters();
            }
        });
        this.tabbedPane = new TmmTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        JPanel panelMain = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.details"), this.createTabPanel(panelMain));
        this.addFilter(new MovieNewMoviesFilter(), panelMain);
        this.addFilter(new MovieDatasourceFilter(), panelMain);
        this.addFilter(new MovieWatchedFilter(), panelMain);
        this.addFilter(new MovieLockedFilter(), panelMain);
        this.addFilter(new MovieDateAddedFilter(), panelMain);
        this.addFilter(new MovieDuplicateFilter(), panelMain);
        this.addFilter(new MovieInMovieSetFilter(), panelMain);
        this.addFilter(new MovieAllInOneFilter(), panelMain);
        JPanel panelMetadata = new JPanel((LayoutManager)new MigLayout("insets 0", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("tmm.metadata"), this.createTabPanel(panelMetadata));
        this.addFilter(new MovieYearFilter(), panelMetadata);
        this.addFilter(new MovieReleaseDateFilter(), panelMetadata);
        this.addFilter(new MovieDecadesFilter(), panelMetadata);
        this.addFilter(new MovieGenreFilter(), panelMetadata);
        this.addFilter(new MovieCertificationFilter(), panelMetadata);
        this.addFilter(new MovieCastFilter(), panelMetadata);
        this.addFilter(new MovieCountryFilter(), panelMetadata);
        this.addFilter(new MovieLanguageFilter(), panelMetadata);
        this.addFilter(new MovieProductionCompanyFilter(), panelMetadata);
        panelMetadata.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieTagFilter(), panelMetadata);
        this.addFilter(new MovieEditionFilter(), panelMetadata);
        this.addFilter(new MovieNoteFilter(), panelMetadata);
        panelMetadata.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieImdbIdFilter(), panelMetadata);
        this.addFilter(new MovieTmdbIdFilter(), panelMetadata);
        this.addFilter(new MovieTraktIdFilter(), panelMetadata);
        JPanel panelVideo = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.video"), this.createTabPanel(panelVideo));
        this.addFilter(new MovieVideoFormatFilter(), panelVideo);
        this.addFilter(new MovieVideoCodecFilter(), panelVideo);
        this.addFilter(new MovieVideoBitrateFilter(), panelVideo);
        this.addFilter(new MovieVideoBitdepthFilter(), panelVideo);
        this.addFilter(new MovieVideoContainerFilter(), panelVideo);
        this.addFilter(new MovieAspectRatioFilter(), panelVideo);
        this.addFilter(new MovieFrameRateFilter(), panelVideo);
        this.addFilter(new MovieVideo3DFilter(), panelVideo);
        this.addFilter(new MovieVideoCrc32Filter(), panelVideo);
        this.addFilter(new MovieHDRFormatFilter(), panelVideo);
        JPanel panelAudio = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("metatag.audio"), this.createTabPanel(panelAudio));
        this.addFilter(new MovieAudioCodecFilter(), panelAudio);
        this.addFilter(new MovieAudioChannelFilter(), panelAudio);
        this.addFilter(new MovieCountAudioStreamFilter(), panelAudio);
        this.addFilter(new MovieAudioLanguageFilter(), panelAudio);
        this.addFilter(new MovieAudioTitleFilter(), panelAudio);
        JPanel panelArtwork = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("filter.artwork"), this.createTabPanel(panelArtwork));
        this.addFilter(new MoviePosterSizeFilter(), panelArtwork);
        this.addFilter(new MovieFanartSizeFilter(), panelArtwork);
        this.addFilter(new MovieBannerSizeFilter(), panelArtwork);
        this.addFilter(new MovieThumbSizeFilter(), panelArtwork);
        this.addFilter(new MovieClearLogoSizeFilter(), panelArtwork);
        this.addFilter(new MovieClearArtSizeFilter(), panelArtwork);
        this.addFilter(new MovieDiscArtSizeFilter(), panelArtwork);
        this.addFilter(new MovieKeyArtSizeFilter(), panelArtwork);
        this.addFilter(new MovieMissingArtworkFilter(), panelArtwork);
        JPanel panelOther = new JPanel((LayoutManager)new MigLayout("", PANEL_COL_CONSTRAINTS, "[]"));
        this.tabbedPane.addTab(TmmResourceBundle.getString("filter.others"), this.createTabPanel(panelOther));
        this.addFilter(new MovieMediaSourceFilter(), panelOther);
        this.addFilter(new MovieMediaFilesFilter(), panelOther);
        this.addFilter(new MovieFilenameFilter(), panelOther);
        this.addFilter(new MovieVideoFilesizeFilter(), panelOther);
        this.addFilter(new MovieVideoFilenameFilter(), panelOther);
        this.addFilter(new MoviePathFilter(), panelOther);
        this.addFilter(new MovieCountSubtitleFilter(), panelOther);
        this.addFilter(new MovieSubtitleLanguageFilter(), panelOther);
        this.addFilter(new MovieSubtitleFormatFilter(), panelOther);
        this.addFilter(new MovieSubtitleTypeFilter(), panelOther);
        this.addFilter(new MovieVideoExtrasFilter(), panelOther);
        this.addFilter(new MovieTrailerFormatFilter(), panelOther);
        this.addFilter(new MovieRuntimeFilter(), panelOther);
        this.addFilter(new MovieDifferentRuntimeFilter(), panelOther);
        panelOther.add(Box.createHorizontalGlue(), "wrap");
        this.addFilter(new MovieMissingMetadataFilter(), panelOther);
        this.addFilter(new MovieMissingSubtitlesFilter(), panelOther);
        JPanel panelFilterPreset = new JPanel();
        panelFilterPreset.setLayout((LayoutManager)new MigLayout("insets n 0 n 0", "[5lp!][10lp][150lp,grow][5lp!]", "[]"));
        JSeparator separator = new JSeparator();
        panelFilterPreset.add((Component)separator, "cell 0 1 4 1,growx,aligny top");
        TmmLabel lblEnableAllT = new TmmLabel(TmmResourceBundle.getString("filter.enableall"));
        panelFilterPreset.add((Component)lblEnableAllT, "cell 1 2, alignx trailing");
        this.chkbxEnableAll = new JCheckBox();
        this.chkbxEnableAll.setSelected(true);
        this.chkbxEnableAll.addActionListener(e -> selectionModel.setFiltersActive(this.chkbxEnableAll.isSelected()));
        panelFilterPreset.add((Component)this.chkbxEnableAll, "cell 2 2");
        TmmLabel lblFilterPresetT = new TmmLabel(TmmResourceBundle.getString("filter.presets"));
        panelFilterPreset.add((Component)lblFilterPresetT, "cell 1 3, alignx trailing");
        this.cbPreset = new JComboBox();
        panelFilterPreset.add(this.cbPreset, "cell 2 3");
        FlatButton btnSavePreset = new FlatButton(IconManager.SAVE);
        btnSavePreset.setToolTipText(TmmResourceBundle.getString("filter.savepreset"));
        btnSavePreset.addActionListener(e -> {
            Set<AbstractSettings.UIFilters> activeUiFilters = this.getActiveUiFilters();
            if (!activeUiFilters.isEmpty()) {
                HashMap<String, List<AbstractSettings.UIFilters>> uiFilters = new HashMap<String, List<AbstractSettings.UIFilters>>(MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets());
                ModalPopupPanel popupPanel = this.createModalPopupPanel();
                popupPanel.setTitle(TmmResourceBundle.getString("filter.savepreset"));
                FilterSavePanel filterSavePanel = new FilterSavePanel(activeUiFilters, uiFilters);
                popupPanel.setOnCloseHandler(() -> {
                    String savedPreset = filterSavePanel.getSavedPreset();
                    if (StringUtils.isNotBlank((CharSequence)savedPreset)) {
                        this.cbPreset.removeActionListener(actionListener);
                        MovieModuleManager.getInstance().getSettings().setMovieUiFilterPresets(uiFilters);
                        MovieModuleManager.getInstance().getSettings().saveSettings();
                        this.loadPresets();
                        this.cbPreset.setSelectedItem(savedPreset);
                        this.cbPreset.addActionListener(actionListener);
                    }
                });
                popupPanel.setContent(filterSavePanel);
                this.showModalPopupPanel(popupPanel);
            }
        });
        panelFilterPreset.add((Component)btnSavePreset, "cell 2 3");
        FlatButton btnDeletePreset = new FlatButton(IconManager.DELETE_GRAY);
        btnDeletePreset.setToolTipText(TmmResourceBundle.getString("filter.remove"));
        btnDeletePreset.addActionListener(e -> {
            HashMap<String, List<AbstractSettings.UIFilters>> movieUiFilters;
            String filterName = (String)this.cbPreset.getSelectedItem();
            if (StringUtils.isBlank((CharSequence)filterName)) {
                return;
            }
            if (Boolean.FALSE.equals(TmmProperties.getInstance().getPropertyAsBoolean("movie.hidefilterhint"))) {
                JCheckBox checkBox = new JCheckBox(TmmResourceBundle.getString("tmm.donotshowagain"));
                TmmFontHelper.changeFont((JComponent)checkBox, 0.91667);
                checkBox.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
                Object[] options = new Object[]{TmmResourceBundle.getString("Button.yes"), TmmResourceBundle.getString("Button.no")};
                Object[] params = new Object[]{TmmResourceBundle.getString("filter.remove"), checkBox};
                int answer = JOptionPane.showOptionDialog(MainWindow.getInstance(), params, TmmResourceBundle.getString("filter.remove"), 0, 3, null, options, null);
                if (checkBox.isSelected()) {
                    TmmProperties.getInstance().putProperty("movie.hidefilterhint", String.valueOf(checkBox.isSelected()));
                }
                if (answer != 0) {
                    return;
                }
            }
            if ((movieUiFilters = new HashMap<String, List<AbstractSettings.UIFilters>>(MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets())).remove(filterName) != null) {
                this.cbPreset.removeActionListener(actionListener);
                MovieModuleManager.getInstance().getSettings().setMovieUiFilterPresets(movieUiFilters);
                MovieModuleManager.getInstance().getSettings().saveSettings();
                this.loadPresets();
                this.cbPreset.addActionListener(actionListener);
            }
        });
        panelFilterPreset.add((Component)btnDeletePreset, "cell 2 3");
        this.getContentPane().add((Component)panelFilterPreset, "South");
        this.loadPresets();
        this.cbPreset.addActionListener(actionListener);
    }

    private JPanel createTabPanel(JPanel content) {
        JPanel panel = new JPanel((LayoutManager)new MigLayout("insets 0", "[grow][]", "[][][]"));
        panel.add((Component)new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.filterby")), "cell 0 0");
        panel.add((Component)new JLabel(TmmResourceBundle.getString("filter.reset")), "cell 1 0, right");
        panel.add((Component)new FlatButton(IconManager.DELETE, e -> SwingUtilities.invokeLater(this.selectionModel::clearFilters)), "cell 1 0, right");
        NoBorderScrollPane scrollPane = new NoBorderScrollPane(content);
        scrollPane.setHorizontalScrollBarPolicy(31);
        scrollPane.getVerticalScrollBar().setUnitIncrement(4);
        panel.add((Component)scrollPane, "cell 0 2 2 1, grow, wrap");
        return panel;
    }

    private Set<AbstractSettings.UIFilters> getActiveUiFilters() {
        return new HashSet<AbstractSettings.UIFilters>(IMovieUIFilter.morphToUiFilters(this.filters));
    }

    private void loadPresets() {
        String preset = (String)this.cbPreset.getSelectedItem();
        this.cbPreset.removeAllItems();
        this.cbPreset.addItem("");
        MovieModuleManager.getInstance().getSettings().getMovieUiFilterPresets().keySet().stream().sorted().forEach(key -> this.cbPreset.addItem((String)key));
        if (StringUtils.isNotBlank((CharSequence)preset)) {
            this.cbPreset.setSelectedItem(preset);
        }
    }

    private void addFilter(IMovieUIFilter filter, JPanel panel) {
        panel.add((Component)filter.getCheckBox(), "");
        panel.add((Component)filter.getLabel(), "");
        if (filter.getFilterOptionComboBox() != null) {
            panel.add(filter.getFilterOptionComboBox(), "");
        } else {
            panel.add(Box.createGlue(), "");
        }
        if (filter.getFilterComponent() != null) {
            panel.add((Component)filter.getFilterComponent(), "wmin 100, grow, wrap");
        } else {
            panel.add(Box.createGlue(), "wrap");
        }
        this.filterMap.computeIfAbsent(panel, k -> new HashSet()).add(filter);
        this.filters.add(filter);
        this.selectionModel.addFilter(filter);
    }

    private void filterChanged() {
        block3: for (Map.Entry<JPanel, Set<IMovieUIFilter>> entry : this.filterMap.entrySet()) {
            boolean active = false;
            if (this.chkbxEnableAll.isSelected()) {
                for (IMovieUIFilter filter : entry.getValue()) {
                    switch (filter.getFilterState()) {
                        case ACTIVE: 
                        case ACTIVE_NEGATIVE: {
                            active = true;
                            break;
                        }
                    }
                    if (!active) continue;
                    break;
                }
            }
            for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
                if (!SwingUtilities.isDescendingFrom(entry.getKey(), this.tabbedPane.getComponentAt(i))) continue;
                if (active) {
                    this.tabbedPane.setIconAt(i, IconManager.FILTER_ACTIVE);
                    continue block3;
                }
                this.tabbedPane.setIconAt(i, null);
                continue block3;
            }
        }
    }

    @Override
    protected void initBottomPanel() {
    }
}

