/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.table;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.table.TableModel;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.scraper.ScraperType;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.table.TmmEditorTable;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.table.TmmTableModel;
import org.tinymediamanager.ui.panels.IModalPopupPanelProvider;
import org.tinymediamanager.ui.panels.IdEditorPanel;
import org.tinymediamanager.ui.panels.ModalPopupPanel;

public class MediaIdTable
extends TmmEditorTable {
    private final EventList<MediaId> idList;
    private final ScraperType scraperType;

    public MediaIdTable(EventList<MediaId> idList) {
        this(idList, null);
    }

    public MediaIdTable(EventList<MediaId> ids, ScraperType type) {
        this.idList = ids;
        this.scraperType = type;
        this.setModel((TableModel)((Object)new TmmTableModel<MediaId>(this.idList, new MediaIdTableFormat())));
        this.setTableHeader(null);
    }

    @NotNull
    public static EventList<MediaId> convertIdMapToEventList(@NotNull Map<String, Object> idMap) {
        BasicEventList idList = new BasicEventList();
        for (Map.Entry<String, Object> entry : idMap.entrySet()) {
            MediaId id = new MediaId();
            id.key = entry.getKey();
            try {
                id.value = entry.getValue().toString();
            }
            catch (Exception e) {
                id.value = "";
            }
            idList.add((Object)id);
        }
        return idList;
    }

    @Override
    protected void editButtonClicked(int row) {
        IModalPopupPanelProvider iModalPopupPanelProvider = IModalPopupPanelProvider.findModalProvider(this);
        if (iModalPopupPanelProvider == null) {
            return;
        }
        int index = this.convertRowIndexToModel(row);
        MediaId mediaId = (MediaId)this.idList.get(index);
        ModalPopupPanel popupPanel = iModalPopupPanelProvider.createModalPopupPanel();
        popupPanel.setTitle(TmmResourceBundle.getString("rating.edit"));
        IdEditorPanel idEditorPanel = new IdEditorPanel(mediaId, this.scraperType);
        popupPanel.setContent(idEditorPanel);
        iModalPopupPanelProvider.showModalPopupPanel(popupPanel);
    }

    private static class MediaIdTableFormat
    extends TmmTableFormat<MediaId> {
        public MediaIdTableFormat() {
            TmmTableFormat.Column col = new TmmTableFormat.Column(this, "", "key", mediaId -> mediaId.key, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, "", "value", mediaId -> mediaId.value, String.class);
            this.addColumn(col);
            col = new TmmTableFormat.Column(this, TmmResourceBundle.getString("Button.edit"), "edit", person -> IconManager.EDIT, ImageIcon.class);
            col.setColumnResizeable(false);
            col.setHeaderIcon(IconManager.EDIT_HEADER);
            this.addColumn(col);
        }
    }

    public static class MediaId {
        public String key;
        public String value;

        public MediaId() {
        }

        public MediaId(String key) {
            this.key = key;
        }

        public int hashCode() {
            return new HashCodeBuilder(19, 31).append((Object)this.key).toHashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof MediaId)) {
                return false;
            }
            MediaId other = (MediaId)obj;
            if (obj == this) {
                return true;
            }
            return StringUtils.equals((CharSequence)this.key, (CharSequence)other.key);
        }
    }
}

