/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.config;

import java.util.Locale;

public class HostConfig {
    public final String mAddress;
    public final int mHttpPort;
    public final int mTcpPort;
    public final String mUsername;
    public final String mPassword;
    private static int DEFAULT_HTTP_PORT = 8080;

    public HostConfig(String string) {
        this(string, DEFAULT_HTTP_PORT);
    }

    public HostConfig(String string, int n) {
        this(string, n, 9090);
    }

    public HostConfig(String string, int n, int n2) {
        this(string, n, n2, null, null);
    }

    public HostConfig(String string, int n, String string2, String string3) {
        this(string, n, 9090, string2, string3);
    }

    public HostConfig(String string, String string2, String string3, String string4, String string5) {
        int n = 0;
        int n2 = 0;
        try {
            n = Integer.parseInt(string2);
            n2 = Integer.parseInt(string3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.mAddress = string;
        this.mHttpPort = n == 0 ? DEFAULT_HTTP_PORT : n;
        this.mTcpPort = n2 == 0 ? 9090 : n2;
        this.mUsername = string4;
        this.mPassword = string5;
    }

    public HostConfig(String string, int n, int n2, String string2, String string3) {
        this.mAddress = string;
        this.mHttpPort = n == 0 ? DEFAULT_HTTP_PORT : n;
        this.mTcpPort = n2 == 0 ? 9090 : n2;
        this.mUsername = string2;
        this.mPassword = string3;
    }

    public String getAddress() {
        return this.mAddress;
    }

    public int getHttpPort() {
        return this.mHttpPort;
    }

    public int getTcpPort() {
        return this.mTcpPort;
    }

    public String getUsername() {
        return this.mUsername;
    }

    public String getPassword() {
        return this.mPassword;
    }

    static {
        if (System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("windows")) {
            DEFAULT_HTTP_PORT = 80;
        }
    }
}

