/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.filenaming;

import java.io.File;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.tvshow.ITvShowSeasonFileNaming;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowSeason;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum TvShowSeasonNfoNaming implements ITvShowSeasonFileNaming
{
    SEASON{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            Object filename = tvShowSeason.getSeason() == -1 ? "" : (tvShowSeason.getSeason() == 0 && TvShowModuleManager.getInstance().getSettings().isSpecialSeason() ? "season-specials." + extension : (tvShowSeason.getSeason() > -1 ? String.format("season%02d.%s", tvShowSeason.getSeason(), extension) : ""));
            return filename;
        }
    }
    ,
    SEASON_FOLDER{

        @Override
        public String getFilename(TvShowSeason tvShowSeason, String extension, boolean forRenamer) {
            TvShow tvShow = tvShowSeason.getTvShow();
            if (tvShow == null) {
                return "";
            }
            String seasonFoldername = this.getSeasonFolder(tvShowSeason, forRenamer);
            if (StringUtils.isBlank((CharSequence)seasonFoldername)) {
                return SEASON.getFilename(tvShowSeason, extension, forRenamer);
            }
            return seasonFoldername + File.separator + "season." + extension;
        }
    };

}

