/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow.connector;

import java.util.List;
import java.util.Locale;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeGenericXmlConnector;
import org.tinymediamanager.core.tvshow.connector.TvShowEpisodeNfoParser;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.MediaMetadata;
import org.w3c.dom.Element;

public class TvShowEpisodeToKodiConnector
extends TvShowEpisodeGenericXmlConnector {
    public TvShowEpisodeToKodiConnector(List<TvShowEpisode> episodes) {
        super(episodes);
    }

    @Override
    protected void addRating(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element ratings = this.document.createElement("ratings");
        MediaRating mainMediaRating = episode.getRating();
        if (mainMediaRating != MediaMetadata.EMPTY_RATING) {
            Element rating = this.createRating(mainMediaRating);
            rating.setAttribute("default", "true");
            ratings.appendChild(rating);
        }
        for (MediaRating mediaRating : episode.getRatings().values()) {
            if (mediaRating == mainMediaRating || "user".equals(mediaRating.getId())) continue;
            ratings.appendChild(this.createRating(mediaRating));
        }
        this.root.appendChild(ratings);
    }

    private Element createRating(MediaRating mediaRating) {
        Element rating = this.document.createElement("rating");
        if ("tmdb".equals(mediaRating.getId())) {
            rating.setAttribute("name", "themoviedb");
        } else {
            rating.setAttribute("name", mediaRating.getId());
        }
        rating.setAttribute("max", String.valueOf(mediaRating.getMaxValue()));
        rating.setAttribute("default", "false");
        Element value = this.document.createElement("value");
        value.setTextContent(String.format(Locale.US, "%.1f", Float.valueOf(mediaRating.getRating())));
        rating.appendChild(value);
        Element votes = this.document.createElement("votes");
        votes.setTextContent(Integer.toString(mediaRating.getVotes()));
        rating.appendChild(votes);
        return rating;
    }

    @Override
    protected void addVotes(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
    }

    @Override
    protected void addOwnTags(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        this.addEpbookmark(episode, parser);
        this.addCode(episode, parser);
    }

    protected void addEpbookmark(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element epbookmark = this.document.createElement("epbookmark");
        if (parser != null) {
            epbookmark.setTextContent(parser.epbookmark);
        }
        this.root.appendChild(epbookmark);
    }

    protected void addCode(TvShowEpisode episode, TvShowEpisodeNfoParser.Episode parser) {
        Element code = this.document.createElement("code");
        if (parser != null) {
            code.setTextContent(parser.code);
        }
        this.root.appendChild(code);
    }
}

