/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.tinymediamanager.scraper.util.StrgUtils;

public class MediaRating {
    public static final String NFO = "NFO";
    public static final String DEFAULT = "default";
    public static final String USER = "user";
    @JsonProperty
    private String id = "";
    @JsonProperty
    private float rating = -1.0f;
    @JsonProperty
    private int votes = 0;
    @JsonProperty
    private int maxValue = 10;

    public MediaRating() {
    }

    public MediaRating(MediaRating source) {
        this(source.id, source.rating, source.votes, source.maxValue);
    }

    public MediaRating(String id) {
        this.id = StrgUtils.getNonNullString(id);
    }

    public MediaRating(String id, float rating) {
        this(id);
        this.setRating(rating);
    }

    public MediaRating(String id, float rating, int votes) {
        this(id, rating);
        this.setVotes(votes);
    }

    public MediaRating(String id, float rating, int votes, int maxValue) {
        this(id, rating, votes);
        if (maxValue > 0) {
            this.setMaxValue(maxValue);
        }
    }

    public MediaRating(String id, double rating, int votes, int maxValue) {
        this(id, (float)rating, votes);
        if (maxValue > 0) {
            this.setMaxValue(maxValue);
        }
    }

    public String getId() {
        return this.id;
    }

    public float getRating() {
        return this.rating;
    }

    public void setRating(float rating) {
        this.rating = (float)Math.round(rating * 10.0f) / 10.0f;
        if (this.maxValue == 10 && this.rating > 10.0f) {
            this.setMaxValue(100);
        }
    }

    public void setRating(double rating) {
        this.setRating((float)rating);
    }

    public int getVotes() {
        return this.votes;
    }

    public void setVotes(int votes) {
        this.votes = votes;
    }

    public int getMaxValue() {
        return this.maxValue;
    }

    public void setMaxValue(int maxValue) {
        this.maxValue = maxValue;
        if (this.maxValue == 10 && this.rating > 10.0f) {
            this.maxValue = 100;
        }
    }

    public float getRatingNormalized() {
        if (this.maxValue != 0) {
            return this.rating * 10.0f / (float)this.maxValue;
        }
        return 0.0f;
    }

    public void setRatingNormalized(float rating) {
        if (rating < 0.0f || rating > 10.0f) {
            return;
        }
        this.rating = rating;
        this.maxValue = 10;
    }

    public String toString() {
        return String.format("%s - %.2f/%d", this.id, Float.valueOf(this.rating), this.maxValue);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        return 31 * result + (this.id == null ? 0 : this.id.hashCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaRating other = (MediaRating)obj;
        if (this.id == null) {
            return other.id == null;
        }
        return this.id.equals(other.id);
    }
}

