/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.TrailerSourcesDeserializer;

@JsonDeserialize(using=TrailerSourcesDeserializer.class)
public enum TrailerSources {
    YOUTUBE("Youtube", Collections.singletonList("youtube")),
    IMDB("IMDb", Collections.singletonList("imdb"));

    private final String displayText;
    private final List<String> possibleSources;

    private TrailerSources(String text, List<String> sources) {
        this.displayText = text;
        this.possibleSources = sources;
    }

    public boolean containsSource(String source) {
        if (StringUtils.isBlank((CharSequence)source)) {
            return false;
        }
        for (String s : this.possibleSources) {
            if (!source.equalsIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static TrailerSources[] getActiveTrailerSources() {
        return new TrailerSources[]{YOUTUBE, IMDB};
    }

    public String toString() {
        return this.displayText;
    }
}

