/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer.tracks.h264;

import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.mp4parser.Box;
import org.mp4parser.boxes.iso14496.part12.CompositionTimeToSample;
import org.mp4parser.boxes.iso14496.part12.SampleDependencyTypeBox;
import org.mp4parser.boxes.iso14496.part15.AvcConfigurationBox;
import org.mp4parser.boxes.sampleentry.SampleEntry;
import org.mp4parser.boxes.sampleentry.VisualSampleEntry;
import org.mp4parser.muxer.DataSource;
import org.mp4parser.muxer.FileDataSourceImpl;
import org.mp4parser.muxer.Sample;
import org.mp4parser.muxer.tracks.AbstractH26XTrack;
import org.mp4parser.muxer.tracks.h264.H264NalUnitHeader;
import org.mp4parser.muxer.tracks.h264.SEIMessage;
import org.mp4parser.muxer.tracks.h264.SliceHeader;
import org.mp4parser.muxer.tracks.h264.parsing.model.PictureParameterSet;
import org.mp4parser.muxer.tracks.h264.parsing.model.SeqParameterSet;
import org.mp4parser.tools.Mp4Arrays;
import org.mp4parser.tools.RangeStartMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class H264TrackImpl
extends AbstractH26XTrack {
    private static Logger LOG = LoggerFactory.getLogger((String)H264TrackImpl.class.getName());
    Map<Integer, ByteBuffer> spsIdToSpsBytes = new HashMap<Integer, ByteBuffer>();
    Map<Integer, SeqParameterSet> spsIdToSps = new HashMap<Integer, SeqParameterSet>();
    Map<Integer, ByteBuffer> ppsIdToPpsBytes = new HashMap<Integer, ByteBuffer>();
    Map<Integer, PictureParameterSet> ppsIdToPps = new HashMap<Integer, PictureParameterSet>();
    SeqParameterSet firstSeqParameterSet = null;
    PictureParameterSet firstPictureParameterSet = null;
    SeqParameterSet currentSeqParameterSet = null;
    PictureParameterSet currentPictureParameterSet = null;
    RangeStartMap<Integer, ByteBuffer> seqParameterRangeMap = new RangeStartMap();
    RangeStartMap<Integer, ByteBuffer> pictureParameterRangeMap = new RangeStartMap();
    int frameNrInGop = 0;
    int[] pictureOrderCounts = new int[0];
    int prevPicOrderCntLsb = 0;
    int prevPicOrderCntMsb = 0;
    long psize = 0L;
    long pcount = 0L;
    long bsize = 0L;
    long bcount = 0L;
    long isize = 0L;
    long icount = 0L;
    private List<Sample> samples;
    private int width;
    private int height;
    private long timescale;
    private int frametick;
    private SEIMessage seiMessage;
    private boolean determineFrameRate = true;
    private String lang = "eng";
    VisualSampleEntry visualSampleEntry;

    @Override
    protected SampleEntry getCurrentSampleEntry() {
        return this.visualSampleEntry;
    }

    public H264TrackImpl(DataSource dataSource, String lang, long timescale, int frametick) throws IOException {
        super(dataSource);
        this.lang = lang;
        this.timescale = timescale;
        this.frametick = frametick;
        if (timescale > 0L && frametick > 0) {
            this.determineFrameRate = false;
        }
        this.parse(new AbstractH26XTrack.LookAhead(dataSource));
    }

    public H264TrackImpl(DataSource dataSource, String lang) throws IOException {
        this(dataSource, lang, -1L, -1);
    }

    public H264TrackImpl(DataSource dataSource) throws IOException {
        this(dataSource, "eng");
    }

    public static void main(String[] args) throws IOException {
        new H264TrackImpl(new FileDataSourceImpl("C:\\dev\\mp4parser\\tos.264"));
    }

    public static H264NalUnitHeader getNalUnitHeader(ByteBuffer nal) {
        H264NalUnitHeader nalUnitHeader = new H264NalUnitHeader();
        byte type = nal.get(0);
        nalUnitHeader.nal_ref_idc = type >> 5 & 3;
        nalUnitHeader.nal_unit_type = type & 0x1F;
        return nalUnitHeader;
    }

    private void parse(AbstractH26XTrack.LookAhead la) throws IOException {
        this.visualSampleEntry = new VisualSampleEntry("avc1");
        this.visualSampleEntry.setDataReferenceIndex(1);
        this.visualSampleEntry.setDepth(24);
        this.visualSampleEntry.setFrameCount(1);
        this.visualSampleEntry.setHorizresolution(72.0);
        this.visualSampleEntry.setVertresolution(72.0);
        this.visualSampleEntry.setWidth(this.width);
        this.visualSampleEntry.setHeight(this.height);
        this.visualSampleEntry.setCompressorname("AVC Coding");
        this.samples = new ArrayList<Sample>();
        if (!this.readSamples(la)) {
            throw new IOException();
        }
        if (!this.readVariables()) {
            throw new IOException();
        }
        AvcConfigurationBox avcConfigurationBox = new AvcConfigurationBox();
        avcConfigurationBox.setSequenceParameterSets(new ArrayList<ByteBuffer>(this.spsIdToSpsBytes.values()));
        avcConfigurationBox.setPictureParameterSets(new ArrayList<ByteBuffer>(this.ppsIdToPpsBytes.values()));
        avcConfigurationBox.setAvcLevelIndication(this.firstSeqParameterSet.level_idc);
        avcConfigurationBox.setAvcProfileIndication(this.firstSeqParameterSet.profile_idc);
        avcConfigurationBox.setBitDepthLumaMinus8(this.firstSeqParameterSet.bit_depth_luma_minus8);
        avcConfigurationBox.setBitDepthChromaMinus8(this.firstSeqParameterSet.bit_depth_chroma_minus8);
        avcConfigurationBox.setChromaFormat(this.firstSeqParameterSet.chroma_format_idc.getId());
        avcConfigurationBox.setConfigurationVersion(1);
        avcConfigurationBox.setLengthSizeMinusOne(3);
        avcConfigurationBox.setProfileCompatibility((this.firstSeqParameterSet.constraint_set_0_flag ? 128 : 0) + (this.firstSeqParameterSet.constraint_set_1_flag ? 64 : 0) + (this.firstSeqParameterSet.constraint_set_2_flag ? 32 : 0) + (this.firstSeqParameterSet.constraint_set_3_flag ? 16 : 0) + (this.firstSeqParameterSet.constraint_set_4_flag ? 8 : 0) + (int)(this.firstSeqParameterSet.reserved_zero_2bits & 3L));
        this.visualSampleEntry.addBox((Box)avcConfigurationBox);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setLanguage(this.lang);
        this.trackMetaData.setTimescale(this.timescale);
        this.trackMetaData.setWidth(this.width);
        this.trackMetaData.setHeight(this.height);
    }

    @Override
    public List<SampleEntry> getSampleEntries() {
        return Collections.singletonList(this.visualSampleEntry);
    }

    @Override
    public String getHandler() {
        return "vide";
    }

    @Override
    public List<Sample> getSamples() {
        return this.samples;
    }

    private boolean readVariables() {
        this.width = (this.firstSeqParameterSet.pic_width_in_mbs_minus1 + 1) * 16;
        int mult = 2;
        if (this.firstSeqParameterSet.frame_mbs_only_flag) {
            mult = 1;
        }
        this.height = 16 * (this.firstSeqParameterSet.pic_height_in_map_units_minus1 + 1) * mult;
        if (this.firstSeqParameterSet.frame_cropping_flag) {
            int chromaArrayType = 0;
            if (!this.firstSeqParameterSet.residual_color_transform_flag) {
                chromaArrayType = this.firstSeqParameterSet.chroma_format_idc.getId();
            }
            int cropUnitX = 1;
            int cropUnitY = mult;
            if (chromaArrayType != 0) {
                cropUnitX = this.firstSeqParameterSet.chroma_format_idc.getSubWidth();
                cropUnitY = this.firstSeqParameterSet.chroma_format_idc.getSubHeight() * mult;
            }
            this.width -= cropUnitX * (this.firstSeqParameterSet.frame_crop_left_offset + this.firstSeqParameterSet.frame_crop_right_offset);
            this.height -= cropUnitY * (this.firstSeqParameterSet.frame_crop_top_offset + this.firstSeqParameterSet.frame_crop_bottom_offset);
        }
        return true;
    }

    private boolean readSamples(AbstractH26XTrack.LookAhead la) throws IOException {
        ByteBuffer nal;
        ArrayList<ByteBuffer> buffered = new ArrayList<ByteBuffer>();
        class FirstVclNalDetector {
            int frame_num;
            int pic_parameter_set_id;
            boolean field_pic_flag;
            boolean bottom_field_flag;
            int nal_ref_idc;
            int pic_order_cnt_type;
            int delta_pic_order_cnt_bottom;
            int pic_order_cnt_lsb;
            int delta_pic_order_cnt_0;
            int delta_pic_order_cnt_1;
            boolean idrPicFlag;
            int idr_pic_id;

            public FirstVclNalDetector(ByteBuffer nal, int nal_ref_idc, int nal_unit_type) {
                InputStream bs = H264TrackImpl.cleanBuffer(new ByteBufferBackedInputStream(nal));
                SliceHeader sh = new SliceHeader(bs, H264TrackImpl.this.spsIdToSps, H264TrackImpl.this.ppsIdToPps, nal_unit_type == 5);
                this.frame_num = sh.frame_num;
                this.pic_parameter_set_id = sh.pic_parameter_set_id;
                this.field_pic_flag = sh.field_pic_flag;
                this.bottom_field_flag = sh.bottom_field_flag;
                this.nal_ref_idc = nal_ref_idc;
                this.pic_order_cnt_type = H264TrackImpl.this.spsIdToSps.get((Object)Integer.valueOf((int)H264TrackImpl.this.ppsIdToPps.get((Object)Integer.valueOf((int)sh.pic_parameter_set_id)).seq_parameter_set_id)).pic_order_cnt_type;
                this.delta_pic_order_cnt_bottom = sh.delta_pic_order_cnt_bottom;
                this.pic_order_cnt_lsb = sh.pic_order_cnt_lsb;
                this.delta_pic_order_cnt_0 = sh.delta_pic_order_cnt_0;
                this.delta_pic_order_cnt_1 = sh.delta_pic_order_cnt_1;
                this.idr_pic_id = sh.idr_pic_id;
            }

            boolean isFirstInNew(FirstVclNalDetector nu) {
                if (nu.frame_num != this.frame_num) {
                    return true;
                }
                if (nu.pic_parameter_set_id != this.pic_parameter_set_id) {
                    return true;
                }
                if (nu.field_pic_flag != this.field_pic_flag) {
                    return true;
                }
                if (nu.field_pic_flag && nu.bottom_field_flag != this.bottom_field_flag) {
                    return true;
                }
                if (nu.nal_ref_idc != this.nal_ref_idc) {
                    return true;
                }
                if (nu.pic_order_cnt_type == 0 && this.pic_order_cnt_type == 0) {
                    if (nu.pic_order_cnt_lsb != this.pic_order_cnt_lsb) {
                        return true;
                    }
                    if (nu.delta_pic_order_cnt_bottom != this.delta_pic_order_cnt_bottom) {
                        return true;
                    }
                }
                if (nu.pic_order_cnt_type == 1 && this.pic_order_cnt_type == 1) {
                    if (nu.delta_pic_order_cnt_0 != this.delta_pic_order_cnt_0) {
                        return true;
                    }
                    if (nu.delta_pic_order_cnt_1 != this.delta_pic_order_cnt_1) {
                        return true;
                    }
                }
                if (nu.idrPicFlag != this.idrPicFlag) {
                    return true;
                }
                return nu.idrPicFlag && this.idrPicFlag && nu.idr_pic_id != this.idr_pic_id;
            }
        }
        FirstVclNalDetector fvnd = null;
        block9: while ((nal = this.findNextNal(la)) != null) {
            H264NalUnitHeader nalUnitHeader = H264TrackImpl.getNalUnitHeader(nal);
            switch (nalUnitHeader.nal_unit_type) {
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    FirstVclNalDetector current = new FirstVclNalDetector(nal, nalUnitHeader.nal_ref_idc, nalUnitHeader.nal_unit_type);
                    if (fvnd != null && fvnd.isFirstInNew(current)) {
                        LOG.debug("Wrapping up cause of first vcl nal is found");
                        this.createSample(buffered);
                    }
                    fvnd = current;
                    buffered.add((ByteBuffer)((Buffer)nal).rewind());
                    continue block9;
                }
                case 6: {
                    if (fvnd != null) {
                        LOG.debug("Wrapping up cause of SEI after vcl marks new sample");
                        this.createSample(buffered);
                        fvnd = null;
                    }
                    this.seiMessage = new SEIMessage(H264TrackImpl.cleanBuffer(new ByteBufferBackedInputStream(nal)), this.currentSeqParameterSet);
                    buffered.add(nal);
                    continue block9;
                }
                case 9: {
                    if (fvnd != null) {
                        LOG.debug("Wrapping up cause of AU after vcl marks new sample");
                        this.createSample(buffered);
                        fvnd = null;
                    }
                    buffered.add(nal);
                    continue block9;
                }
                case 7: {
                    if (fvnd != null) {
                        LOG.debug("Wrapping up cause of SPS after vcl marks new sample");
                        this.createSample(buffered);
                        fvnd = null;
                    }
                    this.handleSPS((ByteBuffer)((Buffer)nal).rewind());
                    continue block9;
                }
                case 8: {
                    if (fvnd != null) {
                        LOG.debug("Wrapping up cause of PPS after vcl marks new sample");
                        this.createSample(buffered);
                        fvnd = null;
                    }
                    this.handlePPS((ByteBuffer)((Buffer)nal).rewind());
                    continue block9;
                }
                case 10: 
                case 11: {
                    break block9;
                }
                case 13: {
                    throw new RuntimeException("Sequence parameter set extension is not yet handled. Needs TLC.");
                }
                default: {
                    LOG.warn("Unknown NAL unit type: " + nalUnitHeader.nal_unit_type);
                    continue block9;
                }
            }
        }
        if (buffered.size() > 0) {
            this.createSample(buffered);
        }
        this.calcCtts();
        this.decodingTimes = new long[this.samples.size()];
        Arrays.fill(this.decodingTimes, (long)this.frametick);
        return true;
    }

    public void calcCtts() {
        int pTime = 0;
        int lastPoc = -1;
        for (int j = 0; j < this.pictureOrderCounts.length; ++j) {
            int minIndex = 0;
            int minValue = Integer.MAX_VALUE;
            for (int i = Math.max(0, j - 128); i < Math.min(this.pictureOrderCounts.length, j + 128); ++i) {
                if (this.pictureOrderCounts[i] <= lastPoc || this.pictureOrderCounts[i] >= minValue) continue;
                minIndex = i;
                minValue = this.pictureOrderCounts[i];
            }
            lastPoc = this.pictureOrderCounts[minIndex];
            this.pictureOrderCounts[minIndex] = pTime++;
        }
        for (int i = 0; i < this.pictureOrderCounts.length; ++i) {
            this.ctts.add(new CompositionTimeToSample.Entry(1, this.pictureOrderCounts[i] - i));
        }
        this.pictureOrderCounts = new int[0];
    }

    long getSize(List<ByteBuffer> buffered) {
        long i = 0L;
        for (ByteBuffer byteBuffer : buffered) {
            i += (long)byteBuffer.remaining();
        }
        return i;
    }

    private void createSample(List<ByteBuffer> buffered) throws IOException {
        SampleDependencyTypeBox.Entry sampleDependency = new SampleDependencyTypeBox.Entry(0);
        boolean IdrPicFlag = false;
        H264NalUnitHeader nu = null;
        ByteBuffer slice = null;
        for (ByteBuffer nal : buffered) {
            H264NalUnitHeader _nu = H264TrackImpl.getNalUnitHeader(nal);
            switch (_nu.nal_unit_type) {
                case 5: {
                    IdrPicFlag = true;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    nu = _nu;
                    slice = nal;
                }
            }
        }
        if (nu == null) {
            LOG.warn("Sample without Slice");
            return;
        }
        assert (slice != null);
        if (IdrPicFlag) {
            this.calcCtts();
        }
        InputStream bs = H264TrackImpl.cleanBuffer(new ByteBufferBackedInputStream(slice));
        SliceHeader sh = new SliceHeader(bs, this.spsIdToSps, this.ppsIdToPps, IdrPicFlag);
        if (sh.slice_type == SliceHeader.SliceType.I || sh.slice_type == SliceHeader.SliceType.SI) {
            this.isize += this.getSize(buffered);
            ++this.icount;
        } else if (sh.slice_type == SliceHeader.SliceType.P || sh.slice_type == SliceHeader.SliceType.SP) {
            this.psize += this.getSize(buffered);
            ++this.pcount;
        } else if (sh.slice_type == SliceHeader.SliceType.B) {
            this.bsize += this.getSize(buffered);
            ++this.bcount;
        } else {
            throw new RuntimeException("_sdjlfd");
        }
        if (nu.nal_ref_idc == 0) {
            sampleDependency.setSampleIsDependedOn(2);
        } else {
            sampleDependency.setSampleIsDependedOn(1);
        }
        if (sh.slice_type == SliceHeader.SliceType.I || sh.slice_type == SliceHeader.SliceType.SI) {
            sampleDependency.setSampleDependsOn(2);
        } else {
            sampleDependency.setSampleDependsOn(1);
        }
        Sample bb = this.createSampleObject(buffered);
        buffered.clear();
        if (this.seiMessage == null || this.seiMessage.n_frames == 0) {
            this.frameNrInGop = 0;
        }
        if (sh.sps.pic_order_cnt_type == 0) {
            int max_pic_order_count_lsb = 1 << sh.sps.log2_max_pic_order_cnt_lsb_minus4 + 4;
            int picOrderCountLsb = sh.pic_order_cnt_lsb;
            int picOrderCntMsb = picOrderCountLsb < this.prevPicOrderCntLsb && this.prevPicOrderCntLsb - picOrderCountLsb >= max_pic_order_count_lsb / 2 ? this.prevPicOrderCntMsb + max_pic_order_count_lsb : (picOrderCountLsb > this.prevPicOrderCntLsb && picOrderCountLsb - this.prevPicOrderCntLsb > max_pic_order_count_lsb / 2 ? this.prevPicOrderCntMsb - max_pic_order_count_lsb : this.prevPicOrderCntMsb);
            this.pictureOrderCounts = Mp4Arrays.copyOfAndAppend((int[])this.pictureOrderCounts, (int[])new int[]{picOrderCntMsb + picOrderCountLsb});
            this.prevPicOrderCntLsb = picOrderCountLsb;
            this.prevPicOrderCntMsb = picOrderCntMsb;
        } else {
            if (sh.sps.pic_order_cnt_type == 1) {
                throw new RuntimeException("pic_order_cnt_type == 1 needs to be implemented");
            }
            if (sh.sps.pic_order_cnt_type == 2) {
                this.pictureOrderCounts = Mp4Arrays.copyOfAndAppend((int[])this.pictureOrderCounts, (int[])new int[]{this.samples.size()});
            }
        }
        this.sdtp.add(sampleDependency);
        ++this.frameNrInGop;
        this.samples.add(bb);
        if (IdrPicFlag) {
            this.stss.add(this.samples.size());
        }
    }

    private void handlePPS(ByteBuffer data) throws IOException {
        ByteBufferBackedInputStream is = new ByteBufferBackedInputStream(data);
        ((InputStream)is).read();
        PictureParameterSet _pictureParameterSet = PictureParameterSet.read(is);
        if (this.firstPictureParameterSet == null) {
            this.firstPictureParameterSet = _pictureParameterSet;
        }
        this.currentPictureParameterSet = _pictureParameterSet;
        ByteBuffer oldPpsSameId = this.ppsIdToPpsBytes.get(_pictureParameterSet.pic_parameter_set_id);
        ((Buffer)data).rewind();
        if (oldPpsSameId != null && !oldPpsSameId.equals(data)) {
            throw new RuntimeException("OMG - I got two SPS with same ID but different settings! (AVC3 is the solution)");
        }
        if (oldPpsSameId == null) {
            this.pictureParameterRangeMap.put((Comparable)Integer.valueOf(this.samples.size()), (Object)data);
        }
        this.ppsIdToPpsBytes.put(_pictureParameterSet.pic_parameter_set_id, data);
        this.ppsIdToPps.put(_pictureParameterSet.pic_parameter_set_id, _pictureParameterSet);
    }

    private void handleSPS(ByteBuffer data) throws IOException {
        InputStream spsInputStream = H264TrackImpl.cleanBuffer(new ByteBufferBackedInputStream(data));
        spsInputStream.read();
        SeqParameterSet _seqParameterSet = SeqParameterSet.read(spsInputStream);
        if (this.firstSeqParameterSet == null) {
            this.firstSeqParameterSet = _seqParameterSet;
            this.configureFramerate();
        }
        this.currentSeqParameterSet = _seqParameterSet;
        ((Buffer)data).rewind();
        ByteBuffer oldSpsSameId = this.spsIdToSpsBytes.get(_seqParameterSet.seq_parameter_set_id);
        if (oldSpsSameId != null && !oldSpsSameId.equals(data)) {
            throw new RuntimeException("OMG - I got two SPS with same ID but different settings!");
        }
        if (oldSpsSameId != null) {
            this.seqParameterRangeMap.put((Comparable)Integer.valueOf(this.samples.size()), (Object)data);
        }
        this.spsIdToSpsBytes.put(_seqParameterSet.seq_parameter_set_id, data);
        this.spsIdToSps.put(_seqParameterSet.seq_parameter_set_id, _seqParameterSet);
    }

    private void configureFramerate() {
        if (this.determineFrameRate) {
            if (this.firstSeqParameterSet.vuiParams != null) {
                this.timescale = this.firstSeqParameterSet.vuiParams.time_scale >> 1;
                this.frametick = this.firstSeqParameterSet.vuiParams.num_units_in_tick;
                if (this.timescale == 0L || this.frametick == 0) {
                    LOG.warn("vuiParams contain invalid values: time_scale: " + this.timescale + " and frame_tick: " + this.frametick + ". Setting frame rate to 25fps");
                    this.timescale = 90000L;
                    this.frametick = 3600;
                }
                if (this.timescale / (long)this.frametick > 100L) {
                    LOG.warn("Framerate is " + this.timescale / (long)this.frametick + ". That is suspicious.");
                }
            } else {
                LOG.warn("Can't determine frame rate. Guessing 25 fps");
                this.timescale = 90000L;
                this.frametick = 3600;
            }
        }
    }

    public class ByteBufferBackedInputStream
    extends InputStream {
        private final ByteBuffer buf;

        public ByteBufferBackedInputStream(ByteBuffer buf) {
            this.buf = buf.duplicate();
        }

        @Override
        public int read() throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            return this.buf.get() & 0xFF;
        }

        @Override
        public int read(byte[] bytes, int off, int len) throws IOException {
            if (!this.buf.hasRemaining()) {
                return -1;
            }
            len = Math.min(len, this.buf.remaining());
            this.buf.get(bytes, off, len);
            return len;
        }
    }
}

