/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowSubtitleLanguageFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowSubtitleLanguageFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallSubtitleLanguageArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallSubtitleLanguageArray());
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<String> epLang = episode.getMediaInfoSubtitleLanguageList();
            for (String sel : selectedItems) {
                if (!(invert ^ epLang.contains(sel))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.subtitlelanguage"));
    }

    @Override
    public String getId() {
        return "tvShowSubtitleLanguage";
    }

    private void buildAndInstallSubtitleLanguageArray() {
        HashSet<String> subtitleLanguagesInEpisodes = new HashSet<String>(this.tvShowList.getSubtitleLanguagesInEpisodes());
        if (!SetUtils.equals(this.oldValues, subtitleLanguagesInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(subtitleLanguagesInEpisodes);
            List<String> sortedSubtitleLanguages = ListUtils.asSortedList(subtitleLanguagesInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedSubtitleLanguages));
        }
    }
}

