/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractTvShowUIFilter;

public class TvShowDuplicateEpisodesFilter
extends AbstractTvShowUIFilter {
    private final TvShowList tvShowList = TvShowModuleManager.getInstance().getTvShowList();

    @Override
    protected void filterChanged() {
        this.tvShowList.searchDuplicateEpisodes();
        super.filterChanged();
    }

    @Override
    public String getId() {
        return "tvShowDuplicateEpisodes";
    }

    @Override
    public String getFilterValueAsString() {
        return null;
    }

    @Override
    public void setFilterValue(Object value) {
        this.tvShowList.searchDuplicateEpisodes();
    }

    @Override
    public void clearFilter() {
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        if (invert ^ tvShow.isDuplicate()) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            if (!(invert ^ episode.isDuplicate())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.duplicates"));
    }

    @Override
    protected JComponent createFilterComponent() {
        return null;
    }
}

