/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets.filters;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.MovieSettings;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.moviesets.filters.AbstractCheckComboBoxMovieSetUIFilter;

public class MovieSetDatasourceFilter
extends AbstractCheckComboBoxMovieSetUIFilter<String> {
    private final MovieSettings movieSettings = MovieModuleManager.getInstance().getSettings();

    public MovieSetDatasourceFilter() {
        this.buildAndInstallDatasourceArray();
        this.movieSettings.addPropertyChangeListener("dataSource", evt -> this.buildAndInstallDatasourceArray());
    }

    @Override
    public String getId() {
        return "movieSetDatasource";
    }

    @Override
    public boolean accept(MovieSet movieSet, List<Movie> movies) {
        List datasources = this.checkComboBox.getSelectedItems();
        for (Movie movie : movies) {
            if (!datasources.contains(movie.getDataSource())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.datasource"));
    }

    private void buildAndInstallDatasourceArray() {
        this.setValues(new ArrayList<String>(this.movieSettings.getMovieDataSource()));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

