/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.tvmaze;

import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.entities.MediaGenres;
import org.tinymediamanager.core.entities.MediaRating;
import org.tinymediamanager.core.entities.Person;
import org.tinymediamanager.core.tvshow.TvShowEpisodeSearchAndScrapeOptions;
import org.tinymediamanager.core.tvshow.TvShowSearchAndScrapeOptions;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.MediaProviderInfo;
import org.tinymediamanager.scraper.MediaSearchResult;
import org.tinymediamanager.scraper.entities.BaseJsonEntity;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaEpisodeGroup;
import org.tinymediamanager.scraper.entities.MediaEpisodeNumber;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.MissingIdException;
import org.tinymediamanager.scraper.exceptions.NothingFoundException;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.interfaces.ITvShowArtworkProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowImdbMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowMetadataProvider;
import org.tinymediamanager.scraper.interfaces.ITvShowTvdbMetadataProvider;
import org.tinymediamanager.scraper.tvmaze.TvMazeMetadataProvider;
import org.tinymediamanager.scraper.tvmaze.entities.AlternateList;
import org.tinymediamanager.scraper.tvmaze.entities.Cast;
import org.tinymediamanager.scraper.tvmaze.entities.Crew;
import org.tinymediamanager.scraper.tvmaze.entities.Episode;
import org.tinymediamanager.scraper.tvmaze.entities.Image;
import org.tinymediamanager.scraper.tvmaze.entities.SearchResult;
import org.tinymediamanager.scraper.tvmaze.entities.Season;
import org.tinymediamanager.scraper.tvmaze.entities.Show;

public class TvMazeTvShowMetadataProvider
extends TvMazeMetadataProvider
implements ITvShowMetadataProvider,
ITvShowArtworkProvider,
ITvShowImdbMetadataProvider,
ITvShowTvdbMetadataProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvMazeTvShowMetadataProvider.class);
    private final DateFormat premieredFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.ENGLISH);

    @Override
    public MediaProviderInfo getProviderInfo() {
        return this.providerInfo;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowSearchAndScrapeOptions options) throws ScrapeException {
        Map<Integer, MediaEpisodeGroup> egs;
        Person person;
        LOGGER.debug("getMetadata(): {}", (Object)options);
        this.initAPI();
        MediaMetadata md = new MediaMetadata(this.getId());
        md.setScrapeOptions(options);
        int tvMazeId = options.getIdAsIntOrDefault("tvmaze", 0);
        if (tvMazeId == 0) {
            LOGGER.debug("no show id available");
            throw new MissingIdException(new String[]{"tvmaze"});
        }
        Show show = null;
        LOGGER.debug("========= BEGIN TVMAZE Scraping");
        try {
            show = this.controller.getMainInformation(tvMazeId);
        }
        catch (IOException e) {
            LOGGER.trace("could not get Main TvShow information: {}", (Object)e.getMessage());
        }
        if (show == null) {
            throw new NothingFoundException();
        }
        md.setId("tvmaze", show.id);
        md.setId("imdb", show.externals.imdb);
        md.setId("tvdb", show.externals.thetvdb);
        md.setId("tvrage", show.externals.tvrage);
        md.addEpisodeGroup(MediaEpisodeGroup.DEFAULT_AIRED);
        md.setTitle(show.name);
        try {
            md.setYear(this.parseYear(show.premiered));
        }
        catch (Exception e) {
            LOGGER.trace("could not parse year: {}", (Object)e.getMessage());
        }
        try {
            md.setReleaseDate(this.premieredFormat.parse(show.premiered));
        }
        catch (Exception e) {
            LOGGER.trace("could not parse releasedate: {}", (Object)e.getMessage());
        }
        md.setRuntime(show.runtime);
        for (String gen : show.genres) {
            MediaGenres genre = MediaGenres.getGenre(gen);
            md.addGenre(genre);
        }
        if (StringUtils.isNotBlank((CharSequence)show.summary)) {
            md.setPlot(Jsoup.parse((String)show.summary).text());
        }
        md.setOriginalLanguage(show.language);
        MediaRating rating = new MediaRating("tvmaze");
        rating.setRating(show.rating.average);
        rating.setMaxValue(10);
        md.addRating(rating);
        if (show._embedded.seasons != null) {
            HashMap<Integer, Integer> seasonMap = new HashMap<Integer, Integer>();
            for (Season season : show._embedded.seasons) {
                seasonMap.put(season.number, season.id);
                if (season.image == null) continue;
                MediaArtwork sa = new MediaArtwork("tvmaze", MediaArtwork.MediaArtworkType.SEASON_POSTER);
                sa.setOriginalUrl(season.image.original);
                sa.setPreviewUrl(season.image.medium);
                sa.setSeason(season.number);
                sa.addImageSize(0, 0, season.image.original, 0);
                md.addMediaArt(sa);
            }
            md.addExtraData("seasonMap", seasonMap);
        }
        if (show.image != null) {
            Iterator<BaseJsonEntity> ma = new MediaArtwork("tvmaze", MediaArtwork.MediaArtworkType.POSTER);
            ((MediaArtwork)((Object)ma)).setOriginalUrl(show.image.original);
            ((MediaArtwork)((Object)ma)).setPreviewUrl(show.image.medium);
            ((MediaArtwork)((Object)ma)).addImageSize(0, 0, show.image.original, 0);
            md.addMediaArt((MediaArtwork)((Object)ma));
        }
        if (show._embedded.images != null) {
            for (Image img : show._embedded.images) {
                MediaArtwork ma = this.imagesToMA(img);
                if (ma == null) continue;
                md.addMediaArt(ma);
            }
        }
        if (show._embedded.cast != null) {
            for (Cast cast : show._embedded.cast) {
                person = new Person(Person.Type.ACTOR);
                person.setId("tvmaze", cast.person.id);
                person.setName(cast.person.name);
                person.setRole(cast.character.name);
                person.setProfileUrl(cast.person.url);
                if (cast.person.image != null) {
                    person.setThumbUrl(cast.person.image.medium);
                }
                md.addCastMember(person);
            }
        }
        if (show._embedded.crew != null) {
            block25: for (Crew crew : show._embedded.crew) {
                person = new Person();
                person.setId("tvmaze", crew.person.id);
                person.setName(crew.person.name);
                person.setProfileUrl(crew.person.url);
                if (crew.person.image != null) {
                    person.setThumbUrl(crew.person.image.medium);
                }
                person.setRole(crew.type);
                switch (crew.type) {
                    case "Executive Producer": 
                    case "Producer": {
                        person.setType(Person.Type.PRODUCER);
                        break;
                    }
                    case "Director Of Photography": {
                        person.setType(Person.Type.CAMERA);
                        break;
                    }
                    case "Creator": {
                        person.setType(Person.Type.WRITER);
                        break;
                    }
                    case "Editor": {
                        person.setType(Person.Type.EDITOR);
                        break;
                    }
                    case "Music": {
                        person.setType(Person.Type.COMPOSER);
                        break;
                    }
                    default: {
                        continue block25;
                    }
                }
                md.addCastMember(person);
            }
        }
        if (!(egs = this.getEpisodeGroups(tvMazeId)).isEmpty()) {
            egs.values().forEach(md::addEpisodeGroup);
        }
        return md;
    }

    private Map<Integer, MediaMetadata> getEpisodeListForEG(int alternateId, MediaEpisodeGroup group) {
        HashMap<Integer, MediaMetadata> mds = new HashMap<Integer, MediaMetadata>();
        try {
            List<Episode> eps = this.controller.getAlternativeEpisodes(alternateId);
            if (eps != null && !eps.isEmpty()) {
                for (Episode ep : eps) {
                    MediaMetadata md = new MediaMetadata("tvmaze");
                    md.setId("tvmaze", ep._embedded.episodes.get((int)0).id);
                    md.setEpisodeNumber(group, ep.season, ep.number);
                    mds.put(ep._embedded.episodes.get((int)0).id, md);
                }
            }
        }
        catch (IOException e) {
            LOGGER.trace("could not get episode groups for show: {}", (Object)e.getMessage());
        }
        return mds;
    }

    private Map<Integer, MediaEpisodeGroup> getEpisodeGroups(int showId) {
        HashMap<Integer, MediaEpisodeGroup> egs = new HashMap<Integer, MediaEpisodeGroup>();
        try {
            List<AlternateList> alternates = this.controller.getAlternativeLists(showId);
            if (alternates != null && alternates.size() > 0) {
                for (AlternateList alt : alternates) {
                    MediaEpisodeGroup eg;
                    Object countryPub = "";
                    if (!alt.getName().isBlank()) {
                        countryPub = (String)countryPub + " - " + alt.getName();
                    }
                    if (!alt.getCountry().isBlank()) {
                        countryPub = (String)countryPub + " (" + alt.getCountry() + ")";
                    }
                    if (alt.dvd_release) {
                        egs.put(alt.id, MediaEpisodeGroup.DEFAULT_DVD);
                        continue;
                    }
                    if (alt.verbatim_order) {
                        eg = new MediaEpisodeGroup(MediaEpisodeGroup.EpisodeGroupType.ALTERNATE, "Verbatim");
                        egs.put(alt.id, eg);
                        continue;
                    }
                    if (alt.country_premiere) {
                        eg = new MediaEpisodeGroup(MediaEpisodeGroup.EpisodeGroupType.ALTERNATE, "Country Premiere" + (String)countryPub);
                        egs.put(alt.id, eg);
                        continue;
                    }
                    if (alt.streaming_premiere) {
                        eg = new MediaEpisodeGroup(MediaEpisodeGroup.EpisodeGroupType.ALTERNATE, "Streaming" + (String)countryPub);
                        egs.put(alt.id, eg);
                        continue;
                    }
                    if (alt.broadcast_premiere) {
                        eg = new MediaEpisodeGroup(MediaEpisodeGroup.EpisodeGroupType.ALTERNATE, "Broadcast Premiere" + (String)countryPub);
                        egs.put(alt.id, eg);
                        continue;
                    }
                    if (!alt.language_premiere) continue;
                    String lang = alt.language != null ? " (" + alt.language + ")" : "";
                    MediaEpisodeGroup eg2 = new MediaEpisodeGroup(MediaEpisodeGroup.EpisodeGroupType.ALTERNATE, "Language Premiere" + lang);
                    egs.put(alt.id, eg2);
                }
            }
        }
        catch (IOException e) {
            LOGGER.trace("could not get episode groups for show: {}", (Object)e.getMessage());
        }
        return egs;
    }

    @Override
    public MediaMetadata getMetadata(@NotNull TvShowEpisodeSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getMetadata() TvShowEpisode: {}", (Object)options);
        this.initAPI();
        int episodeId = options.getIdAsIntOrDefault("tvmaze", 0);
        Date aired = null;
        if (options.getMetadata() != null && options.getMetadata().getReleaseDate() != null) {
            aired = options.getMetadata().getReleaseDate();
        }
        MediaEpisodeGroup episodeGroup = options.getEpisodeGroup();
        int seasonNr = -1;
        int episodeNr = -1;
        Iterator<Object> iterator = options.getIds().get("episodeNr");
        if (iterator instanceof List) {
            List episodeNumbers = (List)((Object)iterator);
            for (Object e : episodeNumbers) {
                MediaEpisodeNumber episodeNumber;
                if (!(e instanceof MediaEpisodeNumber) || !(episodeNumber = (MediaEpisodeNumber)e).episodeGroup().equals(episodeGroup)) continue;
                episodeNr = episodeNumber.episode();
                seasonNr = episodeNumber.season();
                break;
            }
        }
        if (seasonNr == -1 && episodeNr == -1) {
            seasonNr = options.getIdAsIntOrDefault("seasonNr", -1);
            episodeNr = options.getIdAsIntOrDefault("episodeNr", -1);
        }
        if (seasonNr == -1 && episodeNr == -1 && episodeId == 0 && aired == null) {
            LOGGER.debug("cannot scrape episode; no valid id/date/numbers found!");
            throw new MissingIdException(new String[]{"tvmaze"});
        }
        List<MediaMetadata> eps = this.getEpisodeList(options.createTvShowSearchAndScrapeOptions());
        if (!eps.isEmpty()) {
            if (episodeId > 0) {
                for (MediaMetadata mediaMetadata : eps) {
                    if (mediaMetadata.getIdAsIntOrDefault("tvmaze", -1) != episodeId) continue;
                    LOGGER.trace("found match via ID");
                    return mediaMetadata;
                }
            }
            if (aired != null) {
                MediaMetadata found = null;
                for (MediaMetadata ep : eps) {
                    if (!aired.equals(ep.getReleaseDate())) continue;
                    if (found == null) {
                        found = ep;
                        continue;
                    }
                    found = null;
                    LOGGER.trace("found duplicates by releaseDate - no matching");
                    break;
                }
                if (found != null) {
                    LOGGER.trace("found match via releaseDate");
                    return found;
                }
            }
            if (options.getMetadata() != null && options.getMetadata().getTitle().length() > 15) {
                for (MediaMetadata mediaMetadata : eps) {
                    if (!options.getMetadata().getTitle().equals(mediaMetadata.getTitle())) continue;
                    LOGGER.trace("found match via title");
                    return mediaMetadata;
                }
            }
            for (MediaMetadata mediaMetadata : eps) {
                MediaEpisodeNumber num = mediaMetadata.getEpisodeNumber(episodeGroup);
                if (num.episode() != episodeNr || num.season() != seasonNr) continue;
                LOGGER.trace("found match via S/EE numbers");
                return mediaMetadata;
            }
            LOGGER.trace("could not match anything from episodeList.");
        } else {
            LOGGER.trace("getEpisodeList() returned nothing...?");
        }
        throw new NothingFoundException();
    }

    @Override
    public SortedSet<MediaSearchResult> search(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        List<SearchResult> searchResult;
        Show show;
        LOGGER.debug("search(): {}", (Object)options);
        this.initAPI();
        TreeSet<MediaSearchResult> searchResults = new TreeSet<MediaSearchResult>();
        int tvMazeId = options.getIdAsInt("tvmaze");
        if (tvMazeId == 0) {
            try {
                String imdb = options.getIdAsString("imdb");
                if (imdb != null) {
                    show = this.controller.getByImdbId(imdb);
                    tvMazeId = show.id;
                }
            }
            catch (IOException e) {
                LOGGER.trace("Error calling by ImdbId {}", (Object)e.getMessage());
            }
        }
        if (tvMazeId == 0) {
            try {
                String tvdb = options.getIdAsString("tvdb");
                if (tvdb != null) {
                    show = this.controller.getByTvdbId(tvdb);
                    tvMazeId = show.id;
                }
            }
            catch (IOException e) {
                LOGGER.trace("Error calling by TvdbId {}", (Object)e.getMessage());
            }
        }
        if (tvMazeId == 0) {
            try {
                String tvrage = options.getIdAsString("tvrage");
                if (tvrage != null) {
                    show = this.controller.getByTvrageId(tvrage);
                    tvMazeId = show.id;
                }
            }
            catch (IOException e) {
                LOGGER.trace("Error calling by TvrageId {}", (Object)e.getMessage());
            }
        }
        if (tvMazeId > 0) {
            options.setId("tvmaze", tvMazeId);
            MediaMetadata md = this.getMetadata(options);
            MediaSearchResult msr = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
            msr.mergeFrom(md);
            msr.setScore(1.0f);
            searchResults.add(msr);
            return searchResults;
        }
        try {
            searchResult = this.controller.getTvShowSearchResults(options.getSearchQuery());
        }
        catch (Exception e) {
            LOGGER.debug("error searching: {}", (Object)e.getMessage());
            throw new ScrapeException(e);
        }
        if (searchResult == null) {
            LOGGER.debug("no result from tvmaze.com");
            return searchResults;
        }
        for (SearchResult result : searchResult) {
            MediaSearchResult msr = new MediaSearchResult(this.getId(), MediaType.TV_SHOW);
            msr.setScore(result.score);
            Show show2 = result.show;
            msr.setTitle(show2.name);
            msr.setUrl(show2.url);
            if (show2.image != null) {
                msr.setPosterUrl(show2.image.medium);
            }
            if (StringUtils.isNotBlank((CharSequence)show2.summary)) {
                msr.setOverview(Jsoup.parse((String)show2.summary).text());
            }
            msr.setIMDBId(show2.externals.imdb);
            msr.setId("tvrage", String.valueOf(show2.externals.tvrage));
            msr.setId("tvdb", String.valueOf(show2.externals.thetvdb));
            msr.setId("tvmaze", String.valueOf(show2.id));
            msr.setOriginalLanguage(show2.language);
            if (StringUtils.isNotBlank((CharSequence)show2.premiered)) {
                try {
                    msr.setYear(this.parseYear(show2.premiered));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (StringUtils.isNotBlank((CharSequence)options.getImdbId()) && options.getImdbId().equals(msr.getIMDBId()) || String.valueOf(options.getTmdbId()).equals(msr.getId())) {
                LOGGER.debug("perfect match by ID - set score to 1");
                msr.setScore(1.0f);
            } else {
                msr.setScore(result.score);
            }
            searchResults.add(msr);
        }
        return searchResults;
    }

    @Override
    public List<MediaMetadata> getEpisodeList(TvShowSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getEpisodeList: {}", (Object)options);
        this.initAPI();
        int showId = options.getIdAsIntOrDefault("tvmaze", 0);
        if (showId == 0) {
            LOGGER.debug("no show id available");
            throw new MissingIdException(new String[]{"tvmaze"});
        }
        ArrayList<Episode> episodeList = new ArrayList<Episode>();
        try {
            MediaMetadata show = this.getMetadata(options);
            Map seasonMap = (Map)show.getExtraData().get("seasonMap");
            for (Map.Entry entry : seasonMap.entrySet()) {
                List<Episode> eps = this.controller.getSeasonEpisodes((Integer)entry.getValue());
                episodeList.addAll(eps);
            }
        }
        catch (Exception e) {
            LOGGER.trace("could not get Episode information: {}", (Object)e.getMessage());
        }
        ArrayList<MediaMetadata> returnList = new ArrayList<MediaMetadata>();
        for (Episode episode : episodeList) {
            MediaMetadata mediaMetadata = new MediaMetadata(this.getId());
            mediaMetadata.setScrapeOptions(options);
            mediaMetadata.setId("tvmaze", episode.id);
            mediaMetadata.setTitle(episode.name);
            if (StringUtils.isNotBlank((CharSequence)episode.summary)) {
                mediaMetadata.setPlot(Jsoup.parse((String)episode.summary).text());
            }
            if (episode.type.equals("regular")) {
                mediaMetadata.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, episode.season, episode.number);
            } else {
                mediaMetadata.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_AIRED, 0, episode.number);
                mediaMetadata.setEpisodeNumber(MediaEpisodeGroup.DEFAULT_DISPLAY, episode.season, episode.number);
            }
            mediaMetadata.setRuntime(episode.runtime);
            try {
                mediaMetadata.setReleaseDate(this.premieredFormat.parse(episode.airdate));
                mediaMetadata.setYear(this.parseYear(episode.airdate));
            }
            catch (Exception eps) {
                // empty catch block
            }
            if (episode.image != null) {
                MediaArtwork ma = new MediaArtwork("tvmaze", MediaArtwork.MediaArtworkType.THUMB);
                ma.setOriginalUrl(episode.image.original);
                ma.setPreviewUrl(episode.image.medium);
                ma.addImageSize(0, 0, episode.image.original, 0);
                mediaMetadata.addMediaArt(ma);
            }
            if (episode._embedded.guestcast != null) {
                for (Cast cast : episode._embedded.guestcast) {
                    Person person = new Person(Person.Type.GUEST);
                    person.setId("tvmaze", cast.person.id);
                    person.setName(cast.person.name);
                    person.setRole(cast.character.name);
                    person.setProfileUrl(cast.person.url);
                    if (cast.person.image != null) {
                        person.setThumbUrl(cast.person.image.medium);
                    }
                    mediaMetadata.addCastMember(person);
                }
            }
            returnList.add(mediaMetadata);
        }
        Map<Integer, MediaEpisodeGroup> egs = this.getEpisodeGroups(showId);
        for (Map.Entry<Object, Object> entry : egs.entrySet()) {
            Map<Integer, MediaMetadata> egEps = this.getEpisodeListForEG((Integer)entry.getKey(), (MediaEpisodeGroup)entry.getValue());
            for (MediaMetadata md : returnList) {
                MediaMetadata alternate = egEps.get(md.getId("tvmaze"));
                if (alternate == null) continue;
                MediaEpisodeNumber epNo = alternate.getEpisodeNumber((MediaEpisodeGroup)entry.getValue());
                md.setEpisodeNumber(epNo.episodeGroup(), epNo.season(), epNo.episode());
            }
        }
        return returnList;
    }

    @Override
    protected String getSubId() {
        return "tvshow";
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        LOGGER.debug("getArtwork(): {}", (Object)options);
        this.initAPI();
        try {
            if (options.getMediaType() != MediaType.TV_SHOW && options.getMediaType() != MediaType.TV_EPISODE) {
                return Collections.emptyList();
            }
            if (options.getMediaType() == MediaType.TV_EPISODE) {
                TvShowEpisodeSearchAndScrapeOptions episodeSearchAndScrapeOptions = new TvShowEpisodeSearchAndScrapeOptions();
                episodeSearchAndScrapeOptions.setDataFromOtherOptions(options);
                if (options.getIds().get("tvShowIds") instanceof Map) {
                    Map tvShowIds = (Map)options.getIds().get("tvShowIds");
                    episodeSearchAndScrapeOptions.setTvShowIds(tvShowIds);
                }
                MediaMetadata md = this.getMetadata(episodeSearchAndScrapeOptions);
                return md.getMediaArt(options.getArtworkType());
            }
            TvShowSearchAndScrapeOptions op = new TvShowSearchAndScrapeOptions();
            op.setDataFromOtherOptions(options);
            return this.getMetadata(op).getMediaArt(options.getArtworkType());
        }
        catch (MissingIdException | NothingFoundException e) {
            return Collections.emptyList();
        }
        catch (ScrapeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ScrapeException(e);
        }
    }

    private MediaArtwork imagesToMA(Image image) {
        MediaArtwork.MediaArtworkType type = null;
        MediaArtwork ma = null;
        try {
            type = MediaArtwork.MediaArtworkType.valueOf(image.type.toUpperCase(Locale.ROOT));
            ma = new MediaArtwork("tvmaze", type);
            ma.setPreviewUrl(image.resolutions.medium != null ? image.resolutions.medium.url : image.resolutions.original.url);
            ma.setOriginalUrl(image.resolutions.original.url);
            ma.addImageSize(image.resolutions.original.width, image.resolutions.original.height, image.resolutions.original.url, MediaArtwork.PosterSizes.getSizeOrder(image.resolutions.original.width));
            if (image.resolutions.medium != null) {
                ma.addImageSize(image.resolutions.medium.width, image.resolutions.medium.height, image.resolutions.medium.url, MediaArtwork.PosterSizes.getSizeOrder(image.resolutions.medium.width));
            }
        }
        catch (Exception e) {
            return null;
        }
        return ma;
    }
}

