/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.fanarttv;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.scraper.ArtworkSearchAndScrapeOptions;
import org.tinymediamanager.scraper.MediaMetadata;
import org.tinymediamanager.scraper.entities.MediaArtwork;
import org.tinymediamanager.scraper.entities.MediaType;
import org.tinymediamanager.scraper.exceptions.ScrapeException;
import org.tinymediamanager.scraper.fanarttv.FanartTvMetadataProvider;
import org.tinymediamanager.scraper.fanarttv.entities.Images;
import org.tinymediamanager.scraper.interfaces.IMovieArtworkProvider;
import org.tinymediamanager.scraper.interfaces.IMovieSetArtworkProvider;
import org.tinymediamanager.scraper.util.MediaIdUtil;
import retrofit2.Response;

public class FanartTvMovieArtworkProvider
extends FanartTvMetadataProvider
implements IMovieArtworkProvider,
IMovieSetArtworkProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FanartTvMovieArtworkProvider.class);

    @Override
    protected String getSubId() {
        return "movie_artwork";
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public List<MediaArtwork> getArtwork(ArtworkSearchAndScrapeOptions options) throws ScrapeException {
        if (options.getMediaType() != MediaType.MOVIE && options.getMediaType() != MediaType.MOVIE_SET) {
            return Collections.emptyList();
        }
        LOGGER.debug("getArtwork() - {}", (Object)options);
        this.initAPI();
        MediaArtwork.MediaArtworkType artworkType = options.getArtworkType();
        List<MediaArtwork> returnArtwork = new ArrayList<MediaArtwork>();
        Response images = null;
        String imdbId = options.getImdbId();
        int tmdbId = options.getTmdbId();
        if (options.getMediaType() == MediaType.MOVIE_SET && options.getIdAsInt("tmdbSet") > 0) {
            tmdbId = options.getIdAsInt("tmdbSet");
        }
        if (tmdbId == 0 && !MediaIdUtil.isValidImdbId(imdbId)) {
            return Collections.emptyList();
        }
        Exception savedException = null;
        if (StringUtils.isNotBlank((CharSequence)imdbId)) {
            try {
                LOGGER.debug("getArtwork with IMDB id: {}", (Object)imdbId);
                images = this.api.getMovieService().getMovieImages(imdbId).execute();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if ((images == null || images.body() == null || StringUtils.isBlank((CharSequence)((Images)images.body()).name)) && tmdbId != 0) {
            try {
                LOGGER.debug("getArtwork with TMDB id: {}", (Object)tmdbId);
                images = this.api.getMovieService().getMovieImages(Integer.toString(tmdbId)).execute();
            }
            catch (Exception e) {
                LOGGER.debug("failed to get artwork: {}", (Object)e.getMessage());
                savedException = e;
            }
        }
        if (!(images != null && images.isSuccessful() || savedException == null)) {
            if (savedException instanceof InterruptedException || savedException instanceof InterruptedIOException) {
                return returnArtwork;
            }
            throw new ScrapeException(savedException);
        }
        if (images == null) {
            LOGGER.debug("got no result");
            return returnArtwork;
        }
        if (!images.isSuccessful()) {
            String message = "";
            try {
                message = images.errorBody().string();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            LOGGER.debug("request was not successful: HTTP/{} - {}", (Object)images.code(), (Object)message);
            return returnArtwork;
        }
        returnArtwork = this.getArtwork((Images)images.body(), artworkType);
        MediaMetadata md = options.getMetadata();
        if (md != null && !returnArtwork.isEmpty()) {
            md.addMediaArt(returnArtwork);
        }
        return returnArtwork;
    }
}

