/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.scraper.anidb;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

class AniDbEpisode {
    int id;
    int episode;
    int season;
    int runtime;
    Date airdate;
    float rating;
    int votes;
    String summary;
    Map<String, String> titles;

    private AniDbEpisode(Builder builder) {
        this.id = builder.id;
        this.episode = builder.episode;
        this.season = builder.season;
        this.runtime = builder.runtime;
        this.airdate = builder.airdate;
        this.rating = builder.rating;
        this.votes = builder.votes;
        this.summary = builder.summary;
        this.titles = builder.titles;
    }

    static final class Builder {
        private int id = -1;
        private int episode = -1;
        private int season = -1;
        private int runtime = 0;
        private Date airdate = null;
        private float rating = 0.0f;
        private int votes = 0;
        private String summary = "";
        private Map<String, String> titles = new HashMap<String, String>();

        Builder() {
        }

        @Nonnull
        public Builder id(int val) {
            this.id = val;
            return this;
        }

        @Nonnull
        public Builder episode(int val) {
            this.episode = val;
            return this;
        }

        @Nonnull
        public Builder season(int val) {
            this.season = val;
            return this;
        }

        @Nonnull
        public Builder runtime(int val) {
            this.runtime = val;
            return this;
        }

        @Nonnull
        public Builder airdate(@Nonnull Date val) {
            this.airdate = val;
            return this;
        }

        @Nonnull
        public Builder rating(float val) {
            this.rating = val;
            return this;
        }

        @Nonnull
        public Builder votes(int val) {
            this.votes = val;
            return this;
        }

        @Nonnull
        public Builder summary(@Nonnull String val) {
            this.summary = val;
            return this;
        }

        @Nonnull
        public Builder titles(@Nonnull Map<String, String> val) {
            this.titles = val;
            return this;
        }

        @Nonnull
        public Builder titles(@Nonnull String language, @Nonnull String title) {
            this.titles.put(language, title);
            return this;
        }

        @Nonnull
        public AniDbEpisode build() {
            return new AniDbEpisode(this);
        }
    }
}

