/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlAttribute;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.StreamAttribute;
import org.tinymediamanager.library.bluray.playlist.StreamEntry;

public class SecondaryVideoStreamEntry {
    private int id;
    private StreamEntry streamEntry;
    private StreamAttribute streamAttribute;
    private int[] secondaryAudioReferences;
    private int[] pipPGTextSTReferences;

    public SecondaryVideoStreamEntry() {
    }

    public SecondaryVideoStreamEntry(int n) {
        this.id = n;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n;
        int[] nArray;
        StreamEntry streamEntry = new StreamEntry();
        StreamAttribute streamAttribute = new StreamAttribute();
        streamEntry.readObject(dataInputStream);
        streamAttribute.readObject(dataInputStream);
        this.setStreamEntry(streamEntry);
        this.setStreamAttribute(streamAttribute);
        int n2 = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(1);
        if (n2 > 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = dataInputStream.readUnsignedByte();
            }
            if (n2 % 2 != 0) {
                dataInputStream.skipBytes(1);
            }
            this.setSecondaryAudioReferences(nArray);
        }
        n2 = dataInputStream.readUnsignedByte();
        dataInputStream.skipBytes(1);
        if (n2 > 0) {
            nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                nArray[n] = dataInputStream.readUnsignedByte();
            }
            if (n2 % 2 != 0) {
                dataInputStream.skipBytes(1);
            }
            this.setPipPGTextSTReferences(nArray);
        }
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        this.getStreamEntry().writeObject(dataOutputStream);
        this.getStreamAttribute().writeObject(dataOutputStream);
        int[] nArray = this.getSecondaryAudioReferences();
        if (nArray == null || nArray.length == 0) {
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(nArray.length);
            dataOutputStream.writeByte(0);
            for (n = 0; n < nArray.length; ++n) {
                dataOutputStream.writeByte(nArray[n]);
                if (nArray.length % 2 == 0) continue;
                dataOutputStream.writeByte(0);
            }
        }
        nArray = this.getPipPGTextSTReferences();
        if (nArray == null || nArray.length == 0) {
            dataOutputStream.writeByte(0);
            dataOutputStream.writeByte(0);
        } else {
            dataOutputStream.writeByte(nArray.length);
            dataOutputStream.writeByte(0);
            for (n = 0; n < nArray.length; ++n) {
                dataOutputStream.writeByte(nArray[n]);
                if (nArray.length % 2 == 0) continue;
                dataOutputStream.writeByte(0);
            }
        }
    }

    @XmlAttribute
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }

    public StreamEntry getStreamEntry() {
        return this.streamEntry;
    }

    public void setStreamEntry(StreamEntry streamEntry) {
        this.streamEntry = streamEntry;
    }

    public StreamAttribute getStreamAttribute() {
        return this.streamAttribute;
    }

    public void setStreamAttribute(StreamAttribute streamAttribute) {
        this.streamAttribute = streamAttribute;
    }

    public int[] getSecondaryAudioReferences() {
        return this.secondaryAudioReferences;
    }

    public void setSecondaryAudioReferences(int[] nArray) {
        this.secondaryAudioReferences = nArray;
    }

    public int[] getPipPGTextSTReferences() {
        return this.pipPGTextSTReferences;
    }

    public void setPipPGTextSTReferences(int[] nArray) {
        this.pipPGTextSTReferences = nArray;
    }
}

