/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.tinymediamanager.library.bluray.playlist.ClipInfo;
import org.tinymediamanager.library.bluray.playlist.STNTable;
import org.tinymediamanager.library.bluray.playlist.StringIOHelper;
import org.tinymediamanager.library.bluray.playlist.UOMaskTable;
import org.tinymediamanager.library.bluray.playlist.UnsignedIntHelper;

public class PlayItem {
    private ClipInfo[] angles;
    private boolean isMultiAngle;
    private int connectionCondition;
    private long inTime;
    private long outTime;
    private UOMaskTable uoMaskTable = new UOMaskTable();
    private boolean playItemRandomAccessFlag;
    private int stillMode;
    private int stillTime;
    private boolean isDifferentAudios;
    private boolean isSeamlessAngleChange;
    private STNTable stnTable = new STNTable();
    private int id;

    public PlayItem() {
    }

    public PlayItem(int n) {
        this.id = n;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        ArrayList<ClipInfo> arrayList = new ArrayList<ClipInfo>();
        byte[] byArray = new byte[4];
        byte[] byArray2 = new byte[4];
        dataInputStream.skipBytes(2);
        String string = StringIOHelper.readISO646String(dataInputStream, 5);
        String string2 = StringIOHelper.readISO646String(dataInputStream, 4);
        dataInputStream.skipBytes(1);
        byte by = dataInputStream.readByte();
        this.setIsMultiAngle((by & 0x10) != 0);
        this.setConnectionCondition(by & 0xF);
        int n = dataInputStream.readUnsignedByte();
        dataInputStream.readFully(byArray);
        this.setInTime(UnsignedIntHelper.convertToLong(byArray));
        dataInputStream.readFully(byArray2);
        this.setOutTime(UnsignedIntHelper.convertToLong(byArray2));
        this.uoMaskTable.readObject(dataInputStream);
        by = dataInputStream.readByte();
        this.setPlayItemRandomAccessFlag((by & 0x80) != 0);
        this.setStillMode(dataInputStream.readUnsignedByte());
        if (this.getStillTime() == 1) {
            this.setStillTime(dataInputStream.readUnsignedShort());
        } else {
            dataInputStream.skipBytes(2);
        }
        ClipInfo clipInfo = new ClipInfo(0, string, string2, n);
        arrayList.add(clipInfo);
        if (this.getIsMultiAngle()) {
            int n2 = dataInputStream.readUnsignedByte();
            by = dataInputStream.readByte();
            this.setIsDifferentAudios((by & 2) != 0);
            this.setIsSeamlessAngleChange((by & 1) != 0);
            for (int i = 1; i < n2; ++i) {
                string = StringIOHelper.readISO646String(dataInputStream, 5);
                string2 = StringIOHelper.readISO646String(dataInputStream, 4);
                n = dataInputStream.readUnsignedByte();
                clipInfo = new ClipInfo(i, string, string2, n);
                arrayList.add(clipInfo);
            }
        }
        ClipInfo[] clipInfoArray = arrayList.toArray(new ClipInfo[arrayList.size()]);
        this.setAngles(clipInfoArray);
        this.stnTable.readObject(dataInputStream);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        ClipInfo clipInfo = this.angles[0];
        dataOutputStream2.write(StringIOHelper.getISO646Bytes(clipInfo.getClipName()));
        dataOutputStream2.write(StringIOHelper.getISO646Bytes("M2TS"));
        dataOutputStream2.writeByte(0);
        int n = this.getIsMultiAngle() ? 16 : 0;
        dataOutputStream2.writeByte(n |= this.getConnectionCondition());
        dataOutputStream2.writeByte(clipInfo.getStcId());
        dataOutputStream2.write(UnsignedIntHelper.convertToBytes(this.getInTime()));
        dataOutputStream2.write(UnsignedIntHelper.convertToBytes(this.getOutTime()));
        this.uoMaskTable.writeObject(dataOutputStream2);
        dataOutputStream2.writeByte(this.getPlayItemRandomAccessFlag() ? 128 : 0);
        dataOutputStream2.writeByte(this.getStillMode());
        if (this.getStillMode() == 1) {
            dataOutputStream2.writeShort(this.getStillTime());
        } else {
            dataOutputStream2.write(new byte[2]);
        }
        if (this.getIsMultiAngle()) {
            dataOutputStream2.writeByte(this.angles.length);
            n = this.getIsDifferentAudios() ? 2 : 0;
            dataOutputStream2.writeByte(n |= this.getIsSeamlessAngleChange() ? 1 : 0);
            for (int i = 1; i < this.angles.length; ++i) {
                clipInfo = this.angles[i];
                dataOutputStream2.write(StringIOHelper.getISO646Bytes(clipInfo.getClipName()));
                dataOutputStream2.write(StringIOHelper.getISO646Bytes("M2TS"));
                dataOutputStream2.writeByte(clipInfo.getStcId());
            }
        }
        this.stnTable.writeObject(dataOutputStream2);
        dataOutputStream2.flush();
        dataOutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
    }

    @XmlElement(name="Angle")
    public ClipInfo[] getAngles() {
        return this.angles;
    }

    public void setAngles(ClipInfo[] clipInfoArray) {
        if (this.getIsMultiAngle() && (clipInfoArray.length < 2 || clipInfoArray.length > 9) || !this.getIsMultiAngle() && clipInfoArray.length != 1) {
            throw new IllegalArgumentException("Unexpected number of Clip Angle Information");
        }
        for (int i = 0; i < clipInfoArray.length; ++i) {
            if (i == clipInfoArray[i].getId()) continue;
            throw new IllegalArgumentException("angle_id does not match the array order");
        }
        this.angles = clipInfoArray;
    }

    public boolean getIsMultiAngle() {
        return this.isMultiAngle;
    }

    public void setIsMultiAngle(boolean bl) {
        this.isMultiAngle = bl;
    }

    public int getConnectionCondition() {
        return this.connectionCondition;
    }

    public void setConnectionCondition(int n) {
        if (n != 1 && n != 5 && n != 6) {
            throw new IllegalArgumentException("Unexpected connectionCondition value " + n);
        }
        this.connectionCondition = n;
    }

    public long getInTime() {
        return this.inTime;
    }

    public void setInTime(long l) {
        this.inTime = l;
    }

    public long getOutTime() {
        return this.outTime;
    }

    public void setOutTime(long l) {
        this.outTime = l;
    }

    public UOMaskTable getUoMaskTable() {
        return this.uoMaskTable;
    }

    public void setUoMaskTable(UOMaskTable uOMaskTable) {
        this.uoMaskTable = uOMaskTable;
    }

    public boolean getPlayItemRandomAccessFlag() {
        return this.playItemRandomAccessFlag;
    }

    public void setPlayItemRandomAccessFlag(boolean bl) {
        this.playItemRandomAccessFlag = bl;
    }

    public int getStillMode() {
        return this.stillMode;
    }

    public void setStillMode(int n) {
        this.stillMode = n;
    }

    public int getStillTime() {
        return this.stillTime;
    }

    public void setStillTime(int n) {
        this.stillTime = n;
    }

    public STNTable getStnTable() {
        return this.stnTable;
    }

    public void setStnTable(STNTable sTNTable) {
        this.stnTable = sTNTable;
    }

    public boolean getIsDifferentAudios() {
        return this.isDifferentAudios;
    }

    public void setIsDifferentAudios(boolean bl) {
        this.isDifferentAudios = bl;
    }

    public boolean getIsSeamlessAngleChange() {
        return this.isSeamlessAngleChange;
    }

    public void setIsSeamlessAngleChange(boolean bl) {
        this.isSeamlessAngleChange = bl;
    }

    @XmlAttribute
    public int getId() {
        return this.id;
    }

    public void setId(int n) {
        this.id = n;
    }
}

