/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlType;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.PIPMetadataEntry;

@XmlType(propOrder={"pipMetadataEntry", "paddingY"})
public class MetadataBlockData {
    private long size = 0L;
    private PIPMetadataEntry[] pipMetadataEntry;
    private int paddingY = 0;

    public MetadataBlockData() {
    }

    public MetadataBlockData(long l) {
        this.size = l;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2 = dataInputStream.readUnsignedShort();
        PIPMetadataEntry[] pIPMetadataEntryArray = new PIPMetadataEntry[n2];
        for (n = 0; n < n2; ++n) {
            pIPMetadataEntryArray[n] = new PIPMetadataEntry();
            pIPMetadataEntryArray[n].readObject(dataInputStream);
        }
        this.setPipMetadataEntry(pIPMetadataEntryArray);
        n = (int)((this.size - (long)(2 + 8 * n2)) / 2L);
        for (int i = 0; i < n; ++i) {
            dataInputStream.readShort();
        }
        this.setPaddingY(n);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        PIPMetadataEntry[] pIPMetadataEntryArray = this.getPipMetadataEntry();
        dataOutputStream.writeShort(pIPMetadataEntryArray.length);
        for (n = 0; n < pIPMetadataEntryArray.length; ++n) {
            pIPMetadataEntryArray[n].writeObject(dataOutputStream);
        }
        for (n = 0; n < this.getPaddingY(); ++n) {
            dataOutputStream.writeShort(0);
        }
    }

    public PIPMetadataEntry[] getPipMetadataEntry() {
        return this.pipMetadataEntry;
    }

    public void setPipMetadataEntry(PIPMetadataEntry[] pIPMetadataEntryArray) {
        this.pipMetadataEntry = pIPMetadataEntryArray;
    }

    public int getPaddingY() {
        return this.paddingY;
    }

    public void setPaddingY(int n) {
        this.paddingY = n;
    }
}

