/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.playlist;

import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import org.tinymediamanager.library.bluray.playlist.AppInfoPlayList;
import org.tinymediamanager.library.bluray.playlist.ExtensionData;
import org.tinymediamanager.library.bluray.playlist.MPLSWriter;
import org.tinymediamanager.library.bluray.playlist.Mark;
import org.tinymediamanager.library.bluray.playlist.PlayItem;
import org.tinymediamanager.library.bluray.playlist.PlayList;
import org.tinymediamanager.library.bluray.playlist.PlayListMark;
import org.tinymediamanager.library.bluray.playlist.StringIOHelper;

@XmlRootElement
@XmlType(propOrder={"version", "appInfoPlayList", "playList", "playListMark", "extensionData", "paddingN1", "paddingN2", "paddingN3", "paddingN4"})
public class MPLSObject {
    public static final String TYPE = "MPLS";
    String version = null;
    AppInfoPlayList appInfo = new AppInfoPlayList();
    PlayList playList = new PlayList();
    PlayListMark playListMark = new PlayListMark();
    ExtensionData extensionData = null;
    int paddingN1;
    int paddingN2;
    int paddingN3;
    int paddingN4;

    public void setVersion(String string) {
        this.version = string;
    }

    public String getVersion() {
        return this.version;
    }

    public void setAppInfoPlayList(AppInfoPlayList appInfoPlayList) {
        this.appInfo = appInfoPlayList;
    }

    public AppInfoPlayList getAppInfoPlayList() {
        return this.appInfo;
    }

    public PlayList getPlayList() {
        return this.playList;
    }

    public void setPlayList(PlayList playList) {
        this.playList = playList;
    }

    public PlayListMark getPlayListMark() {
        return this.playListMark;
    }

    public void setPlayListMark(PlayListMark playListMark) {
        this.playListMark = playListMark;
    }

    public void setExtensionData(ExtensionData extensionData) {
        this.extensionData = extensionData;
    }

    public ExtensionData getExtensionData() {
        return this.extensionData;
    }

    public long getDuration() {
        long l = 0L;
        long l2 = 0L;
        if (this.playListMark != null && this.playListMark.getMarks() != null && this.playListMark.getMarks().length > 0) {
            for (Mark object : this.playListMark.getMarks()) {
                l += object.getDuration() / 45000L;
            }
        }
        if (this.playList != null && this.playList.getPlayItems() != null && this.playList.getPlayItems().length > 0) {
            for (PlayItem playItem : this.playList.getPlayItems()) {
                l2 += (playItem.getOutTime() - playItem.getInTime()) / 45000L;
            }
        }
        return Math.max(l, l2);
    }

    public void setPaddingN1(int n) {
        this.paddingN1 = n;
    }

    public int getPaddingN1() {
        return this.paddingN1;
    }

    public void setPaddingN2(int n) {
        this.paddingN2 = n;
    }

    public int getPaddingN2() {
        return this.paddingN2;
    }

    public void setPaddingN3(int n) {
        this.paddingN3 = n;
    }

    public int getPaddingN3() {
        return this.paddingN3;
    }

    public void setPaddingN4(int n) {
        this.paddingN4 = n;
    }

    public int getPaddingN4() {
        return this.paddingN4;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        String string = StringIOHelper.readISO646String(dataInputStream, 4);
        String string2 = StringIOHelper.readISO646String(dataInputStream, 4);
        int n = dataInputStream.readInt();
        int n2 = dataInputStream.readInt();
        int n3 = dataInputStream.readInt();
        if (!TYPE.equals(string)) {
            throw new RuntimeException("TypeIndicator error " + string);
        }
        this.setVersion(string2);
        dataInputStream.skipBytes(20);
        byte[] byArray = new byte[n - 40];
        dataInputStream.read(byArray);
        DataInputStream dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray));
        this.appInfo.readObject(dataInputStream2);
        this.setPaddingN1(this.seekPaddings(dataInputStream2));
        dataInputStream2.close();
        byte[] byArray2 = new byte[n2 - n];
        dataInputStream.read(byArray2);
        dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray2));
        this.playList.readObject(dataInputStream2);
        this.setPaddingN2(this.seekPaddings(dataInputStream2));
        dataInputStream2.close();
        if (n3 == 0) {
            this.playListMark.readObject(dataInputStream);
            this.setPaddingN3(this.seekPaddings(dataInputStream));
            this.setPaddingN4(0);
            return;
        }
        byte[] byArray3 = new byte[n3 - n2];
        dataInputStream.read(byArray3);
        dataInputStream2 = new DataInputStream(new ByteArrayInputStream(byArray3));
        this.playListMark.readObject(dataInputStream2);
        this.setPaddingN3(this.seekPaddings(dataInputStream2));
        dataInputStream2.close();
        this.extensionData = new ExtensionData(this.playList.getPlayItems());
        this.extensionData.readObject(dataInputStream);
        this.setPaddingN4(this.seekPaddings(dataInputStream));
    }

    public String toXML() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(byteArrayOutputStream));
            new MPLSWriter().writeXml(this, dataOutputStream);
            dataOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byteArrayOutputStream.toString();
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[20];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream3 = new DataOutputStream(byteArrayOutputStream2);
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream4 = new DataOutputStream(byteArrayOutputStream3);
        this.appInfo.writeObject(dataOutputStream2);
        for (n = 0; n < this.paddingN1; ++n) {
            dataOutputStream2.writeShort(0);
        }
        this.playList.writeObject(dataOutputStream3);
        for (n = 0; n < this.paddingN2; ++n) {
            dataOutputStream3.writeShort(0);
        }
        this.playListMark.writeObject(dataOutputStream4);
        for (n = 0; n < this.paddingN3; ++n) {
            dataOutputStream4.writeShort(0);
        }
        dataOutputStream2.flush();
        dataOutputStream3.flush();
        dataOutputStream4.flush();
        dataOutputStream2.close();
        dataOutputStream3.close();
        dataOutputStream4.close();
        int n2 = 40 + dataOutputStream2.size();
        int n3 = n2 + dataOutputStream3.size();
        int n4 = this.extensionData == null ? 0 : n3 + dataOutputStream4.size();
        dataOutputStream.write(StringIOHelper.getISO646Bytes(TYPE));
        dataOutputStream.write(StringIOHelper.getISO646Bytes(this.getVersion()));
        dataOutputStream.writeInt(n2);
        dataOutputStream.writeInt(n3);
        dataOutputStream.writeInt(n4);
        dataOutputStream.write(byArray);
        dataOutputStream.write(byteArrayOutputStream.toByteArray());
        dataOutputStream.write(byteArrayOutputStream2.toByteArray());
        dataOutputStream.write(byteArrayOutputStream3.toByteArray());
        if (this.extensionData != null) {
            this.extensionData.writeObject(dataOutputStream);
            for (n = 0; n < this.paddingN4; ++n) {
                dataOutputStream.writeShort(0);
            }
        }
    }

    private int seekPaddings(DataInputStream dataInputStream) throws IOException {
        int n = 0;
        try {
            while (true) {
                dataInputStream.readUnsignedShort();
                ++n;
            }
        }
        catch (EOFException eOFException) {
            return n;
        }
    }
}

