/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.ScraperMetadataConfig;
import org.tinymediamanager.core.TmmResourceBundle;

public enum TvShowScraperMetadataConfig implements ScraperMetadataConfig
{
    ID(ScraperMetadataConfig.Type.METADATA),
    TITLE(ScraperMetadataConfig.Type.METADATA),
    ORIGINAL_TITLE(ScraperMetadataConfig.Type.METADATA, "metatag.originaltitle"),
    ENGLISH_TITLE(ScraperMetadataConfig.Type.METADATA, "metatag.title.english"),
    PLOT(ScraperMetadataConfig.Type.METADATA),
    TAGLINE(ScraperMetadataConfig.Type.METADATA),
    YEAR(ScraperMetadataConfig.Type.METADATA),
    AIRED(ScraperMetadataConfig.Type.METADATA, "metatag.aired"),
    STATUS(ScraperMetadataConfig.Type.METADATA),
    RATING(ScraperMetadataConfig.Type.METADATA),
    TOP250(ScraperMetadataConfig.Type.METADATA),
    RUNTIME(ScraperMetadataConfig.Type.METADATA),
    CERTIFICATION(ScraperMetadataConfig.Type.METADATA),
    GENRES(ScraperMetadataConfig.Type.METADATA, "metatag.genre"),
    COUNTRY(ScraperMetadataConfig.Type.METADATA),
    STUDIO(ScraperMetadataConfig.Type.METADATA, "metatag.studio"),
    TAGS(ScraperMetadataConfig.Type.METADATA),
    TRAILER(ScraperMetadataConfig.Type.METADATA),
    SEASON_NAMES(ScraperMetadataConfig.Type.METADATA, "metatag.seasonname"),
    SEASON_OVERVIEW(ScraperMetadataConfig.Type.METADATA, "metatag.seasonoverview"),
    ACTORS(ScraperMetadataConfig.Type.CAST),
    CREW(ScraperMetadataConfig.Type.CAST),
    POSTER(ScraperMetadataConfig.Type.ARTWORK),
    FANART(ScraperMetadataConfig.Type.ARTWORK),
    BANNER(ScraperMetadataConfig.Type.ARTWORK),
    CLEARART(ScraperMetadataConfig.Type.ARTWORK),
    THUMB(ScraperMetadataConfig.Type.ARTWORK),
    CLEARLOGO(ScraperMetadataConfig.Type.ARTWORK),
    DISCART(ScraperMetadataConfig.Type.ARTWORK, "mediafiletype.disc"),
    KEYART(ScraperMetadataConfig.Type.ARTWORK),
    CHARACTERART(ScraperMetadataConfig.Type.ARTWORK),
    EXTRAFANART(ScraperMetadataConfig.Type.ARTWORK),
    SEASON_POSTER(ScraperMetadataConfig.Type.ARTWORK),
    SEASON_FANART(ScraperMetadataConfig.Type.ARTWORK),
    SEASON_BANNER(ScraperMetadataConfig.Type.ARTWORK),
    SEASON_THUMB(ScraperMetadataConfig.Type.ARTWORK),
    THEME(ScraperMetadataConfig.Type.THEME);

    private final ScraperMetadataConfig.Type type;
    private final String description;
    private final String tooltip;

    private TvShowScraperMetadataConfig(ScraperMetadataConfig.Type type) {
        this(type, null, null);
    }

    private TvShowScraperMetadataConfig(ScraperMetadataConfig.Type type, String description) {
        this(type, description, null);
    }

    private TvShowScraperMetadataConfig(ScraperMetadataConfig.Type type, String description, String tooltip) {
        this.type = type;
        this.description = description;
        this.tooltip = tooltip;
    }

    @Override
    public ScraperMetadataConfig.Type getType() {
        return this.type;
    }

    @Override
    public String getDescription() {
        if (StringUtils.isBlank((CharSequence)this.description)) {
            try {
                if (this.type == ScraperMetadataConfig.Type.ARTWORK || this.type == ScraperMetadataConfig.Type.THEME) {
                    return TmmResourceBundle.getString("mediafiletype." + this.name().toLowerCase(Locale.ROOT));
                }
                return TmmResourceBundle.getString("metatag." + this.name().toLowerCase(Locale.ROOT));
            }
            catch (Exception exception) {}
        } else {
            try {
                return TmmResourceBundle.getString(this.description);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "";
    }

    @Override
    public String getToolTip() {
        if (StringUtils.isBlank((CharSequence)this.tooltip)) {
            return null;
        }
        try {
            return TmmResourceBundle.getString(this.tooltip);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<TvShowScraperMetadataConfig> valuesForType(ScraperMetadataConfig.Type type) {
        ArrayList<TvShowScraperMetadataConfig> values = new ArrayList<TvShowScraperMetadataConfig>();
        for (TvShowScraperMetadataConfig config : TvShowScraperMetadataConfig.values()) {
            if (config.type != type) continue;
            values.add(config);
        }
        return values;
    }

    public static List<TvShowScraperMetadataConfig> getValues() {
        ArrayList<TvShowScraperMetadataConfig> values = new ArrayList<TvShowScraperMetadataConfig>();
        for (TvShowScraperMetadataConfig value : TvShowScraperMetadataConfig.values()) {
            if (value.type == ScraperMetadataConfig.Type.DEPRECATED) continue;
            values.add(value);
        }
        return values;
    }

    public static List<TvShowScraperMetadataConfig> getValuesWithout(TvShowScraperMetadataConfig ... valuesToExclude) {
        ArrayList<TvShowScraperMetadataConfig> values = new ArrayList<TvShowScraperMetadataConfig>();
        List<TvShowScraperMetadataConfig> exclude = Arrays.asList(valuesToExclude);
        for (TvShowScraperMetadataConfig value : TvShowScraperMetadataConfig.values()) {
            if (value.type == ScraperMetadataConfig.Type.DEPRECATED || exclude.contains(value)) continue;
            values.add(value);
        }
        return values;
    }

    @JsonCreator
    public static TvShowScraperMetadataConfig forValue(String value) {
        return switch (value) {
            case "PRODUCERS", "DIRECTORS", "WRITERS" -> CREW;
            case "LOGO" -> CLEARLOGO;
            default -> TvShowScraperMetadataConfig.valueOf(value.toUpperCase());
        };
    }
}

