/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import java.text.RuleBasedCollator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.scraper.DynaEnum;

public class TvShowEpisodeEdition
extends DynaEnum<TvShowEpisodeEdition> {
    private static final Comparator<TvShowEpisodeEdition> COMPARATOR = new TvShowEditionComparator();
    public static final TvShowEpisodeEdition NONE = new TvShowEpisodeEdition("NONE", 0, "", "");
    public static final TvShowEpisodeEdition DIRECTORS_CUT = new TvShowEpisodeEdition("DIRECTORS_CUT", 1, "Director's Cut", ".Director.?s.(Cut|Edition|Version)");
    public static final TvShowEpisodeEdition UNCUT = new TvShowEpisodeEdition("UNCUT", 2, "Uncut", ".Uncut.(Cut|Edition|Version)?");
    public static final TvShowEpisodeEdition REMASTERED = new TvShowEpisodeEdition("REMASTERED", 3, "Remastered", ".Remastered.(Cut|Edition|Version)?");
    private final String title;
    private final Pattern pattern;

    private TvShowEpisodeEdition(String enumName, int ordinal, String title, String pattern) {
        super(enumName, ordinal);
        this.title = title;
        this.pattern = StringUtils.isBlank((CharSequence)pattern) ? null : Pattern.compile(pattern, 2);
        this.addElement();
    }

    @Override
    public String toString() {
        return this.title;
    }

    public String getTitle() {
        return this.title;
    }

    @JsonValue
    public String getName() {
        return this.name();
    }

    public static TvShowEpisodeEdition[] values() {
        TvShowEpisodeEdition[] episodeEditions = TvShowEpisodeEdition.values(TvShowEpisodeEdition.class);
        Arrays.sort(episodeEditions, COMPARATOR);
        return episodeEditions;
    }

    public static TvShowEpisodeEdition getTvShowEpisodeEditionFromString(String name) {
        for (TvShowEpisodeEdition edition : TvShowEpisodeEdition.values()) {
            if (!edition.name().equals(name)) continue;
            return edition;
        }
        for (TvShowEpisodeEdition edition : TvShowEpisodeEdition.values()) {
            if (!edition.title.equalsIgnoreCase(name)) continue;
            return edition;
        }
        for (TvShowEpisodeEdition edition : TvShowEpisodeEdition.values()) {
            Matcher matcher;
            if (edition.pattern == null || !(matcher = edition.pattern.matcher(name)).find()) continue;
            return edition;
        }
        return NONE;
    }

    public static TvShowEpisodeEdition getTvShowEpisodeEdition(String name) {
        if (StringUtils.isBlank((CharSequence)name) || "NONE".equals(name)) {
            return NONE;
        }
        TvShowEpisodeEdition edition = TvShowEpisodeEdition.getTvShowEpisodeEditionFromString(name);
        if (edition == NONE) {
            edition = new TvShowEpisodeEdition(name, TvShowEpisodeEdition.values().length, name, "");
        }
        return edition;
    }

    @JsonCreator
    public static TvShowEpisodeEdition getTvShowEpisodeEditionStrict(String name) {
        if (StringUtils.isBlank((CharSequence)name) || "NONE".equals(name)) {
            return NONE;
        }
        TvShowEpisodeEdition edition = NONE;
        for (TvShowEpisodeEdition episodeEdition : TvShowEpisodeEdition.values()) {
            if (!episodeEdition.name().equals(name)) continue;
            edition = episodeEdition;
        }
        if (edition == NONE) {
            edition = new TvShowEpisodeEdition(name, TvShowEpisodeEdition.values().length, name, "");
        }
        return edition;
    }

    public static void addListener(DynaEnum.DynaEnumEventListener<TvShowEpisodeEdition> listener) {
        TvShowEpisodeEdition.addListener(TvShowEpisodeEdition.class, listener);
    }

    public static void removeListener(DynaEnum.DynaEnumEventListener<TvShowEpisodeEdition> listener) {
        TvShowEpisodeEdition.removeListener(TvShowEpisodeEdition.class, listener);
    }

    public static class TvShowEditionComparator
    implements Comparator<TvShowEpisodeEdition> {
        private final RuleBasedCollator stringCollator = (RuleBasedCollator)RuleBasedCollator.getInstance();

        @Override
        public int compare(TvShowEpisodeEdition o1, TvShowEpisodeEdition o2) {
            if (o1.toString() == null && o2.toString() == null) {
                return 0;
            }
            if (o1.toString() == null) {
                return 1;
            }
            if (o2.toString() == null) {
                return -1;
            }
            return this.stringCollator.compare(o1.toString().toLowerCase(Locale.ROOT), o2.toString().toLowerCase(Locale.ROOT));
        }
    }
}

