/*
 * Decompiled with CFR 0.152.
 */
package com.github.stephenc.javaisotools.loopfs.udf.descriptor;

import com.github.stephenc.javaisotools.loopfs.udf.descriptor.UDFDescriptor;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.DString;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.LongAD;
import com.github.stephenc.javaisotools.loopfs.udf.descriptor.element.RegId;
import com.github.stephenc.javaisotools.loopfs.udf.exceptions.InvalidDescriptor;

public class FileIdentifierDescriptor
extends UDFDescriptor {
    public Integer version;
    public Integer characteristics;
    public Integer fileIdLength;
    public LongAD icb;
    public Integer implUseLength;
    public RegId implUse;
    public DString fileId;
    protected Integer consumption;
    public final int MINIMUM_LENGTH = 40;

    public FileIdentifierDescriptor() {
    }

    public FileIdentifierDescriptor(byte[] byArray) throws InvalidDescriptor {
        super(byArray);
    }

    @Override
    public int getExpectedTagIdentifier() {
        return 257;
    }

    @Override
    public void deserialize(byte[] byArray) throws InvalidDescriptor {
        if (byArray.length < 40) {
            throw new InvalidDescriptor("File identifier descriptor too short");
        }
        this.deserializeTag(byArray);
        this.version = this.getUInt16(byArray);
        this.characteristics = this.getUInt8(byArray);
        this.fileIdLength = this.getUInt8(byArray);
        this.icb = new LongAD(this.getBytes(byArray, 16));
        this.implUseLength = this.getUInt16(byArray);
        if (this.implUseLength > 0) {
            this.implUse = new RegId(this.getBytes(byArray, this.implUseLength));
        }
        this.fileId = new DString(this.getBytes(byArray, this.fileIdLength));
        if (this.currentPos % 4 > 0) {
            int n = 4 - this.currentPos % 4;
            this.currentPos += n;
        }
        this.consumption = this.currentPos;
    }

    public Integer getConsumption() {
        return this.consumption;
    }
}

