/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.boxes.dece;

import java.nio.ByteBuffer;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.mp4parser.support.AbstractFullBox;
import org.mp4parser.support.DoNotParseDetail;
import org.mp4parser.support.RequiresParseDetailAspect;
import org.mp4parser.tools.IsoTypeReader;
import org.mp4parser.tools.Utf8;

public class AssetInformationBox
extends AbstractFullBox {
    public static final String TYPE = "ainf";
    String apid = "";
    String profileVersion = "0000";
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;

    static {
        AssetInformationBox.ajc$preClinit();
    }

    public AssetInformationBox() {
        super(TYPE);
    }

    @Override
    protected long getContentSize() {
        return Utf8.utf8StringLengthInBytes(this.apid) + 9;
    }

    @Override
    protected void getContent(ByteBuffer byteBuffer) {
        this.writeVersionAndFlags(byteBuffer);
        if (this.getVersion() != 0) {
            throw new RuntimeException("Unknown ainf version " + this.getVersion());
        }
        byteBuffer.put(Utf8.convert(this.profileVersion), 0, 4);
        byteBuffer.put(Utf8.convert(this.apid));
        byteBuffer.put((byte)0);
    }

    @Override
    public void _parseDetails(ByteBuffer content) {
        this.parseVersionAndFlags(content);
        this.profileVersion = IsoTypeReader.readString(content, 4);
        this.apid = IsoTypeReader.readString(content);
    }

    public String getApid() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.apid;
    }

    public void setApid(String apid) {
        String string = apid;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        this.apid = apid;
    }

    public String getProfileVersion() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        return this.profileVersion;
    }

    public void setProfileVersion(String profileVersion) {
        String string = profileVersion;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)string);
        RequiresParseDetailAspect.aspectOf().before(joinPoint);
        assert (profileVersion != null && profileVersion.length() == 4);
        this.profileVersion = profileVersion;
    }

    @DoNotParseDetail
    public boolean isHidden() {
        return (this.getFlags() & 1) == 1;
    }

    @DoNotParseDetail
    public void setHidden(boolean hidden) {
        int flags = this.getFlags();
        if (this.isHidden() ^ hidden) {
            if (hidden) {
                this.setFlags(flags | 1);
            } else {
                this.setFlags(flags & 0xFFFFFE);
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AssetInformationBox.java", AssetInformationBox.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getApid", "org.mp4parser.boxes.dece.AssetInformationBox", "", "", "", "java.lang.String"), 80);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setApid", "org.mp4parser.boxes.dece.AssetInformationBox", "java.lang.String", "apid", "", "void"), 84);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getProfileVersion", "org.mp4parser.boxes.dece.AssetInformationBox", "", "", "", "java.lang.String"), 88);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProfileVersion", "org.mp4parser.boxes.dece.AssetInformationBox", "java.lang.String", "profileVersion", "", "void"), 92);
    }

    public static class Entry {
        public String namespace;
        public String profileLevelIdc;
        public String assetId;

        public Entry(String namespace, String profileLevelIdc, String assetId) {
            this.namespace = namespace;
            this.profileLevelIdc = profileLevelIdc;
            this.assetId = assetId;
        }

        public String toString() {
            return "{namespace='" + this.namespace + '\'' + ", profileLevelIdc='" + this.profileLevelIdc + '\'' + ", assetId='" + this.assetId + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (!this.assetId.equals(entry.assetId)) {
                return false;
            }
            if (!this.namespace.equals(entry.namespace)) {
                return false;
            }
            return this.profileLevelIdc.equals(entry.profileLevelIdc);
        }

        public int hashCode() {
            int result = this.namespace.hashCode();
            result = 31 * result + this.profileLevelIdc.hashCode();
            result = 31 * result + this.assetId.hashCode();
            return result;
        }

        public int getSize() {
            return 3 + Utf8.utf8StringLengthInBytes(this.namespace) + Utf8.utf8StringLengthInBytes(this.profileLevelIdc) + Utf8.utf8StringLengthInBytes(this.assetId);
        }
    }
}

