/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowHDRFormatFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowHDRFormatFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallHdrFormatArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallHdrFormatArray());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.hdrformat"));
    }

    @Override
    public String getId() {
        return "hdrFormatFilter";
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            for (String sel : selectedItems) {
                if (!(invert ^ episode.getVideoHDRFormat().contains(sel))) continue;
                return true;
            }
        }
        return false;
    }

    public void buildAndInstallHdrFormatArray() {
        HashSet<String> hdrFormatsInEpisodes = new HashSet<String>(this.tvShowList.getHdrFormatInEpisodes());
        if (!SetUtils.equals(this.oldValues, hdrFormatsInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(hdrFormatsInEpisodes);
            List<String> sortedHdrFormats = ListUtils.asSortedList(hdrFormatsInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedHdrFormats));
        }
    }
}

