/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowAudioChannelFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowAudioChannelFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.substring(0, 1).equals(s2.substring(0, 1)));
        this.buildAndInstallAudioChannelArray();
        EventBus.registerListener("tvShows-ui", event -> this.buildAndInstallAudioChannelArray());
    }

    @Override
    public String getId() {
        return "tvShowAudioChannel";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        ArrayList<String> audioChannels = new ArrayList<String>();
        for (String values : this.checkComboBox.getSelectedItems()) {
            audioChannels.add(values.substring(0, 1));
        }
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO);
            for (MediaFile mf : mfs) {
                for (String channels : mf.getAudioChannelsList()) {
                    if (!audioChannels.contains(channels.substring(0, 1))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void buildAndInstallAudioChannelArray() {
        HashSet<String> audioChannelsInEpisodes = new HashSet<String>();
        for (int channel : this.tvShowList.getAudioChannelsInEpisodes()) {
            audioChannelsInEpisodes.add(this.audioChannelNotation(channel));
        }
        if (!SetUtils.equals(this.oldValues, audioChannelsInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(audioChannelsInEpisodes);
            List sortedAudioChannels = ListUtils.asSortedList(audioChannelsInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedAudioChannels));
        }
    }

    private String audioChannelNotation(int channels) {
        Object ret = "";
        switch (channels) {
            case 0: {
                ret = "0 (no audio)";
                break;
            }
            case 1: {
                ret = "1 (Mono)";
                break;
            }
            case 2: {
                ret = "2 (Stereo)";
                break;
            }
            default: {
                ret = channels + " (" + MediaFileHelper.audioChannelInDotNotation(channels) + ")";
            }
        }
        return ret;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.channels"));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

