/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieTrailerFormatFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieTrailerFormatFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.setValues(MediaFileHelper.getVideoFormats());
    }

    @Override
    public String getId() {
        return "movieTrailerFormat";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedValues = this.checkComboBox.getSelectedItems();
        for (MediaFile trailer : movie.getMediaFiles(MediaFileType.TRAILER)) {
            for (String videoFormat : selectedValues) {
                if ("UHD".equals(videoFormat) && trailer.isVideoDefinitionUHD()) {
                    return true;
                }
                if ("HD".equals(videoFormat) && trailer.isVideoDefinitionHD()) {
                    return true;
                }
                if ("SD".equals(videoFormat) && trailer.isVideoDefinitionSD()) {
                    return true;
                }
                if ("LD".equals(videoFormat) && trailer.isVideoDefinitionLD()) {
                    return true;
                }
                if (!videoFormat.equals(trailer.getVideoFormat())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.trailerresolution"));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

