/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.datepicker;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.components.datepicker.CalendarPanel;
import org.tinymediamanager.ui.components.datepicker.DateTextField;

public class DatePicker
extends JPanel
implements PropertyChangeListener {
    private static final String uiClassID = "DatePickerUI";
    private final DateTextField dateEditor;
    private final JButton calendarButton;
    private final CalendarPanel calendarPanel;
    protected JPopupMenu popup;
    private boolean dateSelected;
    private ChangeListener changeListener;

    public DatePicker() {
        this(null, null);
    }

    public DatePicker(Date date) {
        this(date, null);
    }

    public DatePicker(Date date, String dateFormat) {
        this.setLayout(new BorderLayout());
        this.dateEditor = new DateTextField(dateFormat);
        this.dateEditor.addPropertyChangeListener("date", this);
        this.calendarPanel = new CalendarPanel(date);
        this.calendarPanel.addPropertyChangeListener("day", this);
        this.setDate(date);
        this.calendarButton = new JButton(IconManager.DATE_PICKER);
        this.calendarButton.setFocusable(false);
        this.calendarButton.addActionListener(e -> {
            int x = -this.dateEditor.getWidth();
            int y = this.calendarButton.getHeight();
            Calendar calendar = Calendar.getInstance();
            Date date1 = this.dateEditor.getDate();
            if (date1 != null) {
                calendar.setTime(date1);
            }
            this.calendarPanel.setCalendar(calendar);
            this.popup.show(this.calendarButton, x, y);
            this.dateSelected = false;
        });
        this.add((Component)this.calendarButton, "East");
        this.add((Component)this.dateEditor, "Center");
        this.popup = new JPopupMenu(){
            private static final long serialVersionUID = 3478677561327475762L;

            @Override
            public void setVisible(boolean visible) {
                Boolean isCanceled = (Boolean)this.getClientProperty("JPopupMenu.firePopupMenuCanceled");
                if (visible || !visible && DatePicker.this.dateSelected || isCanceled != null && !visible && isCanceled.booleanValue()) {
                    super.setVisible(visible);
                }
            }
        };
        this.popup.setLightWeightPopupEnabled(true);
        this.popup.add(this.calendarPanel);
        this.changeListener = new ChangeListener(){
            boolean hasListened = false;

            @Override
            public void stateChanged(ChangeEvent e) {
                if (this.hasListened) {
                    this.hasListened = false;
                    return;
                }
                if (DatePicker.this.popup.isVisible() && DatePicker.this.calendarPanel.monthComboBox.hasFocus()) {
                    MenuElement[] menuElements = MenuSelectionManager.defaultManager().getSelectedPath();
                    MenuElement[] newMenuElements = new MenuElement[menuElements.length + 1];
                    newMenuElements[0] = DatePicker.this.popup;
                    System.arraycopy(menuElements, 0, newMenuElements, 1, menuElements.length);
                    this.hasListened = true;
                    MenuSelectionManager.defaultManager().setSelectedPath(newMenuElements);
                }
            }
        };
        MenuSelectionManager.defaultManager().addChangeListener(this.changeListener);
        this.updateUI();
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    public JTextField getDateEditor() {
        return this.dateEditor;
    }

    public JButton getCalendarButton() {
        return this.calendarButton;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("day") && this.popup.isVisible()) {
            this.dateSelected = true;
            this.popup.setVisible(false);
            if ((Integer)evt.getNewValue() > 0) {
                this.setDate(this.calendarPanel.getCalendar().getTime());
            } else {
                this.setDate(null);
            }
        } else if (evt.getPropertyName().equals("date")) {
            if (evt.getSource() == this.dateEditor) {
                this.firePropertyChange("date", evt.getOldValue(), evt.getNewValue());
            } else {
                this.setDate((Date)evt.getNewValue());
            }
        }
    }

    @Override
    public void updateUI() {
        super.updateUI();
        this.setEnabled(this.isEnabled());
        if (this.calendarPanel != null) {
            SwingUtilities.updateComponentTreeUI(this.popup);
        }
    }

    @Override
    public void setLocale(Locale l) {
        super.setLocale(l);
        this.dateEditor.setLocale(l);
        this.calendarPanel.setLocale(l);
    }

    public Date getDate() {
        return this.dateEditor.getDate();
    }

    public void setDate(Date date) {
        this.dateEditor.setDate(date);
        if (this.getParent() != null) {
            this.getParent().invalidate();
        }
    }

    public Calendar getCalendar() {
        Date date = this.getDate();
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public void setCalendar(Calendar calendar) {
        if (calendar == null) {
            this.dateEditor.setDate(null);
        } else {
            this.dateEditor.setDate(calendar.getTime());
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.dateEditor != null) {
            this.dateEditor.setEnabled(enabled);
            this.calendarButton.setEnabled(enabled);
        }
    }

    public void cleanup() {
        MenuSelectionManager.defaultManager().removeChangeListener(this.changeListener);
        this.changeListener = null;
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.dateEditor != null) {
            return this.dateEditor.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }
}

