/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.actions;

import java.awt.event.ActionEvent;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.ui.TmmUIHelper;
import org.tinymediamanager.ui.actions.TmmAction;

public class ForumAction
extends TmmAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(ForumAction.class);

    public ForumAction() {
        this.putValue("Name", TmmResourceBundle.getString("tmm.forum"));
    }

    @Override
    protected void processAction(ActionEvent e) {
        String url = StringEscapeUtils.unescapeHtml4((String)"https://www.reddit.com/r/tinyMediaManager/");
        try {
            TmmUIHelper.browseUrl(url);
        }
        catch (Exception ex) {
            LOGGER.error("Could not open reddit.com in browser - '{}'", (Object)ex.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, (Object)url, "message.erroropenurl", new String[]{":", ex.getLocalizedMessage()}));
        }
    }
}

