/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.library.bluray.movieobject;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.tinymediamanager.library.bluray.movieobject.MovieObject;

public class MovieObjects {
    MovieObject[] mObjects;

    public MovieObject[] getMovieObject() {
        return this.mObjects;
    }

    public void setMovieObject(MovieObject[] movieObjectArray) {
        this.mObjects = movieObjectArray;
    }

    public void readObject(DataInputStream dataInputStream) throws IOException {
        dataInputStream.skipBytes(8);
        int n = dataInputStream.readUnsignedShort();
        MovieObject[] movieObjectArray = new MovieObject[n];
        for (int i = 0; i < n; ++i) {
            movieObjectArray[i] = new MovieObject();
            movieObjectArray[i].readObject(dataInputStream);
            movieObjectArray[i].setMovieObjectId(i);
        }
        this.setMovieObject(movieObjectArray);
    }

    public void writeObject(DataOutputStream dataOutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        MovieObject[] movieObjectArray = this.getMovieObject();
        for (int i = 0; i < movieObjectArray.length; ++i) {
            MovieObject movieObject = movieObjectArray[i];
            if (movieObject.mobjId != i) {
                throw new IOException("MovieObject Id does not match the array order " + movieObject.mobjId);
            }
            movieObject.writeObject(dataOutputStream2);
        }
        dataOutputStream2.flush();
        dataOutputStream2.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        dataOutputStream.writeInt(byArray.length + 6);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeShort(movieObjectArray.length);
        dataOutputStream.write(byArray);
    }
}

