/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.tvshow;

import com.floreysoft.jmte.AnnotationProcessor;
import com.floreysoft.jmte.Engine;
import com.floreysoft.jmte.ModelAdaptor;
import com.floreysoft.jmte.NamedRenderer;
import com.floreysoft.jmte.Renderer;
import com.floreysoft.jmte.extended.ChainedNamedRenderer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.PostProcess;
import org.tinymediamanager.core.PostProcessExecutor;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.jmte.JmteUtils;
import org.tinymediamanager.core.jmte.NamedArrayRenderer;
import org.tinymediamanager.core.jmte.NamedArrayUniqueRenderer;
import org.tinymediamanager.core.jmte.NamedBitrateRenderer;
import org.tinymediamanager.core.jmte.NamedDateRenderer;
import org.tinymediamanager.core.jmte.NamedFilesizeRenderer;
import org.tinymediamanager.core.jmte.NamedFramerateRenderer;
import org.tinymediamanager.core.jmte.NamedLowerCaseRenderer;
import org.tinymediamanager.core.jmte.NamedNumberRenderer;
import org.tinymediamanager.core.jmte.NamedReplacementRenderer;
import org.tinymediamanager.core.jmte.NamedSplitRenderer;
import org.tinymediamanager.core.jmte.NamedTitleCaseRenderer;
import org.tinymediamanager.core.jmte.NamedUpperCaseRenderer;
import org.tinymediamanager.core.jmte.RegexpProcessor;
import org.tinymediamanager.core.jmte.TmmModelAdaptor;
import org.tinymediamanager.core.jmte.ZeroNumberRenderer;
import org.tinymediamanager.core.tvshow.TvShowRenamer;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;

public class TvShowEpisodePostProcessExecutor
extends PostProcessExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(TvShowEpisodePostProcessExecutor.class);

    public TvShowEpisodePostProcessExecutor(PostProcess postProcess, List<TvShowEpisode> episodes) {
        super(postProcess, episodes);
    }

    @Override
    protected void execute() {
        for (MediaEntity mediaEntity : this.entities) {
            if (!(mediaEntity instanceof TvShowEpisode)) continue;
            TvShowEpisode episode = (TvShowEpisode)mediaEntity;
            LOGGER.info("Executing post process '{}' for episode '{}'", (Object)this.postProcess.getName(), (Object)episode.getTitle());
            HashMap<String, Object> mappings = new HashMap<String, Object>();
            mappings.put("tvShow", episode.getTvShow());
            mappings.put("season", episode.getTvShowSeason());
            mappings.put("episode", episode);
            String[] command = this.substituteTokens(mappings);
            try {
                this.executeCommand(command, episode);
                LOGGER.info("Successfully executed post process '{}' for episode '{}'", (Object)this.postProcess.getName(), (Object)episode.getTitle());
            }
            catch (InterruptedException e) {
                return;
            }
            catch (Exception e) {
                LOGGER.error("Problem executing post process '{}' - '{}'", (Object)this.postProcess.getName(), (Object)e.getMessage());
            }
        }
    }

    private String[] substituteTokens(Map<String, Object> mappings) {
        Engine engine = Engine.createEngine();
        engine.registerRenderer(Number.class, (Renderer)new ZeroNumberRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedArrayRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedArrayUniqueRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedBitrateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedDateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedFilesizeRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedFramerateRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedLowerCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedNumberRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedReplacementRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedSplitRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedTitleCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new NamedUpperCaseRenderer());
        engine.registerNamedRenderer((NamedRenderer)new TvShowRenamer.TvShowNamedFirstCharacterRenderer());
        engine.registerNamedRenderer((NamedRenderer)new ChainedNamedRenderer(engine.getAllNamedRenderers()));
        engine.registerAnnotationProcessor((AnnotationProcessor)new RegexpProcessor());
        engine.setModelAdaptor((ModelAdaptor)new TmmModelAdaptor());
        if (this.postProcess.getPath() == null || this.postProcess.getPath().isEmpty()) {
            String transformed = engine.transform(JmteUtils.morphTemplate(this.postProcess.getCommand(), TvShowRenamer.getTokenMap()), mappings);
            return new String[]{transformed};
        }
        String[] splitted = this.postProcess.getCommand().split("\\n");
        for (int i = 0; i < splitted.length; ++i) {
            splitted[i] = engine.transform(JmteUtils.morphTemplate(splitted[i], TvShowRenamer.getTokenMap()), mappings);
        }
        return splitted;
    }
}

