/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.movie.filenaming;

import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.movie.filenaming.IMovieSetFileNaming;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MovieSetDiscartNaming implements IMovieSetFileNaming
{
    MOVIE_DISC{

        @Override
        public String getFilename(String basename, String extension) {
            return "movieset-disc." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    MOVIESET_DISC{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-disc." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    MOVIE_DISCART{

        @Override
        public String getFilename(String basename, String extension) {
            return "movieset-discart." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    MOVIESET_DISCART{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-discart." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.MOVIE_FOLDER;
        }
    }
    ,
    KODI_DISC{

        @Override
        public String getFilename(String basename, String extension) {
            return "disc." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.KODI_STYLE_FOLDER;
        }
    }
    ,
    KODI_DISCART{

        @Override
        public String getFilename(String basename, String extension) {
            return "discart." + extension;
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.KODI_STYLE_FOLDER;
        }
    }
    ,
    AUTOMATOR_DISC{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-disc." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER;
        }
    }
    ,
    AUTOMATOR_DISCART{

        @Override
        public String getFilename(String basename, String extension) {
            return StringUtils.isNotBlank((CharSequence)basename) ? basename + "-discart." + extension : "";
        }

        @Override
        public IMovieSetFileNaming.Location getFolderLocation() {
            return IMovieSetFileNaming.Location.AUTOMATOR_STYLE_FOLDER;
        }
    };

}

