/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.core.mediainfo;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.mediainfo.MediaInfoFile;
import org.tinymediamanager.thirdparty.MediaInfo;

public class MediaInfoXMLParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaInfoXMLParser.class);
    private static final Pattern DURATION_HOUR_PATTERN = Pattern.compile("(\\d*?) h");
    private static final Pattern DURATION_MINUTE_PATTERN = Pattern.compile("(\\d*?) min");
    private static final Pattern DURATION_SECOND_PATTERN = Pattern.compile("(\\d*?) s");
    private static final String DUMMY_FILENAME = "/tmp/dummy.bdmv";
    private Path file = null;

    public MediaInfoXMLParser(Path file) {
        this.file = file;
    }

    public List<MediaInfoFile> parseXML() throws Exception {
        Document document;
        ArrayList<MediaInfoFile> files = new ArrayList<MediaInfoFile>();
        try (InputStream is = Files.newInputStream(this.file, new OpenOption[0]);){
            document = Jsoup.parse((InputStream)is, (String)"UTF-8", (String)"", (Parser)Parser.xmlParser());
        }
        Elements rootElements = document.select("MediaInfo");
        if (rootElements.isEmpty()) {
            throw new InvalidXmlException("Invalid/unparseable XML");
        }
        Element root = (Element)rootElements.get(0);
        Elements fileElements = root.select("media");
        if (fileElements.isEmpty()) {
            fileElements = root.select("file");
        }
        for (Element fileInXML : fileElements) {
            MediaInfoFile miFile = new MediaInfoFile(Paths.get(DUMMY_FILENAME, new String[0]));
            miFile.setSnapshot(new EnumMap<MediaInfo.StreamKind, List<Map<String, String>>>(MediaInfo.StreamKind.class));
            ArrayList<MiTrack> tracks = new ArrayList<MiTrack>();
            for (Element track : fileInXML.select("track")) {
                MiTrack miTrack = new MiTrack();
                miTrack.type = track.attr("type");
                miTrack.elements.addAll((Collection<Element>)track.children());
                tracks.add(miTrack);
            }
            MediaInfo.StreamKind currentKind = null;
            ArrayList streamInfoList = new ArrayList(tracks.size());
            LinkedHashMap<Object, String> generalStreamInfo = null;
            long kindFilesize = 0L;
            long kindStreamsize = 0L;
            int kindDuration = 0;
            int duration = 0;
            long filesize = 0L;
            for (MiTrack track : tracks) {
                if (MediaInfo.StreamKind.valueOf(track.type) != currentKind) {
                    if (kindDuration > duration) {
                        duration = kindDuration;
                    }
                    if (kindFilesize > filesize) {
                        filesize = kindFilesize;
                    }
                    if (kindStreamsize > filesize) {
                        filesize = kindStreamsize;
                    }
                    streamInfoList = new ArrayList(tracks.size());
                    kindFilesize = 0L;
                    kindStreamsize = 0L;
                    kindDuration = 0;
                }
                LinkedHashMap<Object, String> streamInfo = new LinkedHashMap<Object, String>();
                currentKind = MediaInfo.StreamKind.valueOf(track.type);
                if (currentKind == MediaInfo.StreamKind.General) {
                    generalStreamInfo = streamInfo;
                }
                for (Element elem : track.elements) {
                    Object key;
                    int i = 0;
                    String ename = elem.tagName();
                    if (!ename.equals(key = this.getMappedKey(ename))) {
                        LOGGER.trace("Key '{}' was repaced with '{}'", (Object)ename, key);
                    }
                    while (streamInfo.containsKey(key)) {
                        key = ename + "/String";
                        if (i > 0) {
                            key = (String)key + i;
                        }
                        ++i;
                    }
                    String value = elem.ownText();
                    if (value.isEmpty()) {
                        if (elem.childNodeSize() <= 0) continue;
                        for (Element child : elem.children()) {
                            if (child.ownText().isEmpty()) continue;
                            streamInfo.put(elem.tagName() + "/" + child.tagName(), child.ownText());
                        }
                    }
                    if (((String)key).equals("Width") || ((String)key).equals("Height")) {
                        value = value.replace("pixels", "").replace(" ", "").strip();
                    }
                    if (((String)key).equals("FileSize")) {
                        try {
                            kindFilesize += this.parseSize(value);
                            value = String.valueOf(kindFilesize);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.trace("could not parse filesize - {}", (Object)e.getMessage());
                        }
                    }
                    if (((String)key).equals("Stream_size")) {
                        try {
                            kindStreamsize += this.parseSize(value);
                            value = String.valueOf(kindStreamsize);
                        }
                        catch (NumberFormatException e) {
                            LOGGER.trace("could not parse streamsize - {}", (Object)e.getMessage());
                        }
                    }
                    if (((String)key).equals("Duration") && MediaInfo.StreamKind.General == currentKind) {
                        try {
                            double d = Double.parseDouble(value.replace(".", ""));
                            value = String.valueOf(kindDuration += (int)d / 1000);
                        }
                        catch (NumberFormatException e) {
                            try {
                                int hours = 0;
                                int minutes = 0;
                                int seconds = 0;
                                Matcher matcher = DURATION_HOUR_PATTERN.matcher(value);
                                if (matcher.find()) {
                                    hours = Integer.parseInt(matcher.group(1));
                                }
                                if ((matcher = DURATION_MINUTE_PATTERN.matcher(value)).find()) {
                                    minutes = Integer.parseInt(matcher.group(1));
                                }
                                if ((matcher = DURATION_SECOND_PATTERN.matcher(value)).find()) {
                                    seconds = Integer.parseInt(matcher.group(1));
                                }
                                value = String.valueOf(kindDuration += hours * 3600 + minutes * 60 + seconds);
                            }
                            catch (NumberFormatException ignored) {
                                LOGGER.trace("could not parse duration - {}", (Object)e.getMessage());
                            }
                        }
                    }
                    if ("Source".equals(key)) {
                        miFile.setFilename(value);
                    }
                    streamInfo.put(key, value);
                    if (((String)key).equals(this.getMappedKey((String)key))) continue;
                    LOGGER.trace("Duplicate Key '{}'", key);
                    streamInfo.put(this.getMappedKey((String)key), value);
                }
                streamInfoList.add(streamInfo);
                miFile.getSnapshot().put(MediaInfo.StreamKind.valueOf(track.type), streamInfoList);
            }
            miFile.setDuration(duration);
            miFile.setFilesize(filesize);
            if (generalStreamInfo != null) {
                String complete;
                String folder = (String)generalStreamInfo.get("Folder_name");
                String fn = (String)generalStreamInfo.get("File_name");
                String ext = (String)generalStreamInfo.get("File_extension");
                if (folder != null) {
                    folder = folder.replace("\\", "/");
                    miFile.setPath(folder);
                }
                if (fn != null && ext != null && fn.length() > 3) {
                    miFile.setFilename(fn + "." + ext);
                }
                String pathToEval = "";
                String ref = fileInXML.attr("ref");
                if (ref != null && ref.length() > 5) {
                    pathToEval = ref;
                }
                if ((complete = (String)generalStreamInfo.get("Complete_name")) != null && complete.length() > 5) {
                    pathToEval = complete;
                }
                if (pathToEval != null && !pathToEval.isEmpty()) {
                    Path p = Paths.get(pathToEval = pathToEval.replace("\\", "/"), new String[0]);
                    if (p.getFileName() != null && p.getFileName().toString().length() > 3) {
                        miFile.setFilename(p.getFileName().toString());
                    }
                    if (p.getParent() != null) {
                        miFile.setPath(p.getParent().toString());
                    }
                }
                if (generalStreamInfo.get("VideoCount") == null && miFile.getSnapshot().get((Object)MediaInfo.StreamKind.Video) != null) {
                    generalStreamInfo.put("VideoCount", String.valueOf(miFile.getSnapshot().get((Object)MediaInfo.StreamKind.Video).size()));
                }
                if (generalStreamInfo.get("AudioCount") == null && miFile.getSnapshot().get((Object)MediaInfo.StreamKind.Audio) != null) {
                    generalStreamInfo.put("AudioCount", String.valueOf(miFile.getSnapshot().get((Object)MediaInfo.StreamKind.Audio).size()));
                }
                if (generalStreamInfo.get("TextCount") == null && miFile.getSnapshot().get((Object)MediaInfo.StreamKind.Text) != null) {
                    generalStreamInfo.put("TextCount", String.valueOf(miFile.getSnapshot().get((Object)MediaInfo.StreamKind.Text).size()));
                }
            }
            String ext = FilenameUtils.getExtension((String)miFile.getFilename()).toLowerCase(Locale.ROOT);
            if (!Settings.getInstance().getAllSupportedFileTypes().contains("." + ext) && !"mpls".equalsIgnoreCase(ext)) continue;
            files.add(miFile);
        }
        return files;
    }

    private String getMappedKey(String key) {
        String k = key;
        switch (key) {
            case "Codec/String": {
                k = "CodecID/Hint";
                break;
            }
            case "Count_of_audio_streams": {
                k = "AudioCount";
                break;
            }
            case "Count_of_text_streams": {
                k = "TextCount";
                break;
            }
            case "Count_of_video_streams": {
                k = "VideoCount";
                break;
            }
            case "Count_of_menu_streams": {
                k = "MenuCount";
                break;
            }
            case "Channel_s_": 
            case "Channels": {
                k = "Channel(s)";
                break;
            }
            case "Bit_rate": {
                k = "BitRate";
                break;
            }
            case "File_size": {
                k = "FileSize";
                break;
            }
            case "Overall_bit_rate": {
                k = "OverallBitRate";
                break;
            }
            case "Count_of_stream_of_this_kind": {
                k = "StreamCount";
                break;
            }
            case "Codec_Extensions_usually_used": {
                k = "Codec/Extensions";
                break;
            }
            case "Scan_type": {
                k = "ScanType";
                break;
            }
        }
        return k;
    }

    private long parseSize(String size) {
        long s = 0L;
        size = size.replaceAll("\\(.*$", "").strip();
        int factor = 1;
        if (size.toLowerCase(Locale.ROOT).endsWith("kib")) {
            factor = 1024;
        }
        if (size.toLowerCase(Locale.ROOT).endsWith("mib")) {
            factor = 0x100000;
        }
        if (size.toLowerCase(Locale.ROOT).endsWith("gib")) {
            factor = 0x40000000;
        }
        size = size.replaceAll("\\s.*$", "");
        Double d = Double.parseDouble(size);
        s = d.longValue();
        return s *= (long)factor;
    }

    public static class InvalidXmlException
    extends Exception {
        public InvalidXmlException(String message) {
            super(message);
        }
    }

    public static class MiTrack {
        public String type;
        public final List<Element> elements = new ArrayList<Element>();
    }
}

