/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

public final class MessageUtil {
    protected static final String TAINT_CHAR = "~";

    public static boolean isTainted(String text) {
        return text != null && text.startsWith(TAINT_CHAR);
    }

    public static String taint(Object text) {
        return TAINT_CHAR + text;
    }

    public static String untaint(String text) {
        return MessageUtil.isTainted(text) ? text.substring(TAINT_CHAR.length()) : text;
    }

    public static String compose(String key, Object ... args) {
        StringBuilder buf = new StringBuilder();
        buf.append(key);
        buf.append('|');
        for (int i = 0; i < args.length; ++i) {
            if (i > 0) {
                buf.append('|');
            }
            String arg = args[i] == null ? "" : String.valueOf(args[i]);
            int alength = arg.length();
            for (int p = 0; p < alength; ++p) {
                char ch = arg.charAt(p);
                if (ch == '|') {
                    buf.append("\\!");
                    continue;
                }
                if (ch == '\\') {
                    buf.append("\\\\");
                    continue;
                }
                buf.append(ch);
            }
        }
        return buf.toString();
    }

    public static String compose(String key, String ... args) {
        return MessageUtil.compose(key, (Object[])args);
    }

    public static String tcompose(String key, Object ... args) {
        int acount = args.length;
        String[] targs = new String[acount];
        for (int ii = 0; ii < acount; ++ii) {
            targs[ii] = MessageUtil.taint(args[ii]);
        }
        return MessageUtil.compose(key, (Object[])targs);
    }

    public static String tcompose(String key, String ... args) {
        int nn = args.length;
        for (int ii = 0; ii < nn; ++ii) {
            args[ii] = MessageUtil.taint(args[ii]);
        }
        return MessageUtil.compose(key, args);
    }

    public static String escape(String message) {
        return message.replace("'", "''");
    }

    public static String unescape(String value) {
        int bsidx = value.indexOf(92);
        if (bsidx == -1) {
            return value;
        }
        StringBuilder buf = new StringBuilder();
        int vlength = value.length();
        for (int ii = 0; ii < vlength; ++ii) {
            char ch = value.charAt(ii);
            if (ch != '\\' || ii == vlength - 1) {
                buf.append(ch);
                continue;
            }
            buf.append((ch = value.charAt(++ii)) == '!' ? (char)'|' : (char)ch);
        }
        return buf.toString();
    }
}

