/*
 * Decompiled with CFR 0.152.
 */
package org.mp4parser.muxer;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import org.mp4parser.muxer.DataSource;
import org.mp4parser.tools.CastUtils;

public class MultiFileDataSourceImpl
implements DataSource {
    FileChannel[] fcs;
    int index = 0;

    public MultiFileDataSourceImpl(File ... f) throws FileNotFoundException {
        this.fcs = new FileChannel[f.length];
        for (int i = 0; i < f.length; ++i) {
            this.fcs[i] = new FileInputStream(f[i]).getChannel();
        }
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        int numOfBytesToRead = byteBuffer.remaining();
        int numOfBytesRead = 0;
        numOfBytesRead = this.fcs[this.index].read(byteBuffer);
        if (numOfBytesRead != numOfBytesToRead) {
            ++this.index;
            return numOfBytesRead + this.read(byteBuffer);
        }
        return numOfBytesRead;
    }

    @Override
    public long size() throws IOException {
        long size = 0L;
        for (FileChannel fileChannel : this.fcs) {
            size += fileChannel.size();
        }
        return size;
    }

    @Override
    public long position() throws IOException {
        long position = 0L;
        for (int i = 0; i < this.index; ++i) {
            position += this.fcs[i].size();
        }
        return position + this.fcs[this.index].position();
    }

    @Override
    public void position(long nuPos) throws IOException {
        for (int i = 0; i < this.fcs.length; ++i) {
            if (nuPos - this.fcs[i].size() < 0L) {
                this.fcs[i].position(nuPos);
                this.index = i;
                break;
            }
            nuPos -= this.fcs[i].size();
        }
    }

    @Override
    public long transferTo(long startPosition, long count, WritableByteChannel sink) throws IOException {
        if (count == 0L) {
            return 0L;
        }
        long currentPos = 0L;
        for (FileChannel fc : this.fcs) {
            long size = fc.size();
            if (startPosition >= currentPos && startPosition < currentPos + size && startPosition + count > currentPos) {
                long bytesToTransfer = Math.min(count, size - (startPosition - currentPos));
                fc.transferTo(startPosition - currentPos, bytesToTransfer, sink);
                return bytesToTransfer + this.transferTo(startPosition + bytesToTransfer, count - bytesToTransfer, sink);
            }
            currentPos += size;
        }
        return 0L;
    }

    @Override
    public ByteBuffer map(long startPosition, long size) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(CastUtils.l2i((long)size));
        this.transferTo(startPosition, size, Channels.newChannel(baos));
        return ByteBuffer.wrap(baos.toByteArray());
    }

    @Override
    public void close() throws IOException {
        for (FileChannel fileChannel : this.fcs) {
            fileChannel.close();
        }
    }
}

