/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.support.model.dlna.message.header;

import java.util.ArrayList;
import java.util.List;
import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.types.PragmaType;
import org.jupnp.support.model.dlna.message.header.DLNAHeader;

public class PragmaHeader
extends DLNAHeader<List<PragmaType>> {
    public PragmaHeader() {
        this.setValue(new ArrayList());
    }

    public void setString(String s) {
        if (!s.isEmpty()) {
            if (s.endsWith(";")) {
                s = s.substring(0, s.length() - 1);
            }
            String[] list = s.split("\\s*;\\s*");
            ArrayList<PragmaType> value = new ArrayList<PragmaType>();
            for (String pragma : list) {
                value.add(PragmaType.valueOf((String)pragma));
            }
            return;
        }
        throw new InvalidHeaderException("Invalid Pragma header value: " + s);
    }

    public String getString() {
        List v = (List)this.getValue();
        StringBuilder sb = new StringBuilder();
        for (PragmaType pragma : v) {
            sb.append(sb.length() == 0 ? "" : ",");
            sb.append(pragma.getString());
        }
        return sb.toString();
    }
}

