/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowTagFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    private final TmmTableFormat.StringComparator comparator;

    public TvShowTagFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.comparator = new TmmTableFormat.StringComparator();
        this.buildAndInstallTagsArray();
        EventBus.registerListener(EventBus.TOPIC_TV_SHOWS_UI, event -> this.buildAndInstallTagsArray());
    }

    @Override
    public String getId() {
        return "tvShowTag";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List tags = this.checkComboBox.getSelectedItems();
        if (!invert && tags.isEmpty() && tvShow.getTags().isEmpty()) {
            return true;
        }
        if (invert && tags.isEmpty() && !tvShow.getTags().isEmpty()) {
            return true;
        }
        for (TvShowEpisode episode : episodes) {
            if (!invert && tags.isEmpty() && episode.getTags().isEmpty()) {
                return true;
            }
            if (!invert || !tags.isEmpty() || episode.getTags().isEmpty()) continue;
            return true;
        }
        for (String tag : tags) {
            boolean containsTags = tvShow.getTags().contains(tag);
            if (!invert && containsTags) {
                return true;
            }
            if (invert && containsTags) {
                return false;
            }
            for (TvShowEpisode episode : episodes) {
                if (!(invert ^ episode.getTags().contains(tag))) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("movieextendedsearch.tag"));
    }

    private void buildAndInstallTagsArray() {
        TreeSet<String> tags = new TreeSet<String>(this.tvShowList.getTagsInTvShows());
        tags.addAll(this.tvShowList.getTagsInEpisodes());
        Utils.removeDuplicateStringFromCollectionIgnoreCase(tags);
        if (!SetUtils.equals(this.oldValues, tags)) {
            this.oldValues.clear();
            this.oldValues.addAll(tags);
            List<String> sortedTags = ListUtils.asSortedList(tags, this.comparator);
            SwingUtilities.invokeLater(() -> this.setValues(sortedTags));
        }
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

