/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieCountAudioStreamFilter
extends AbstractCheckComboBoxMovieUIFilter<Integer> {
    public MovieCountAudioStreamFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith((String)s2));
        this.buildAndInstallAudioStreamCountArray();
        EventBus.registerListener(EventBus.TOPIC_MOVIES_UI, event -> this.buildAndInstallAudioStreamCountArray());
    }

    @Override
    protected String parseTypeToString(Integer type) throws Exception {
        return type.toString();
    }

    @Override
    protected Integer parseStringToType(String string) throws Exception {
        return Integer.parseInt(string);
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.countAudioStreams"));
    }

    @Override
    public String getId() {
        return "movieCountAudioStream";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains(movie.getMediaInfoAudioStreamCount());
    }

    private void buildAndInstallAudioStreamCountArray() {
        HashSet<Integer> audioStreamCountInMovies = new HashSet<Integer>(this.movieList.getAudioStreamsInMovies());
        if (!SetUtils.equals(this.oldValues, audioStreamCountInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(audioStreamCountInMovies);
            List<Integer> sortedAudioStreamCount = ListUtils.asSortedList(audioStreamCountInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedAudioStreamCount));
        }
    }
}

