/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.entities.MediaCertification;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieCertificationFilter
extends AbstractCheckComboBoxMovieUIFilter<MediaCertification> {
    public MovieCertificationFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toString().toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallCertificationArray();
        EventBus.registerListener(EventBus.TOPIC_MOVIES_UI, event -> this.buildAndInstallCertificationArray());
    }

    @Override
    public String getId() {
        return "movieCertification";
    }

    @Override
    public boolean accept(Movie movie) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return selectedItems.contains((Object)movie.getCertification());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.certification"));
    }

    private void buildAndInstallCertificationArray() {
        HashSet<MediaCertification> certificationsInMovies = new HashSet<MediaCertification>(this.movieList.getCertificationsInMovies());
        if (!SetUtils.equals(this.oldValues, certificationsInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(certificationsInMovies);
            List<MediaCertification> sortedCertifications = ListUtils.asSortedList(certificationsInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedCertifications));
        }
    }

    @Override
    protected String parseTypeToString(MediaCertification type) throws Exception {
        return type.name();
    }

    @Override
    protected MediaCertification parseStringToType(String string) throws Exception {
        return MediaCertification.valueOf(string);
    }
}

