/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.thirdparty;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.lang.invoke.CallSite;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.Message;
import org.tinymediamanager.core.MessageManager;
import org.tinymediamanager.core.Settings;
import org.tinymediamanager.core.Utils;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.tvshow.TvShowList;
import org.tinymediamanager.core.tvshow.TvShowModuleManager;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.jsonrpc.api.AbstractCall;
import org.tinymediamanager.jsonrpc.api.call.Application;
import org.tinymediamanager.jsonrpc.api.call.AudioLibrary;
import org.tinymediamanager.jsonrpc.api.call.Files;
import org.tinymediamanager.jsonrpc.api.call.System;
import org.tinymediamanager.jsonrpc.api.call.VideoLibrary;
import org.tinymediamanager.jsonrpc.api.model.ApplicationModel;
import org.tinymediamanager.jsonrpc.api.model.GlobalModel;
import org.tinymediamanager.jsonrpc.api.model.ListModel;
import org.tinymediamanager.jsonrpc.api.model.VideoModel;
import org.tinymediamanager.jsonrpc.config.HostConfig;
import org.tinymediamanager.jsonrpc.io.ApiCallback;
import org.tinymediamanager.jsonrpc.io.ApiException;
import org.tinymediamanager.jsonrpc.io.ConnectionListener;
import org.tinymediamanager.jsonrpc.io.JavaConnectionManager;
import org.tinymediamanager.jsonrpc.io.JsonApiRequest;
import org.tinymediamanager.jsonrpc.notification.AbstractEvent;
import org.tinymediamanager.scraper.util.DateUtils;

public class KodiRPC {
    private static final Logger LOGGER = LoggerFactory.getLogger(KodiRPC.class);
    private static KodiRPC instance;
    private static final String SEPARATOR_REGEX = "[\\/\\\\]+";
    private final JavaConnectionManager connectionManager = new JavaConnectionManager();
    private final Map<String, String> videodatasources = new LinkedHashMap<String, String>();
    private final List<String> audiodatasources = new ArrayList<String>();
    private final Map<UUID, Integer> moviemappings = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> tvshowmappings = new HashMap<UUID, Integer>();
    private final Map<UUID, Integer> episodemappings = new HashMap<UUID, Integer>();
    private String kodiVersion = "";

    private KodiRPC() {
        this.connectionManager.registerConnectionListener(new ConnectionListener(){

            @Override
            public void notificationReceived(AbstractEvent event) {
                LOGGER.debug("Event received: {}", (Object)event);
            }

            @Override
            public void disconnected() {
                LOGGER.info("Kodi RPC: Disconnected");
                MessageManager.getInstance().pushMessage(new Message((Object)Message.MessageLevel.INFO, "Kodi disconnected"));
            }

            @Override
            public void connected() {
                LOGGER.info("Kodi RPC: Connected to {}", (Object)KodiRPC.this.connectionManager.getHostConfig().getAddress());
                MessageManager.getInstance().pushMessage(new Message((Object)Message.MessageLevel.INFO, "Kodi connected"));
            }
        });
    }

    public static synchronized KodiRPC getInstance() {
        if (instance == null) {
            instance = new KodiRPC();
        }
        return instance;
    }

    public boolean isConnected() {
        return this.connectionManager.isConnected();
    }

    public String getVersion() {
        return "Kodi " + this.kodiVersion;
    }

    public void cleanVideoLibrary() {
        VideoLibrary.Clean call = new VideoLibrary.Clean(true);
        this.sendWoResponse(call);
    }

    public void scanVideoLibrary() {
        VideoLibrary.Scan call = new VideoLibrary.Scan(null, true);
        this.sendWoResponse(call);
    }

    public void scanVideoLibrary(String dir) {
        VideoLibrary.Scan call = new VideoLibrary.Scan(dir, true);
        this.sendWoResponse(call);
    }

    public Map<String, String> getVideoDataSources() {
        return this.videodatasources;
    }

    @Deprecated
    private void getAndSetVideoDataSources() {
        Files.GetSources call = new Files.GetSources("video");
        this.send(call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            this.videodatasources.clear();
            try {
                for (ListModel.SourceItem res : call.getResults()) {
                    LOGGER.debug("Kodi datasource: {}", (Object)res.file);
                    if (res.file.startsWith("multipath")) {
                        String[] source;
                        String mp = res.file.replace("multipath://", "");
                        for (String ds : source = mp.split("/")) {
                            String s = URLDecoder.decode(ds, StandardCharsets.UTF_8);
                            this.videodatasources.put(s, res.label);
                            LOGGER.debug("     {}", (Object)s);
                        }
                        continue;
                    }
                    this.videodatasources.put(res.file, res.label);
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not process Kodi RPC response - '{}'", (Object)e.getMessage());
            }
        }
    }

    @Deprecated
    private String detectDatasource(String file) {
        ArrayList<String> list = new ArrayList<String>(this.videodatasources.keySet());
        Collections.sort(list);
        Collections.reverse(list);
        for (String ds : list) {
            if (!file.startsWith(ds)) continue;
            return ds;
        }
        return "";
    }

    private String getParentAndFileDelimited(String path) throws Exception {
        Path p = Path.of(path, new String[0]);
        if (p.getParent() == null) {
            return "|" + p.getFileName().toString();
        }
        return p.getParent().getFileName().toString() + "|" + p.getFileName().toString();
    }

    protected void getAndSetMovieMappings() {
        VideoLibrary.GetMovies call = new VideoLibrary.GetMovies("file");
        this.send(call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            this.getAndSetMovieMappings(call.getResults());
        }
    }

    protected int getMappedMoviesSize() {
        return this.moviemappings.size();
    }

    protected void getAndSetMovieMappings(ArrayList<VideoModel.MovieDetail> movies) {
        this.moviemappings.clear();
        LOGGER.debug("KODI {} movies", (Object)movies.size());
        HashMap<String, UUID> tmmMovies = new HashMap<String, UUID>();
        for (Movie movie : MovieModuleManager.getInstance().getMovieList().getMovies()) {
            tmmMovies.putAll(this.parseTmmEntity(movie, movie.isDisc(), false));
        }
        block3: for (VideoModel.MovieDetail kodiMovie : movies) {
            if (kodiMovie.file == null || kodiMovie.file.isEmpty() || kodiMovie.movieid <= 0) continue;
            try {
                String[] files;
                if (kodiMovie.file.startsWith("stack")) {
                    block4: for (String kodiFile : files = kodiMovie.file.split(" , ")) {
                        for (String tmmPath : tmmMovies.keySet()) {
                            if (!Path.of(kodiFile, new String[0]).endsWith(Path.of(tmmPath, new String[0]))) continue;
                            UUID uuid = (UUID)tmmMovies.get(tmmPath);
                            if (!this.moviemappings.containsKey(uuid)) {
                                this.moviemappings.put(uuid, kodiMovie.movieid);
                                continue block4;
                            }
                            LOGGER.warn("Kodi movie '{}' already attached to another datasource - skipping", (Object)kodiMovie.label);
                            continue block4;
                        }
                    }
                    continue;
                }
                files = tmmMovies.keySet().iterator();
                while (files.hasNext()) {
                    String tmmPath = (String)files.next();
                    if (!Path.of(kodiMovie.file, new String[0]).endsWith(Path.of(tmmPath, new String[0]))) continue;
                    UUID uuid = (UUID)tmmMovies.get(tmmPath);
                    if (!this.moviemappings.containsKey(uuid)) {
                        this.moviemappings.put(uuid, kodiMovie.movieid);
                        continue block3;
                    }
                    LOGGER.warn("Kodi movie '{}' already attached to another datasource - skipping", (Object)kodiMovie.label);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Kodi movie '{}' error on mapping - skipping", (Object)kodiMovie.file);
            }
        }
        LOGGER.info("mapped {} movies", (Object)this.moviemappings.size());
    }

    @Deprecated
    private String parseDatasourceName(Path ds) {
        String dsName = "";
        if (ds.getFileName() != null) {
            dsName = ds.getFileName().toString();
        } else {
            File f = ds.toFile();
            dsName = f.getName();
        }
        if (dsName.isEmpty()) {
            dsName = ds.toString();
        }
        return dsName;
    }

    private Map<String, UUID> parseTmmEntity(MediaEntity entity, boolean isDisc, boolean isMultiEp) {
        HashMap<String, UUID> fileMap = new HashMap<String, UUID>();
        Path ds = Paths.get(entity.getDataSource(), new String[0]);
        if (ds == null || ds.toString().isBlank()) {
            LOGGER.debug("Datasource was empty? Ignoring {}", (Object)entity);
            return fileMap;
        }
        ds = ds.toAbsolutePath();
        MediaFile main = entity.getMainFile();
        ArrayList<MediaEntity> entitiesToProcess = new ArrayList<MediaEntity>();
        if (isMultiEp) {
            TvShowEpisode ep = (TvShowEpisode)entity;
            List<TvShowEpisode> eps = TvShowList.getTvEpisodesByFile(ep.getTvShow(), main.getFile());
            entitiesToProcess.addAll(eps);
        } else {
            entitiesToProcess.add(entity);
        }
        for (MediaEntity me : entitiesToProcess) {
            try {
                if (isDisc) {
                    for (MediaFile mf : me.getMediaFiles(MediaFileType.VIDEO)) {
                        Path file = null;
                        if (mf.getFilename().equalsIgnoreCase("VIDEO_TS")) {
                            file = mf.getFileAsPath().resolve("VIDEO_TS.IFO");
                        } else if (mf.getFilename().equalsIgnoreCase("HVDVD_TS")) {
                            file = mf.getFileAsPath().resolve("HV000I01.IFO");
                        } else if (mf.getFilename().equalsIgnoreCase("BDMV")) {
                            file = mf.getFileAsPath().resolve("index.bdmv");
                        } else if (mf.isMainDiscIdentifierFile()) {
                            file = mf.getFileAsPath();
                        }
                        if (file == null) continue;
                        String rel = Utils.relPath(Path.of(entity.getDataSource(), new String[0]), file);
                        if (!fileMap.containsKey(rel)) {
                            fileMap.put(rel, me.getDbId());
                            continue;
                        }
                        LOGGER.warn("File '{}' already attached to another datasource - skipping", (Object)rel);
                    }
                    continue;
                }
                Object rel = Utils.relPath(Path.of(entity.getDataSource(), new String[0]), me.getPathNIO());
                if (!fileMap.containsKey(rel)) {
                    fileMap.put((String)rel, me.getDbId());
                    continue;
                }
                int i = 2;
                while (fileMap.containsKey((String)rel + "#" + i)) {
                    ++i;
                }
                LOGGER.debug("Adding multi-EP for {} as {}", rel, (Object)((String)rel + "#" + i));
                rel = (String)rel + "#" + i;
                fileMap.put((String)rel, me.getDbId());
            }
            catch (Exception e) {
                LOGGER.warn("File '{}' error on mapping - skipping", (Object)e.getMessage());
            }
        }
        return fileMap;
    }

    protected void getAndSetTvShowMappings() {
        VideoLibrary.GetTVShows tvShowCall = new VideoLibrary.GetTVShows("file");
        this.send(tvShowCall);
        if (tvShowCall.getResults() != null && !tvShowCall.getResults().isEmpty()) {
            this.getAndSetTvShowMappings(tvShowCall.getResults());
        }
    }

    protected int getMappedTvShowsSize() {
        return this.tvshowmappings.size();
    }

    protected void getAndSetTvShowMappings(ArrayList<VideoModel.TVShowDetail> shows) {
        this.tvshowmappings.clear();
        this.episodemappings.clear();
        LOGGER.debug("KODI {} shows", (Object)shows.size());
        HashMap<String, UUID> tmmShows = new HashMap<String, UUID>();
        for (TvShow show : TvShowModuleManager.getInstance().getTvShowList().getTvShows()) {
            tmmShows.putAll(this.parseTmmEntity(show, false, false));
        }
        block3: for (VideoModel.TVShowDetail kodiShow : shows) {
            if (kodiShow.file == null || kodiShow.file.isEmpty() || kodiShow.tvshowid <= 0) continue;
            try {
                for (String tmmPath : tmmShows.keySet()) {
                    if (!Path.of(kodiShow.file, new String[0]).endsWith(Path.of(tmmPath, new String[0]))) continue;
                    UUID uuid = (UUID)tmmShows.get(tmmPath);
                    if (!this.tvshowmappings.containsKey(uuid)) {
                        this.tvshowmappings.put(uuid, kodiShow.tvshowid);
                        continue block3;
                    }
                    LOGGER.warn("Kodi show '{}' already attached to another datasource - skipping", (Object)kodiShow.label);
                }
            }
            catch (Exception e) {
                LOGGER.warn("Kodi show '{}' error on mapping - skipping", (Object)kodiShow.file);
            }
        }
        LOGGER.info("mapped {} shows", (Object)this.tvshowmappings.size());
    }

    public void refreshFromNfo(Movie movie) {
        Integer kodiID = this.moviemappings.get(movie.getDbId());
        if (kodiID != null) {
            List<MediaFile> nfo = movie.getMediaFiles(MediaFileType.NFO);
            if (!nfo.isEmpty()) {
                LOGGER.debug("Kodi RPC: Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
            } else {
                LOGGER.debug("Kodi RPC: No NFO file found to refresh! {}", (Object)movie.getTitle());
            }
            VideoLibrary.RefreshMovie call = new VideoLibrary.RefreshMovie(kodiID, false);
            this.sendWoResponse(call);
        } else {
            LOGGER.warn("Kodi RPC: Unable to refresh - could not map movie '{}' to Kodi library!", (Object)movie.getTitle());
        }
    }

    public void refreshFromNfo(TvShow tvShow) {
        Integer kodiID = this.tvshowmappings.get(tvShow.getDbId());
        if (kodiID != null) {
            List<MediaFile> nfo = tvShow.getMediaFiles(MediaFileType.NFO);
            if (!nfo.isEmpty()) {
                LOGGER.debug("Kodi RPC: Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
            } else {
                LOGGER.debug("Kodi RPC: No NFO file found to refresh! {}", (Object)tvShow.getTitle());
            }
            VideoLibrary.RefreshTVShow call = new VideoLibrary.RefreshTVShow(kodiID, (Boolean)false, true);
            this.sendWoResponse(call);
        } else {
            LOGGER.warn("Kodi RPC: Unable to refresh - could not map TV show '{}' to Kodi library!", (Object)tvShow.getTitle());
        }
    }

    public void refreshFromNfo(TvShowEpisode episode) {
        Integer kodiID = this.getEpisodeId(episode);
        List<MediaFile> nfo = episode.getMediaFiles(MediaFileType.NFO);
        if (!nfo.isEmpty()) {
            LOGGER.debug("Kodi RPC: Refreshing from NFO: {}", (Object)nfo.get(0).getFileAsPath());
        } else {
            LOGGER.debug("Kodi RPC: No NFO file found to refresh! {}", (Object)episode.getTitle());
        }
        VideoLibrary.RefreshEpisode call = new VideoLibrary.RefreshEpisode(kodiID, false);
        this.sendWoResponse(call);
    }

    public void readWatchedState(Movie movie) {
        Integer kodiID = this.moviemappings.get(movie.getDbId());
        if (kodiID != null) {
            VideoLibrary.GetMovieDetails call = new VideoLibrary.GetMovieDetails(kodiID, "playcount", "lastplayed");
            this.send(call);
            if (call.getResult() != null && ((VideoModel.MovieDetail)call.getResult()).playcount != null) {
                movie.setPlaycount(((VideoModel.MovieDetail)call.getResult()).playcount);
                if (((VideoModel.MovieDetail)call.getResult()).playcount > 0) {
                    movie.setWatched(true);
                    try {
                        movie.setLastWatched(DateUtils.parseDate(((VideoModel.MovieDetail)call.getResult()).lastplayed));
                    }
                    catch (Exception e) {
                        movie.setLastWatched(new Date());
                    }
                } else {
                    movie.setWatched(false);
                    movie.setLastWatched(null);
                }
                movie.writeNFO();
                movie.saveToDb();
            }
        } else {
            LOGGER.warn("Kodi RPC: Unable get playcount - could not map movie '{}' to Kodi library!", (Object)movie.getTitle());
        }
    }

    public void readWatchedState(TvShowEpisode episode) {
        Integer kodiID = this.getEpisodeId(episode);
        VideoLibrary.GetEpisodeDetails call = new VideoLibrary.GetEpisodeDetails(kodiID, "playcount", "lastplayed");
        this.send(call);
        if (call.getResult() != null && ((VideoModel.EpisodeDetail)call.getResult()).playcount != null) {
            episode.setPlaycount(((VideoModel.EpisodeDetail)call.getResult()).playcount);
            if (((VideoModel.EpisodeDetail)call.getResult()).playcount > 0) {
                episode.setWatched(true);
                try {
                    episode.setLastWatched(DateUtils.parseDate(((VideoModel.EpisodeDetail)call.getResult()).lastplayed));
                }
                catch (Exception e) {
                    episode.setLastWatched(new Date());
                }
            } else {
                episode.setWatched(false);
                episode.setLastWatched(null);
            }
            episode.writeNFO();
            episode.saveToDb();
        } else {
            LOGGER.warn("Kodi RPC: Unable get playcount - could not map episode '{}' to Kodi library!", (Object)episode.getTitle());
        }
    }

    public Integer getEpisodeId(TvShowEpisode episode) {
        Integer kodiShowId = this.tvshowmappings.get(episode.getTvShowDbId());
        if (kodiShowId == null) {
            return null;
        }
        Integer kodiEpId = this.episodemappings.get(episode.getDbId());
        if (kodiEpId == null) {
            this.getAndSetTvShowEpisodeMappings(episode.getTvShow(), kodiShowId);
            kodiEpId = this.episodemappings.get(episode.getDbId());
        }
        return kodiEpId;
    }

    protected synchronized void getAndSetTvShowEpisodeMappings(TvShow tmmShow, Integer kodiShowId) {
        VideoLibrary.GetEpisodes episodeCall = new VideoLibrary.GetEpisodes(kodiShowId, "file", "season", "episode");
        this.send(episodeCall);
        if (episodeCall.getResults() != null && !episodeCall.getResults().isEmpty()) {
            LOGGER.debug("KODI {} episodes", (Object)episodeCall.getResults().size());
            HashMap<CallSite, UUID> tmmEpisodes = new HashMap<CallSite, UUID>();
            for (TvShowEpisode ep : tmmShow.getEpisodes()) {
                tmmEpisodes.put((CallSite)((Object)("S" + ep.getSeason() + "_E" + ep.getEpisode())), ep.getDbId());
            }
            int mappedCnt = 0;
            for (VideoModel.EpisodeDetail kodiEp : episodeCall.getResults()) {
                UUID uuid;
                if (kodiEp.file == null || kodiEp.file.isEmpty() || kodiEp.episodeid <= 0 || (uuid = (UUID)tmmEpisodes.get("S" + kodiEp.season + "_E" + kodiEp.episode)) == null) continue;
                ++mappedCnt;
                this.episodemappings.put(uuid, kodiEp.episodeid);
            }
            LOGGER.debug("mapped {} episodes for {}", (Object)mappedCnt, (Object)tmmShow.getTitle());
        }
    }

    public void cleanAudioLibrary() {
        AudioLibrary.Clean call = new AudioLibrary.Clean(true);
        this.sendWoResponse(call);
    }

    public void scanAudioLibrary() {
        AudioLibrary.Scan call = new AudioLibrary.Scan(null);
        this.sendWoResponse(call);
    }

    public void scanAudioLibrary(String dir) {
        AudioLibrary.Scan call = new AudioLibrary.Scan(dir);
        this.sendWoResponse(call);
    }

    public List<String> getAudioDataSources() {
        return this.audiodatasources;
    }

    private void getAndSetAudioDataSources() {
        Files.GetSources call = new Files.GetSources("music");
        this.send(call);
        if (call.getResults() != null && !call.getResults().isEmpty()) {
            this.audiodatasources.clear();
            try {
                for (ListModel.SourceItem res : call.getResults()) {
                    this.audiodatasources.add(res.file);
                }
            }
            catch (Exception e) {
                LOGGER.debug("could not process Kodi RPC response - '{}'", (Object)e.getMessage());
            }
        }
    }

    public String getKodiVersion() {
        Application.GetProperties call = new Application.GetProperties("version");
        this.send(call);
        try {
            ApplicationModel.PropertyValue res = (ApplicationModel.PropertyValue)call.getResult();
            int maj = res.version.major;
            int min = res.version.minor;
            return maj + "." + min;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void quitApplication() {
        Application.Quit call = new Application.Quit();
        this.sendWoResponse(call);
    }

    public void muteApplication() {
        Application.GetProperties props = new Application.GetProperties("muted");
        this.send(props);
        if (props.getResults() != null && !props.getResults().isEmpty()) {
            Application.SetMute call = new Application.SetMute(new GlobalModel.Toggle(((ApplicationModel.PropertyValue)props.getResult()).muted == false));
            this.sendWoResponse(call);
        }
    }

    public void setVolume(int vol) {
        Application.SetVolume call = new Application.SetVolume(vol);
        this.sendWoResponse(call);
    }

    public void SystemEjectOpticalDrive() {
        System.EjectOpticalDrive call = new System.EjectOpticalDrive();
        this.sendWoResponse(call);
    }

    public void SystemHibernate() {
        System.EjectOpticalDrive call = new System.EjectOpticalDrive();
        this.sendWoResponse(call);
    }

    public void SystemShutdown() {
        System.Shutdown call = new System.Shutdown();
        this.sendWoResponse(call);
    }

    public void SystemReboot() {
        System.Reboot call = new System.Reboot();
        this.sendWoResponse(call);
    }

    public void SystemSuspend() {
        System.Suspend call = new System.Suspend();
        this.sendWoResponse(call);
    }

    public void send(AbstractCall<?> call) {
        if (!this.isConnected()) {
            LOGGER.warn("Kodi RPC: Cannot send RPC call - not connected");
            return;
        }
        try {
            call.setResponse((JsonNode)JsonApiRequest.execute(this.connectionManager.getHostConfig(), call.getRequest()));
        }
        catch (ApiException e) {
            LOGGER.error("Kodi RPC: Error calling Kodi - '{}'", (Object)e.getMessage());
        }
    }

    public void sendWoResponse(AbstractCall<?> call) {
        if (!this.isConnected()) {
            LOGGER.warn("Kodi RPC: Cannot send RPC call - not connected");
            return;
        }
        try {
            JsonApiRequest.execute(this.connectionManager.getHostConfig(), call.getRequest());
        }
        catch (ApiException e) {
            LOGGER.error("Kodi RPC: Error calling Kodi - '{}'", (Object)e.getMessage());
        }
    }

    public void connect(HostConfig config) throws Exception {
        if (this.isConnected()) {
            this.connectionManager.disconnect();
        }
        new Thread(() -> {
            try {
                LOGGER.info("Kodi RPC: Connecting to {}...", (Object)config.getAddress());
                this.connectionManager.connect(config);
                if (this.isConnected()) {
                    this.kodiVersion = this.getKodiVersion();
                    this.getAndSetVideoDataSources();
                    this.getAndSetAudioDataSources();
                    this.getAndSetMovieMappings();
                    this.getAndSetTvShowMappings();
                }
            }
            catch (Exception e) {
                LOGGER.error("Kodi RPC: Error connecting to Kodi - '{}'", (Throwable)e);
            }
        }).start();
    }

    public void connect() {
        Settings s = Settings.getInstance();
        if (s.getKodiHost().isEmpty()) {
            return;
        }
        try {
            this.connect(new HostConfig(s.getKodiHost(), s.getKodiHttpPort(), s.getKodiTcpPort(), s.getKodiUsername(), s.getKodiPassword()));
        }
        catch (Exception cex) {
            LOGGER.error("Kodi RPC: Error connecting to Kodi instance - '{}'", (Object)cex.getMessage());
            MessageManager.getInstance().pushMessage(new Message(Message.MessageLevel.ERROR, "KodiRPC", "Could not connect to Kodi: " + cex.getMessage()));
        }
    }

    public void disconnect() {
        this.connectionManager.disconnect();
        this.kodiVersion = "";
    }

    public void updateMovieMappings() {
        if (this.isConnected()) {
            this.getAndSetMovieMappings();
        }
    }

    public void updateTvShowMappings() {
        if (this.isConnected()) {
            this.getAndSetTvShowMappings();
        }
    }

    public List<VideoModel.MovieDetail> getAllMoviesSYNC() {
        VideoLibrary.GetMovies call = new VideoLibrary.GetMovies("file");
        this.send(call);
        return call.getResults();
    }

    public void getAllMoviesASYNC() {
        VideoLibrary.GetMovies vl = new VideoLibrary.GetMovies("file");
        this.connectionManager.call(vl, new ApiCallback<VideoModel.MovieDetail>(){

            @Override
            public void onResponse(AbstractCall<VideoModel.MovieDetail> call) {
                LOGGER.info("Kodi RPC: found " + call.getResults().size() + " movies");
                for (VideoModel.MovieDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            @Override
            public void onError(int code, String message, String hint) {
                LOGGER.error("Kodi RPC: Error {} - '{}'", (Object)code, (Object)message);
            }
        });
    }

    public void triggerReload(Movie movie) {
        VideoLibrary.GetMovies vl = new VideoLibrary.GetMovies("file");
        this.connectionManager.call(vl, new ApiCallback<VideoModel.MovieDetail>(){

            @Override
            public void onResponse(AbstractCall<VideoModel.MovieDetail> call) {
                LOGGER.info("Kodi RPC: found " + call.getResults().size() + " movies");
                for (VideoModel.MovieDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            @Override
            public void onError(int code, String message, String hint) {
                LOGGER.error("Kodi RPC: Error {} - '{}'", (Object)code, (Object)message);
            }
        });
    }

    public void getAllTvShows() {
        VideoLibrary.GetTVShows vl = new VideoLibrary.GetTVShows(new String[0]);
        this.connectionManager.call(vl, new ApiCallback<VideoModel.TVShowDetail>(){

            @Override
            public void onResponse(AbstractCall<VideoModel.TVShowDetail> call) {
                LOGGER.info("Kodi RPC: found " + call.getResults().size() + " shows");
                for (VideoModel.TVShowDetail res : call.getResults()) {
                    LOGGER.debug(res.toString());
                }
            }

            @Override
            public void onError(int code, String message, String hint) {
                LOGGER.error("Kodi RPC: Error {} - '{}'", (Object)code, (Object)message);
            }
        });
    }
}

