/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.jsonrpc.api.model;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.DoubleNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.tinymediamanager.jsonrpc.api.AbstractModel;

public final class SettingModel {

    public static interface Type {
        public static final String BOOLEAN = "boolean";
        public static final String INTEGER = "integer";
        public static final String NUMBER = "number";
        public static final String STRING = "string";
        public static final String ACTION = "action";
        public static final String LIST = "list";
        public static final String PATH = "path";
        public static final String ADDON = "addon";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("boolean", "integer", "number", "string", "action", "list", "path", "addon"));
    }

    public static interface Level {
        public static final String BASIC = "basic";
        public static final String STANDARD = "standard";
        public static final String ADVANCED = "advanced";
        public static final String EXPERT = "expert";
        public static final Set<String> values = new HashSet<String>(Arrays.asList("basic", "standard", "advanced", "expert"));
    }

    public static class ValueExtended
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Value.Extended";
        public final Boolean booleanArg;
        public final Integer integerArg;
        public final Double numberArg;
        public final String stringArg;
        public final List<Value> valueList;

        public ValueExtended(Boolean bl) {
            this.booleanArg = bl;
            this.integerArg = null;
            this.numberArg = null;
            this.stringArg = null;
            this.valueList = null;
        }

        public ValueExtended(Integer n) {
            this.integerArg = n;
            this.booleanArg = null;
            this.numberArg = null;
            this.stringArg = null;
            this.valueList = null;
        }

        public ValueExtended(Double d) {
            this.numberArg = d;
            this.booleanArg = null;
            this.integerArg = null;
            this.stringArg = null;
            this.valueList = null;
        }

        public ValueExtended(String string) {
            this.stringArg = string;
            this.booleanArg = null;
            this.integerArg = null;
            this.numberArg = null;
            this.valueList = null;
        }

        public ValueExtended(List<Value> list) {
            this.valueList = list;
            this.booleanArg = null;
            this.integerArg = null;
            this.numberArg = null;
            this.stringArg = null;
        }

        public ValueExtended(JsonNode jsonNode) {
            if (jsonNode.isBoolean()) {
                this.booleanArg = jsonNode.asBoolean();
                this.integerArg = null;
                this.numberArg = null;
                this.stringArg = null;
                this.valueList = null;
            } else if (jsonNode.isInt()) {
                this.integerArg = jsonNode.asInt();
                this.booleanArg = null;
                this.numberArg = null;
                this.stringArg = null;
                this.valueList = null;
            } else if (jsonNode.isDouble()) {
                this.numberArg = jsonNode.asDouble();
                this.booleanArg = null;
                this.integerArg = null;
                this.stringArg = null;
                this.valueList = null;
            } else if (jsonNode.isTextual()) {
                this.stringArg = jsonNode.asText();
                this.booleanArg = null;
                this.integerArg = null;
                this.numberArg = null;
                this.valueList = null;
            } else if (jsonNode.isObject()) {
                this.booleanArg = null;
                this.integerArg = null;
                this.numberArg = null;
                this.stringArg = null;
                this.valueList = null;
            } else {
                throw new RuntimeException("Weird type for \"Value.Extended\", I'm confused!");
            }
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.booleanArg != null) {
                return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
            }
            if (this.integerArg != null) {
                return new IntNode(this.integerArg.intValue());
            }
            if (this.numberArg != null) {
                return new DoubleNode(this.numberArg.doubleValue());
            }
            if (this.stringArg != null) {
                return new TextNode(this.stringArg);
            }
            if (this.valueList != null) {
                ArrayNode arrayNode = OM.createArrayNode();
                for (Value value : this.valueList) {
                    arrayNode.add(value.toString());
                }
                return arrayNode;
            }
            return null;
        }

        static List<ValueExtended> getSettingModelValueExtendedList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ValueExtended> arrayList = new ArrayList<ValueExtended>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ValueExtended(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ValueExtended>(0);
        }
    }

    public static class Value
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Value";
        public final Boolean booleanArg;
        public final Integer integerArg;
        public final Double numberArg;
        public final String stringArg;

        public Value(Boolean bl) {
            this.booleanArg = bl;
            this.integerArg = null;
            this.numberArg = null;
            this.stringArg = null;
        }

        public Value(Integer n) {
            this.integerArg = n;
            this.booleanArg = null;
            this.numberArg = null;
            this.stringArg = null;
        }

        public Value(Double d) {
            this.numberArg = d;
            this.booleanArg = null;
            this.integerArg = null;
            this.stringArg = null;
        }

        public Value(String string) {
            this.stringArg = string;
            this.booleanArg = null;
            this.integerArg = null;
            this.numberArg = null;
        }

        public Value(JsonNode jsonNode) {
            if (jsonNode.isBoolean()) {
                this.booleanArg = jsonNode.asBoolean();
                this.integerArg = null;
                this.numberArg = null;
                this.stringArg = null;
            } else if (jsonNode.isInt()) {
                this.integerArg = jsonNode.asInt();
                this.booleanArg = null;
                this.numberArg = null;
                this.stringArg = null;
            } else if (jsonNode.isDouble()) {
                this.numberArg = jsonNode.asDouble();
                this.booleanArg = null;
                this.integerArg = null;
                this.stringArg = null;
            } else if (jsonNode.isTextual()) {
                this.stringArg = jsonNode.asText();
                this.booleanArg = null;
                this.integerArg = null;
                this.numberArg = null;
            } else {
                throw new RuntimeException("Weird type for \"Value\", I'm confused!");
            }
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.booleanArg != null) {
                return this.booleanArg != false ? BooleanNode.TRUE : BooleanNode.FALSE;
            }
            if (this.integerArg != null) {
                return new IntNode(this.integerArg.intValue());
            }
            if (this.numberArg != null) {
                return new DoubleNode(this.numberArg.doubleValue());
            }
            if (this.stringArg != null) {
                return new TextNode(this.stringArg);
            }
            return null;
        }

        static List<Value> getSettingModelValueList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<Value> arrayList = new ArrayList<Value>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new Value(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<Value>(0);
        }
    }

    public static class SettingStringDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingString";
        public static final String ALLOWEMPTY = "allowempty";
        public static final String DEFAULT = "default";
        public static final String OPTIONS = "options";
        public static final String VALUE = "value";
        public final Boolean allowempty;
        public final String defaults;
        public final List<Option> options;
        public final String value;

        public SettingStringDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.allowempty = jsonNode.get(ALLOWEMPTY).asBoolean();
            this.defaults = jsonNode.get(DEFAULT).asText();
            this.options = Option.getSettingModelOptionList(jsonNode, OPTIONS);
            this.value = jsonNode.get(VALUE).asText();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(ALLOWEMPTY, this.allowempty);
            objectNode.put(DEFAULT, this.defaults);
            ArrayNode arrayNode = OM.createArrayNode();
            for (Option option : this.options) {
                arrayNode.add(option.toJsonNode());
            }
            objectNode.put(OPTIONS, (JsonNode)arrayNode);
            objectNode.put(VALUE, this.value);
            return objectNode;
        }

        public static class Option
        extends AbstractModel {
            public static final String LABEL = "label";
            public static final String VALUE = "value";
            public final String label;
            public final String value;

            public Option(String string, String string2) {
                this.label = string;
                this.value = string2;
            }

            public Option(JsonNode jsonNode) {
                this.label = jsonNode.get(LABEL).asText();
                this.value = jsonNode.get("value").asText();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(LABEL, this.label);
                objectNode.put("value", this.value);
                return objectNode;
            }

            static List<Option> getSettingModelOptionList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Option> arrayList = new ArrayList<Option>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Option(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Option>(0);
            }
        }
    }

    public static class SettingPathDetail
    extends SettingStringDetail {
        public static final String API_TYPE = "Setting.Details.SettingPath";
        public static final String SOURCES = "sources";
        public static final String WRITABLE = "writable";
        public final List<String> sources;
        public final Boolean writable;

        public SettingPathDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.sources = SettingPathDetail.getStringArray(jsonNode, SOURCES);
            this.writable = jsonNode.get(WRITABLE).asBoolean();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (String string : this.sources) {
                arrayNode.add(string);
            }
            objectNode.put(SOURCES, (JsonNode)arrayNode);
            objectNode.put(WRITABLE, this.writable);
            return objectNode;
        }

        static List<SettingPathDetail> getSettingModelSettingPathDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SettingPathDetail> arrayList = new ArrayList<SettingPathDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SettingPathDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SettingPathDetail>(0);
        }
    }

    public static class SettingNumberDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingNumber";
        public static final String DEFAULT = "default";
        public static final String MAXIMUM = "maximum";
        public static final String MINIMUM = "minimum";
        public static final String STEP = "step";
        public static final String VALUE = "value";
        public final Double defaultd;
        public final Double maximum;
        public final Double minimum;
        public final Double step;
        public final Double value;

        public SettingNumberDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.defaultd = jsonNode.get(DEFAULT).asDouble();
            this.maximum = jsonNode.get(MAXIMUM).asDouble();
            this.minimum = jsonNode.get(MINIMUM).asDouble();
            this.step = jsonNode.get(STEP).asDouble();
            this.value = jsonNode.get(VALUE).asDouble();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(DEFAULT, this.defaultd);
            objectNode.put(MAXIMUM, this.maximum);
            objectNode.put(MINIMUM, this.minimum);
            objectNode.put(STEP, this.step);
            objectNode.put(VALUE, this.value);
            return objectNode;
        }

        static List<SettingNumberDetail> getSettingModelSettingNumberDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SettingNumberDetail> arrayList = new ArrayList<SettingNumberDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SettingNumberDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SettingNumberDetail>(0);
        }
    }

    public static class SettingListDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingList";
        public static final String DEFAULT = "default";
        public static final String DEFINITION = "definition";
        public static final String DELIMITER = "delimiter";
        public static final String ELEMENTTYPE = "elementtype";
        public static final String MAXIMUMITEMS = "maximumitems";
        public static final String MINIMUMITEMS = "minimumitems";
        public static final String VALUE = "value";
        public final List<Value> defaultl;
        public final SettingDetail definition;
        public final String delimiter;
        public final String elementtype;
        public final Integer maximumitems;
        public final Integer minimumitems;
        public final List<Value> value;

        public SettingListDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.defaultl = Value.getSettingModelValueList(jsonNode, DEFAULT);
            this.definition = jsonNode.has(DEFINITION) ? new SettingDetail(jsonNode.get(DEFINITION)) : null;
            this.delimiter = jsonNode.get(DELIMITER).asText();
            this.elementtype = SettingListDetail.parseString(jsonNode, ELEMENTTYPE);
            this.maximumitems = SettingListDetail.parseInt(jsonNode, MAXIMUMITEMS);
            this.minimumitems = SettingListDetail.parseInt(jsonNode, MINIMUMITEMS);
            this.value = Value.getSettingModelValueList(jsonNode, VALUE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (Value object : this.defaultl) {
                arrayNode.add(object.toJsonNode());
            }
            objectNode.put(DEFAULT, (JsonNode)arrayNode);
            objectNode.put(DEFINITION, this.definition == null ? null : this.definition.toJsonNode());
            objectNode.put(DELIMITER, this.delimiter);
            objectNode.put(ELEMENTTYPE, this.elementtype);
            objectNode.put(MAXIMUMITEMS, this.maximumitems);
            objectNode.put(MINIMUMITEMS, this.minimumitems);
            ArrayNode arrayNode2 = OM.createArrayNode();
            for (Value value : this.value) {
                arrayNode2.add(value.toJsonNode());
            }
            objectNode.put(VALUE, (JsonNode)arrayNode2);
            return objectNode;
        }

        static List<SettingListDetail> getSettingModelSettingListDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SettingListDetail> arrayList = new ArrayList<SettingListDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SettingListDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SettingListDetail>(0);
        }

        public static interface Elementtype {
            public static final String BOOLEAN = "boolean";
            public static final String INTEGER = "integer";
            public static final String NUMBER = "number";
            public static final String STRING = "string";
            public static final String ACTION = "action";
            public static final String LIST = "list";
            public static final String PATH = "path";
            public static final String ADDON = "addon";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("boolean", "integer", "number", "string", "action", "list", "path", "addon"));
        }
    }

    public static class SettingIntDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingInt";
        public static final String DEFAULT = "default";
        public static final String MAXIMUM = "maximum";
        public static final String MINIMUM = "minimum";
        public static final String OPTIONS = "options";
        public static final String STEP = "step";
        public static final String VALUE = "value";
        public final Integer defaulti;
        public final Integer maximum;
        public final Integer minimum;
        public final List<Option> options;
        public final Integer step;
        public final Integer value;

        public SettingIntDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.defaulti = jsonNode.get(DEFAULT).asInt();
            this.maximum = SettingIntDetail.parseInt(jsonNode, MAXIMUM);
            this.minimum = SettingIntDetail.parseInt(jsonNode, MINIMUM);
            this.options = Option.getSettingModelOptionList(jsonNode, OPTIONS);
            this.step = SettingIntDetail.parseInt(jsonNode, STEP);
            this.value = jsonNode.get(VALUE).asInt();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(DEFAULT, this.defaulti);
            objectNode.put(MAXIMUM, this.maximum);
            objectNode.put(MINIMUM, this.minimum);
            ArrayNode arrayNode = OM.createArrayNode();
            for (Option option : this.options) {
                arrayNode.add(option.toJsonNode());
            }
            objectNode.put(OPTIONS, (JsonNode)arrayNode);
            objectNode.put(STEP, this.step);
            objectNode.put(VALUE, this.value);
            return objectNode;
        }

        static List<SettingIntDetail> getSettingModelSettingIntDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SettingIntDetail> arrayList = new ArrayList<SettingIntDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SettingIntDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SettingIntDetail>(0);
        }

        public static class Option
        extends AbstractModel {
            public static final String LABEL = "label";
            public static final String VALUE = "value";
            public final String label;
            public final Integer value;

            public Option(String string, Integer n) {
                this.label = string;
                this.value = n;
            }

            public Option(JsonNode jsonNode) {
                this.label = jsonNode.get(LABEL).asText();
                this.value = jsonNode.get("value").asInt();
            }

            @Override
            public JsonNode toJsonNode() {
                ObjectNode objectNode = OM.createObjectNode();
                objectNode.put(LABEL, this.label);
                objectNode.put("value", this.value);
                return objectNode;
            }

            static List<Option> getSettingModelOptionList(JsonNode jsonNode, String string) {
                if (jsonNode.has(string)) {
                    ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                    ArrayList<Option> arrayList = new ArrayList<Option>(arrayNode.size());
                    for (int i = 0; i < arrayNode.size(); ++i) {
                        arrayList.add(new Option(arrayNode.get(i)));
                    }
                    return arrayList;
                }
                return new ArrayList<Option>(0);
            }
        }
    }

    public static class SettingBoolDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingBool";
        public static final String DEFAULT = "default";
        public static final String VALUE = "value";
        public final Boolean defaultb;
        public final Boolean value;

        public SettingBoolDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.defaultb = jsonNode.get(DEFAULT).asBoolean();
            this.value = jsonNode.get(VALUE).asBoolean();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(DEFAULT, this.defaultb);
            objectNode.put(VALUE, this.value);
            return objectNode;
        }

        static List<SettingBoolDetail> getSettingModelSettingBoolDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SettingBoolDetail> arrayList = new ArrayList<SettingBoolDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SettingBoolDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SettingBoolDetail>(0);
        }
    }

    public static class SettingBaseDetail
    extends BaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingBase";
        public static final String CONTROL = "control";
        public static final String ENABLED = "enabled";
        public static final String LEVEL = "level";
        public static final String PARENT = "parent";
        public static final String TYPE = "type";
        public final ControlDetail control;
        public final Boolean enabled;
        public final String level;
        public final String parent;
        public final String type;

        public SettingBaseDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.control = jsonNode.has(CONTROL) ? new ControlDetail(jsonNode.get(CONTROL)) : null;
            this.enabled = jsonNode.get(ENABLED).asBoolean();
            this.level = SettingBaseDetail.parseString(jsonNode, LEVEL);
            this.parent = SettingBaseDetail.parseString(jsonNode, PARENT);
            this.type = SettingBaseDetail.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(CONTROL, this.control == null ? null : this.control.toJsonNode());
            objectNode.put(ENABLED, this.enabled);
            objectNode.put(LEVEL, this.level);
            objectNode.put(PARENT, this.parent);
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<SettingBaseDetail> getSettingModelSettingBaseDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SettingBaseDetail> arrayList = new ArrayList<SettingBaseDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SettingBaseDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SettingBaseDetail>(0);
        }

        public static interface Type {
            public static final String BOOLEAN = "boolean";
            public static final String INTEGER = "integer";
            public static final String NUMBER = "number";
            public static final String STRING = "string";
            public static final String ACTION = "action";
            public static final String LIST = "list";
            public static final String PATH = "path";
            public static final String ADDON = "addon";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("boolean", "integer", "number", "string", "action", "list", "path", "addon"));
        }

        public static interface Level {
            public static final String BASIC = "basic";
            public static final String STANDARD = "standard";
            public static final String ADVANCED = "advanced";
            public static final String EXPERT = "expert";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("basic", "standard", "advanced", "expert"));
        }
    }

    public static class SettingAddonDetail
    extends SettingStringDetail {
        public static final String API_TYPE = "Setting.Details.SettingAddon";
        public static final String ADDONTYPE = "addontype";
        public final String addontype;

        public SettingAddonDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.addontype = SettingAddonDetail.parseString(jsonNode, ADDONTYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(ADDONTYPE, this.addontype);
            return objectNode;
        }

        static List<SettingAddonDetail> getSettingModelSettingAddonDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SettingAddonDetail> arrayList = new ArrayList<SettingAddonDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SettingAddonDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SettingAddonDetail>(0);
        }

        public static interface Addontype {
            public static final String UNKNOWN = "unknown";
            public static final String XBMC_PLAYER_MUSICVIZ = "xbmc.player.musicviz";
            public static final String XBMC_GUI_SKIN = "xbmc.gui.skin";
            public static final String XBMC_PVRCLIENT = "xbmc.pvrclient";
            public static final String KODI_ADSP = "kodi.adsp";
            public static final String XBMC_PYTHON_SCRIPT = "xbmc.python.script";
            public static final String XBMC_PYTHON_WEATHER = "xbmc.python.weather";
            public static final String XBMC_SUBTITLE_MODULE = "xbmc.subtitle.module";
            public static final String XBMC_PYTHON_LYRICS = "xbmc.python.lyrics";
            public static final String XBMC_METADATA_SCRAPER_ALBUMS = "xbmc.metadata.scraper.albums";
            public static final String XBMC_METADATA_SCRAPER_ARTISTS = "xbmc.metadata.scraper.artists";
            public static final String XBMC_METADATA_SCRAPER_MOVIES = "xbmc.metadata.scraper.movies";
            public static final String XBMC_METADATA_SCRAPER_MUSICVIDEOS = "xbmc.metadata.scraper.musicvideos";
            public static final String XBMC_METADATA_SCRAPER_TVSHOWS = "xbmc.metadata.scraper.tvshows";
            public static final String XBMC_UI_SCREENSAVER = "xbmc.ui.screensaver";
            public static final String XBMC_PYTHON_PLUGINSOURCE = "xbmc.python.pluginsource";
            public static final String XBMC_ADDON_REPOSITORY = "xbmc.addon.repository";
            public static final String XBMC_WEBINTERFACE = "xbmc.webinterface";
            public static final String XBMC_SERVICE = "xbmc.service";
            public static final String XBMC_AUDIOENCODER = "xbmc.audioencoder";
            public static final String KODI_CONTEXT_ITEM = "kodi.context.item";
            public static final String KODI_AUDIODECODER = "kodi.audiodecoder";
            public static final String KODI_RESOURCE_IMAGES = "kodi.resource.images";
            public static final String KODI_RESOURCE_LANGUAGE = "kodi.resource.language";
            public static final String KODI_RESOURCE_UISOUNDS = "kodi.resource.uisounds";
            public static final String XBMC_ADDON_VIDEO = "xbmc.addon.video";
            public static final String XBMC_ADDON_AUDIO = "xbmc.addon.audio";
            public static final String XBMC_ADDON_IMAGE = "xbmc.addon.image";
            public static final String XBMC_ADDON_EXECUTABLE = "xbmc.addon.executable";
            public static final String VISUALIZATION_LIBRARY = "visualization-library";
            public static final String XBMC_METADATA_SCRAPER_LIBRARY = "xbmc.metadata.scraper.library";
            public static final String XBMC_PYTHON_LIBRARY = "xbmc.python.library";
            public static final String XBMC_PYTHON_MODULE = "xbmc.python.module";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("unknown", "xbmc.player.musicviz", "xbmc.gui.skin", "xbmc.pvrclient", "kodi.adsp", "xbmc.python.script", "xbmc.python.weather", "xbmc.subtitle.module", "xbmc.python.lyrics", "xbmc.metadata.scraper.albums", "xbmc.metadata.scraper.artists", "xbmc.metadata.scraper.movies", "xbmc.metadata.scraper.musicvideos", "xbmc.metadata.scraper.tvshows", "xbmc.ui.screensaver", "xbmc.python.pluginsource", "xbmc.addon.repository", "xbmc.webinterface", "xbmc.service", "xbmc.audioencoder", "kodi.context.item", "kodi.audiodecoder", "kodi.resource.images", "kodi.resource.language", "kodi.resource.uisounds", "xbmc.addon.video", "xbmc.addon.audio", "xbmc.addon.image", "xbmc.addon.executable", "visualization-library", "xbmc.metadata.scraper.library", "xbmc.python.library", "xbmc.python.module"));
        }
    }

    public static class SettingActionDetail
    extends SettingBaseDetail {
        public static final String API_TYPE = "Setting.Details.SettingAction";

        public SettingActionDetail(JsonNode jsonNode) {
            super(jsonNode);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            return objectNode;
        }

        static List<SettingActionDetail> getSettingModelSettingActionDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SettingActionDetail> arrayList = new ArrayList<SettingActionDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SettingActionDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SettingActionDetail>(0);
        }
    }

    public static class SettingDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.Setting";
        public final SettingActionDetail detailsSettingAction;
        public final SettingAddonDetail detailsSettingAddon;
        public final SettingBoolDetail detailsSettingBool;
        public final SettingIntDetail detailsSettingInt;
        public final SettingListDetail detailsSettingList;
        public final SettingNumberDetail detailsSettingNumber;
        public final SettingPathDetail detailsSettingPath;
        public final SettingStringDetail detailsSettingString;

        public SettingDetail(SettingActionDetail settingActionDetail) {
            this.detailsSettingAction = settingActionDetail;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingAddonDetail settingAddonDetail) {
            this.detailsSettingAddon = settingAddonDetail;
            this.detailsSettingAction = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingBoolDetail settingBoolDetail) {
            this.detailsSettingBool = settingBoolDetail;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingIntDetail settingIntDetail) {
            this.detailsSettingInt = settingIntDetail;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingListDetail settingListDetail) {
            this.detailsSettingList = settingListDetail;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingNumberDetail settingNumberDetail) {
            this.detailsSettingNumber = settingNumberDetail;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingPath = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingPathDetail settingPathDetail) {
            this.detailsSettingPath = settingPathDetail;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingString = null;
        }

        public SettingDetail(SettingStringDetail settingStringDetail) {
            this.detailsSettingString = settingStringDetail;
            this.detailsSettingAction = null;
            this.detailsSettingAddon = null;
            this.detailsSettingBool = null;
            this.detailsSettingInt = null;
            this.detailsSettingList = null;
            this.detailsSettingNumber = null;
            this.detailsSettingPath = null;
        }

        public SettingDetail(JsonNode jsonNode) {
            if (jsonNode.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (jsonNode.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (jsonNode.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (jsonNode.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (jsonNode.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (jsonNode.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (jsonNode.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else if (jsonNode.isObject()) {
                this.detailsSettingAction = null;
                this.detailsSettingAddon = null;
                this.detailsSettingBool = null;
                this.detailsSettingInt = null;
                this.detailsSettingList = null;
                this.detailsSettingNumber = null;
                this.detailsSettingPath = null;
                this.detailsSettingString = null;
            } else {
                throw new RuntimeException("Weird type for \"Details.Setting\", I'm confused!");
            }
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.detailsSettingAction != null) {
                return this.detailsSettingAction.toJsonNode();
            }
            if (this.detailsSettingAddon != null) {
                return this.detailsSettingAddon.toJsonNode();
            }
            if (this.detailsSettingBool != null) {
                return this.detailsSettingBool.toJsonNode();
            }
            if (this.detailsSettingInt != null) {
                return this.detailsSettingInt.toJsonNode();
            }
            if (this.detailsSettingList != null) {
                return this.detailsSettingList.toJsonNode();
            }
            if (this.detailsSettingNumber != null) {
                return this.detailsSettingNumber.toJsonNode();
            }
            if (this.detailsSettingPath != null) {
                return this.detailsSettingPath.toJsonNode();
            }
            if (this.detailsSettingString != null) {
                return this.detailsSettingString.toJsonNode();
            }
            return null;
        }

        static List<SettingDetail> getSettingModelSettingDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SettingDetail> arrayList = new ArrayList<SettingDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SettingDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SettingDetail>(0);
        }
    }

    public static class SectionDetail
    extends BaseDetail {
        public static final String API_TYPE = "Setting.Details.Section";
        public static final String CATEGORIES = "categories";
        public final List<CategoryDetail> categories;

        public SectionDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.categories = CategoryDetail.getSettingModelCategoryDetailList(jsonNode, CATEGORIES);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (CategoryDetail categoryDetail : this.categories) {
                arrayNode.add(categoryDetail.toJsonNode());
            }
            objectNode.put(CATEGORIES, (JsonNode)arrayNode);
            return objectNode;
        }

        static List<SectionDetail> getSettingModelSectionDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<SectionDetail> arrayList = new ArrayList<SectionDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new SectionDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<SectionDetail>(0);
        }
    }

    public static class GroupDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.Group";
        public static final String ID = "id";
        public static final String SETTINGS = "settings";
        public final String id;
        public final List<SettingDetail> settings;

        public GroupDetail(String string, List<SettingDetail> list) {
            this.id = string;
            this.settings = list;
        }

        public GroupDetail(JsonNode jsonNode) {
            this.id = jsonNode.get(ID).asText();
            this.settings = SettingDetail.getSettingModelSettingDetailList(jsonNode, SETTINGS);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(ID, this.id);
            ArrayNode arrayNode = OM.createArrayNode();
            for (SettingDetail settingDetail : this.settings) {
                arrayNode.add(settingDetail.toJsonNode());
            }
            objectNode.put(SETTINGS, (JsonNode)arrayNode);
            return objectNode;
        }

        static List<GroupDetail> getSettingModelGroupDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<GroupDetail> arrayList = new ArrayList<GroupDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new GroupDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<GroupDetail>(0);
        }
    }

    public static class ControlSpinnerDetail
    extends ControlBaseDetail {
        public static final String API_TYPE = "Setting.Details.ControlSpinner";
        public static final String FORMATLABEL = "formatlabel";
        public static final String MINIMUMLABEL = "minimumlabel";
        public static final String TYPE = "type";
        public final String formatlabel;
        public final String minimumlabel;
        public final String type;

        public ControlSpinnerDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.formatlabel = ControlSpinnerDetail.parseString(jsonNode, FORMATLABEL);
            this.minimumlabel = ControlSpinnerDetail.parseString(jsonNode, MINIMUMLABEL);
            this.type = ControlSpinnerDetail.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FORMATLABEL, this.formatlabel);
            objectNode.put(MINIMUMLABEL, this.minimumlabel);
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<ControlSpinnerDetail> getSettingModelControlSpinnerDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlSpinnerDetail> arrayList = new ArrayList<ControlSpinnerDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlSpinnerDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlSpinnerDetail>(0);
        }

        public static interface Type {
            public static final String SPINNER = "spinner";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("spinner"));
        }
    }

    public static class ControlSliderDetail
    extends ControlHeadingDetail {
        public static final String API_TYPE = "Setting.Details.ControlSlider";
        public static final String FORMATLABEL = "formatlabel";
        public static final String POPUP = "popup";
        public static final String TYPE = "type";
        public final String formatlabel;
        public final Boolean popup;
        public final String type;

        public ControlSliderDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.formatlabel = jsonNode.get(FORMATLABEL).asText();
            this.popup = jsonNode.get(POPUP).asBoolean();
            this.type = ControlSliderDetail.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FORMATLABEL, this.formatlabel);
            objectNode.put(POPUP, this.popup);
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<ControlSliderDetail> getSettingModelControlSliderDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlSliderDetail> arrayList = new ArrayList<ControlSliderDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlSliderDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlSliderDetail>(0);
        }

        public static interface Type {
            public static final String SLIDER = "slider";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("slider"));
        }
    }

    public static class ControlRangeDetail
    extends ControlBaseDetail {
        public static final String API_TYPE = "Setting.Details.ControlRange";
        public static final String FORMATLABEL = "formatlabel";
        public static final String FORMATVALUE = "formatvalue";
        public static final String TYPE = "type";
        public final String formatlabel;
        public final String formatvalue;
        public final String type;

        public ControlRangeDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.formatlabel = jsonNode.get(FORMATLABEL).asText();
            this.formatvalue = jsonNode.get(FORMATVALUE).asText();
            this.type = ControlRangeDetail.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FORMATLABEL, this.formatlabel);
            objectNode.put(FORMATVALUE, this.formatvalue);
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<ControlRangeDetail> getSettingModelControlRangeDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlRangeDetail> arrayList = new ArrayList<ControlRangeDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlRangeDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlRangeDetail>(0);
        }

        public static interface Type {
            public static final String RANGE = "range";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("range"));
        }
    }

    public static class ControlListDetail
    extends ControlHeadingDetail {
        public static final String API_TYPE = "Setting.Details.ControlList";
        public static final String MULTISELECT = "multiselect";
        public static final String TYPE = "type";
        public final Boolean multiselect;
        public final String type;

        public ControlListDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.multiselect = jsonNode.get(MULTISELECT).asBoolean();
            this.type = ControlListDetail.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(MULTISELECT, this.multiselect);
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<ControlListDetail> getSettingModelControlListDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlListDetail> arrayList = new ArrayList<ControlListDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlListDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlListDetail>(0);
        }

        public static interface Type {
            public static final String LIST = "list";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("list"));
        }
    }

    public static class ControlHeadingDetail
    extends ControlBaseDetail {
        public static final String API_TYPE = "Setting.Details.ControlHeading";
        public static final String HEADING = "heading";
        public final String heading;

        public ControlHeadingDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.heading = ControlHeadingDetail.parseString(jsonNode, HEADING);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(HEADING, this.heading);
            return objectNode;
        }

        static List<ControlHeadingDetail> getSettingModelControlHeadingDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlHeadingDetail> arrayList = new ArrayList<ControlHeadingDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlHeadingDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlHeadingDetail>(0);
        }
    }

    public static class ControlEditDetail
    extends ControlHeadingDetail {
        public static final String API_TYPE = "Setting.Details.ControlEdit";
        public static final String HIDDEN = "hidden";
        public static final String TYPE = "type";
        public static final String VERIFYNEWVALUE = "verifynewvalue";
        public final Boolean hidden;
        public final String type;
        public final Boolean verifynewvalue;

        public ControlEditDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.hidden = jsonNode.get(HIDDEN).asBoolean();
            this.type = ControlEditDetail.parseString(jsonNode, TYPE);
            this.verifynewvalue = jsonNode.get(VERIFYNEWVALUE).asBoolean();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(HIDDEN, this.hidden);
            objectNode.put(TYPE, this.type);
            objectNode.put(VERIFYNEWVALUE, this.verifynewvalue);
            return objectNode;
        }

        static List<ControlEditDetail> getSettingModelControlEditDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlEditDetail> arrayList = new ArrayList<ControlEditDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlEditDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlEditDetail>(0);
        }

        public static interface Type {
            public static final String EDIT = "edit";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("edit"));
        }
    }

    public static class ControlCheckmarkDetail
    extends ControlBaseDetail {
        public static final String API_TYPE = "Setting.Details.ControlCheckmark";
        public static final String FORMAT = "format";
        public static final String TYPE = "type";
        public final String format;
        public final String type;

        public ControlCheckmarkDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.format = ControlCheckmarkDetail.parseString(jsonNode, FORMAT);
            this.type = ControlCheckmarkDetail.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(FORMAT, this.format);
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<ControlCheckmarkDetail> getSettingModelControlCheckmarkDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlCheckmarkDetail> arrayList = new ArrayList<ControlCheckmarkDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlCheckmarkDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlCheckmarkDetail>(0);
        }

        public static interface Type {
            public static final String TOGGLE = "toggle";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("toggle"));
        }

        public static interface Format {
            public static final String BOOLEAN = "boolean";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("boolean"));
        }
    }

    public static class ControlButtonDetail
    extends ControlHeadingDetail {
        public static final String API_TYPE = "Setting.Details.ControlButton";
        public static final String TYPE = "type";
        public final String type;

        public ControlButtonDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.type = ControlButtonDetail.parseString(jsonNode, TYPE);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<ControlButtonDetail> getSettingModelControlButtonDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlButtonDetail> arrayList = new ArrayList<ControlButtonDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlButtonDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlButtonDetail>(0);
        }

        public static interface Type {
            public static final String BUTTON = "button";
            public static final Set<String> values = new HashSet<String>(Arrays.asList("button"));
        }
    }

    public static class ControlBaseDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.ControlBase";
        public static final String DELAYED = "delayed";
        public static final String FORMAT = "format";
        public static final String TYPE = "type";
        public final Boolean delayed;
        public final String format;
        public final String type;

        public ControlBaseDetail(Boolean bl, String string, String string2) {
            this.delayed = bl;
            this.format = string;
            this.type = string2;
        }

        public ControlBaseDetail(JsonNode jsonNode) {
            this.delayed = jsonNode.get(DELAYED).asBoolean();
            this.format = jsonNode.get(FORMAT).asText();
            this.type = jsonNode.get(TYPE).asText();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(DELAYED, this.delayed);
            objectNode.put(FORMAT, this.format);
            objectNode.put(TYPE, this.type);
            return objectNode;
        }

        static List<ControlBaseDetail> getSettingModelControlBaseDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlBaseDetail> arrayList = new ArrayList<ControlBaseDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlBaseDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlBaseDetail>(0);
        }
    }

    public static class ControlDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.Control";
        public final ControlButtonDetail detailsControlButton;
        public final ControlCheckmarkDetail detailsControlCheckmark;
        public final ControlEditDetail detailsControlEdit;
        public final ControlListDetail detailsControlList;
        public final ControlRangeDetail detailsControlRange;
        public final ControlSliderDetail detailsControlSlider;
        public final ControlSpinnerDetail detailsControlSpinner;

        public ControlDetail(ControlButtonDetail controlButtonDetail) {
            this.detailsControlButton = controlButtonDetail;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlCheckmarkDetail controlCheckmarkDetail) {
            this.detailsControlCheckmark = controlCheckmarkDetail;
            this.detailsControlButton = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlEditDetail controlEditDetail) {
            this.detailsControlEdit = controlEditDetail;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlListDetail controlListDetail) {
            this.detailsControlList = controlListDetail;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlRangeDetail controlRangeDetail) {
            this.detailsControlRange = controlRangeDetail;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlSlider = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlSliderDetail controlSliderDetail) {
            this.detailsControlSlider = controlSliderDetail;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSpinner = null;
        }

        public ControlDetail(ControlSpinnerDetail controlSpinnerDetail) {
            this.detailsControlSpinner = controlSpinnerDetail;
            this.detailsControlButton = null;
            this.detailsControlCheckmark = null;
            this.detailsControlEdit = null;
            this.detailsControlList = null;
            this.detailsControlRange = null;
            this.detailsControlSlider = null;
        }

        public ControlDetail(JsonNode jsonNode) {
            if (jsonNode.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (jsonNode.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (jsonNode.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (jsonNode.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (jsonNode.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (jsonNode.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else if (jsonNode.isObject()) {
                this.detailsControlButton = null;
                this.detailsControlCheckmark = null;
                this.detailsControlEdit = null;
                this.detailsControlList = null;
                this.detailsControlRange = null;
                this.detailsControlSlider = null;
                this.detailsControlSpinner = null;
            } else {
                throw new RuntimeException("Weird type for \"Details.Control\", I'm confused!");
            }
        }

        @Override
        public JsonNode toJsonNode() {
            if (this.detailsControlButton != null) {
                return this.detailsControlButton.toJsonNode();
            }
            if (this.detailsControlCheckmark != null) {
                return this.detailsControlCheckmark.toJsonNode();
            }
            if (this.detailsControlEdit != null) {
                return this.detailsControlEdit.toJsonNode();
            }
            if (this.detailsControlList != null) {
                return this.detailsControlList.toJsonNode();
            }
            if (this.detailsControlRange != null) {
                return this.detailsControlRange.toJsonNode();
            }
            if (this.detailsControlSlider != null) {
                return this.detailsControlSlider.toJsonNode();
            }
            if (this.detailsControlSpinner != null) {
                return this.detailsControlSpinner.toJsonNode();
            }
            return null;
        }

        static List<ControlDetail> getSettingModelControlDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<ControlDetail> arrayList = new ArrayList<ControlDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new ControlDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<ControlDetail>(0);
        }
    }

    public static class CategoryDetail
    extends BaseDetail {
        public static final String API_TYPE = "Setting.Details.Category";
        public static final String GROUPS = "groups";
        public final List<GroupDetail> groups;

        public CategoryDetail(JsonNode jsonNode) {
            super(jsonNode);
            this.groups = GroupDetail.getSettingModelGroupDetailList(jsonNode, GROUPS);
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = (ObjectNode)super.toJsonNode();
            ArrayNode arrayNode = OM.createArrayNode();
            for (GroupDetail groupDetail : this.groups) {
                arrayNode.add(groupDetail.toJsonNode());
            }
            objectNode.put(GROUPS, (JsonNode)arrayNode);
            return objectNode;
        }

        static List<CategoryDetail> getSettingModelCategoryDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<CategoryDetail> arrayList = new ArrayList<CategoryDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new CategoryDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<CategoryDetail>(0);
        }
    }

    public static class BaseDetail
    extends AbstractModel {
        public static final String API_TYPE = "Setting.Details.Base";
        public static final String HELP = "help";
        public static final String ID = "id";
        public static final String LABEL = "label";
        public final String help;
        public final String id;
        public final String label;

        public BaseDetail(String string, String string2, String string3) {
            this.help = string;
            this.id = string2;
            this.label = string3;
        }

        public BaseDetail(JsonNode jsonNode) {
            this.help = BaseDetail.parseString(jsonNode, HELP);
            this.id = jsonNode.get(ID).asText();
            this.label = jsonNode.get(LABEL).asText();
        }

        @Override
        public JsonNode toJsonNode() {
            ObjectNode objectNode = OM.createObjectNode();
            objectNode.put(HELP, this.help);
            objectNode.put(ID, this.id);
            objectNode.put(LABEL, this.label);
            return objectNode;
        }

        static List<BaseDetail> getSettingModelBaseDetailList(JsonNode jsonNode, String string) {
            if (jsonNode.has(string)) {
                ArrayNode arrayNode = (ArrayNode)jsonNode.get(string);
                ArrayList<BaseDetail> arrayList = new ArrayList<BaseDetail>(arrayNode.size());
                for (int i = 0; i < arrayNode.size(); ++i) {
                    arrayList.add(new BaseDetail(arrayNode.get(i)));
                }
                return arrayList;
            }
            return new ArrayList<BaseDetail>(0);
        }
    }
}

