/*
 * Decompiled with CFR 0.152.
 */
package org.jupnp.model.message.header;

import org.jupnp.model.message.header.InvalidHeaderException;
import org.jupnp.model.message.header.UpnpHeader;
import org.jupnp.model.types.UDN;

public class USNRootDeviceHeader
extends UpnpHeader<UDN> {
    public static final String ROOT_DEVICE_SUFFIX = "::upnp:rootdevice";

    public USNRootDeviceHeader() {
    }

    public USNRootDeviceHeader(UDN udn) {
        this.setValue(udn);
    }

    @Override
    public void setString(String s) throws InvalidHeaderException {
        if (!s.startsWith("uuid:") || !s.endsWith(ROOT_DEVICE_SUFFIX)) {
            throw new InvalidHeaderException("Invalid root device USN header value, must start with 'uuid:' and end with '::upnp:rootdevice' but is '" + s + "'");
        }
        UDN udn = new UDN(s.substring("uuid:".length(), s.length() - ROOT_DEVICE_SUFFIX.length()));
        this.setValue(udn);
    }

    @Override
    public String getString() {
        return ((UDN)this.getValue()).toString() + ROOT_DEVICE_SUFFIX;
    }
}

