/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowFrameRateFilter
extends AbstractCheckComboBoxTvShowUIFilter<Double> {
    public TvShowFrameRateFilter() {
        this.checkComboBox.enableFilter((s, s2) -> String.valueOf(s).startsWith((String)s2));
        this.buildAndInstallFrameRateArray();
        EventBus.registerListener(EventBus.TOPIC_TV_SHOWS_UI, event -> this.buildAndInstallFrameRateArray());
    }

    @Override
    public String getId() {
        return "tvShowFrameRate";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List frameRates = this.checkComboBox.getSelectedItems();
        for (Double frameRate : frameRates) {
            if (invert ^ frameRate == 0.0) {
                return true;
            }
            for (TvShowEpisode episode : episodes) {
                if (!(invert ^ frameRate.doubleValue() == episode.getMediaInfoFrameRate())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.framerate"));
    }

    private void buildAndInstallFrameRateArray() {
        HashSet<Double> frameRateInEpisodes = new HashSet<Double>(this.tvShowList.getFrameRatesInEpisodes());
        if (!SetUtils.equals(this.oldValues, frameRateInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(frameRateInEpisodes);
            List<Double> sortedFrameRates = ListUtils.asSortedList(frameRateInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedFrameRates));
        }
    }

    @Override
    protected String parseTypeToString(Double type) throws Exception {
        return type.toString();
    }

    @Override
    protected Double parseStringToType(String string) throws Exception {
        return Double.parseDouble(string);
    }
}

