/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowDecadeFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowDecadeFilter() {
        this.checkComboBox.enableFilter(String::startsWith);
        this.buildAndInstallDecadeArray();
        EventBus.registerListener(EventBus.TOPIC_TV_SHOWS_UI, event -> this.buildAndInstallDecadeArray());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.decade"));
    }

    @Override
    public String getId() {
        return "tvShowDecades";
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List selectedItems = this.checkComboBox.getSelectedItems();
        return invert ^ selectedItems.contains(tvShow.getDecadeShort());
    }

    private void buildAndInstallDecadeArray() {
        HashSet<String> decadesInTvShows = new HashSet<String>(this.tvShowList.getDecadesInTvShows());
        if (!SetUtils.equals(this.oldValues, decadesInTvShows)) {
            this.oldValues.clear();
            this.oldValues.addAll(decadesInTvShows);
            List<String> sortedDecades = ListUtils.asSortedList(decadesInTvShows);
            SwingUtilities.invokeLater(() -> this.setValues(sortedDecades));
        }
    }
}

