/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.tvshows.filters;

import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.tvshow.entities.TvShow;
import org.tinymediamanager.core.tvshow.entities.TvShowEpisode;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.tvshows.filters.AbstractCheckComboBoxTvShowUIFilter;

public class TvShowAudioCodecFilter
extends AbstractCheckComboBoxTvShowUIFilter<String> {
    public TvShowAudioCodecFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.toLowerCase(Locale.ROOT).contains(s2.toLowerCase(Locale.ROOT)));
        this.buildAndInstallAudioCodecArray();
        EventBus.registerListener(EventBus.TOPIC_TV_SHOWS_UI, event -> this.buildAndInstallAudioCodecArray());
    }

    @Override
    public String getId() {
        return "tvShowAudioCodec";
    }

    @Override
    protected boolean accept(TvShow tvShow, List<TvShowEpisode> episodes, boolean invert) {
        List codecs = this.checkComboBox.getSelectedItems();
        for (TvShowEpisode episode : episodes) {
            List<MediaFile> mfs = episode.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO);
            for (MediaFile mf : mfs) {
                for (String audioCodec : mf.getAudioCodecList()) {
                    if (!(invert ^ codecs.contains(audioCodec))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.audiocodec"));
    }

    private void buildAndInstallAudioCodecArray() {
        HashSet<String> audioCodecsInEpisodes = new HashSet<String>(this.tvShowList.getAudioCodecsInEpisodes());
        if (!SetUtils.equals(this.oldValues, audioCodecsInEpisodes)) {
            this.oldValues.clear();
            this.oldValues.addAll(audioCodecsInEpisodes);
            List<String> sortedAudioCodecs = ListUtils.asSortedList(audioCodecsInEpisodes);
            SwingUtilities.invokeLater(() -> this.setValues(sortedAudioCodecs));
        }
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

