/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.panels;

import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Objects;
import javax.swing.JCheckBox;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.entities.MediaFileSubtitle;
import org.tinymediamanager.scraper.util.LanguageUtils;
import org.tinymediamanager.ui.components.combobox.AutocompleteComboBox;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.panels.AbstractModalInputPanel;

public class MediaFileSubtitleEditorPanel
extends AbstractModalInputPanel {
    private final MediaFileSubtitle subtitle;
    private final AutocompleteComboBox cbLanguage;
    private final JCheckBox chkbxDefault;
    private final JCheckBox chkbxForced;
    private final JCheckBox chkbxSdh;
    private final JTextField tfFormat;
    private final JTextField tfTitle;
    private final TmmTableFormat.StringComparator stringComparator;

    public MediaFileSubtitleEditorPanel(MediaFileSubtitle subtitle) {
        this.subtitle = subtitle;
        this.stringComparator = new TmmTableFormat.StringComparator();
        ArrayList<LanguageContainer> languages = new ArrayList<LanguageContainer>();
        for (Locale locale : Locale.getAvailableLocales()) {
            LanguageContainer localeContainer = new LanguageContainer(locale);
            if (languages.contains(localeContainer)) continue;
            languages.add(localeContainer);
        }
        languages.sort((o1, o2) -> this.stringComparator.compare(o1.toString(), o2.toString()));
        LanguageContainer fileLocale = new LanguageContainer(subtitle.getLanguage());
        if (fileLocale.locale == null || fileLocale.locale != null && !languages.contains(fileLocale)) {
            languages.add(fileLocale);
        }
        this.setLayout((LayoutManager)new MigLayout("", "[][][300lp,grow]", "[][][][][]"));
        TmmLabel lblLanguageT = new TmmLabel(TmmResourceBundle.getString("metatag.language"));
        this.add((Component)lblLanguageT, "cell 0 0,alignx trailing");
        this.cbLanguage = new AutocompleteComboBox<Object>(languages.toArray());
        this.add((Component)this.cbLanguage, "cell 1 0 2 1, wmin 50%");
        TmmLabel lblDefaultT = new TmmLabel(TmmResourceBundle.getString("metatag.default"));
        this.add((Component)lblDefaultT, "cell 0 1,alignx trailing");
        this.chkbxDefault = new JCheckBox();
        this.add((Component)this.chkbxDefault, "cell 1 1, growx");
        TmmLabel lblForcedT = new TmmLabel(TmmResourceBundle.getString("metatag.forced"));
        this.add((Component)lblForcedT, "cell 0 2,alignx trailing");
        this.chkbxForced = new JCheckBox();
        this.add((Component)this.chkbxForced, "cell 1 2, growx");
        TmmLabel lblSdhT = new TmmLabel(TmmResourceBundle.getString("metatag.sdh"));
        this.add((Component)lblSdhT, "cell 0 3,alignx trailing");
        this.chkbxSdh = new JCheckBox();
        this.add((Component)this.chkbxSdh, "cell 1 3, growx");
        TmmLabel lblFormatT = new TmmLabel(TmmResourceBundle.getString("metatag.format"));
        this.add((Component)lblFormatT, "cell 0 4,alignx trailing");
        this.tfFormat = new JTextField();
        this.tfFormat.setColumns(8);
        this.add((Component)this.tfFormat, "cell 1 4, growx");
        TmmLabel lblTitleT = new TmmLabel(TmmResourceBundle.getString("metatag.title"));
        this.add((Component)lblTitleT, "cell 0 5,alignx trailing");
        this.tfTitle = new JTextField();
        this.tfTitle.setColumns(30);
        this.add((Component)this.tfTitle, "cell 1 5 2 1, growx");
        this.tfFormat.setText(subtitle.getCodec());
        this.chkbxDefault.setSelected(subtitle.isDefaultStream());
        this.chkbxForced.setSelected(subtitle.isForced());
        this.chkbxSdh.setSelected(subtitle.isSdh());
        this.tfTitle.setText(subtitle.getTitle());
        LanguageContainer foundByValue = languages.stream().filter(v -> v.value.equalsIgnoreCase(subtitle.getLanguage())).findFirst().get();
        this.cbLanguage.setSelectedItem(foundByValue);
        SwingUtilities.invokeLater(this.cbLanguage::requestFocus);
    }

    @Override
    protected void onClose() {
        this.subtitle.setCodec(this.tfFormat.getText());
        this.subtitle.setDefaultStream(this.chkbxDefault.isSelected());
        this.subtitle.setForced(this.chkbxForced.isSelected());
        this.subtitle.setSdh(this.chkbxSdh.isSelected());
        Object obj = this.cbLanguage.getSelectedItem();
        if (obj instanceof LanguageContainer) {
            LanguageContainer localeContainer = (LanguageContainer)obj;
            this.subtitle.setLanguage(localeContainer.value.strip());
        } else if (obj instanceof String) {
            String language = (String)obj;
            this.subtitle.setLanguage(language.strip());
        }
        this.subtitle.setTitle(this.tfTitle.getText());
        this.setVisible(false);
    }

    private static class LanguageContainer {
        private final String value;
        private Locale locale;
        private final String description;

        public LanguageContainer(@NotNull Locale locale) {
            this.locale = locale;
            this.value = locale.getISO3Language();
            this.description = StringUtils.isNotBlank((CharSequence)locale.getDisplayLanguage()) ? locale.getDisplayLanguage() + " (" + this.value + ")" : "";
        }

        public LanguageContainer(@NotNull String locale) {
            Locale tmp = LanguageUtils.KEY_TO_LOCALE_MAP.get(locale);
            if (tmp != null) {
                this.locale = tmp;
            }
            this.value = locale;
            this.description = this.locale != null ? this.value + " (" + this.locale.getISO3Language() + ")" : this.value;
        }

        public String toString() {
            return this.description;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LanguageContainer that = (LanguageContainer)o;
            return this.value.equals(that.value);
        }

        public int hashCode() {
            return Objects.hash(this.value);
        }
    }
}

