/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.moviesets;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaEntity;
import org.tinymediamanager.core.movie.MovieList;
import org.tinymediamanager.core.movie.MovieModuleManager;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.core.movie.entities.MovieSet;
import org.tinymediamanager.ui.components.table.TmmTableFormat;
import org.tinymediamanager.ui.components.tree.TmmTreeDataProvider;
import org.tinymediamanager.ui.components.tree.TmmTreeNode;
import org.tinymediamanager.ui.components.treetable.AbstractTmmTreeTableNodeComparator;
import org.tinymediamanager.ui.components.treetable.ITmmTreeTableSortingStrategy;
import org.tinymediamanager.ui.components.treetable.TmmTreeTableFormat;

public class MovieSetTreeDataProvider
extends TmmTreeDataProvider<TmmTreeNode> {
    private final TmmTreeNode root = new TmmTreeNode(new Object(), this);
    private final TmmTreeTableFormat<TmmTreeNode> tableFormat;
    private final MovieList movieList = MovieModuleManager.getInstance().getMovieList();

    public MovieSetTreeDataProvider(TmmTreeTableFormat<TmmTreeNode> tableFormat) {
        this.tableFormat = tableFormat;
        EventBus.registerListener(EventBus.TOPIC_MOVIE_SETS, event -> {
            Object patt2321$temp = event.sender();
            if (patt2321$temp instanceof MovieSet) {
                MovieSet movieSet = (MovieSet)patt2321$temp;
                SwingUtilities.invokeLater(() -> this.processMovieSet(movieSet, event.eventType()));
            }
        });
        EventBus.registerListener(EventBus.TOPIC_MOVIES, event -> {
            Object patt2537$temp = event.sender();
            if (patt2537$temp instanceof Movie) {
                Movie movie = (Movie)patt2537$temp;
                SwingUtilities.invokeLater(() -> this.nodeChanged(movie));
            }
        });
        this.setTreeComparator(new MovieSetTreeNodeComparator());
        MovieModuleManager.getInstance().getSettings().addPropertyChangeListener(evt -> {
            switch (evt.getPropertyName()) {
                case "displayMovieSetMissingMovies": {
                    this.mixinMovies();
                }
            }
        });
    }

    private void processMovieSet(MovieSet movieSet, String eventType) {
        TmmTreeNode movieSetNode = this.getNodeFromCache(movieSet);
        if (movieSetNode != null) {
            if ("remove".equals(eventType)) {
                this.removeMovieSet(movieSet);
            } else {
                this.updateMovieSet(movieSet);
            }
        } else {
            this.addMovieSet(movieSet);
        }
    }

    private void nodeChanged(Object source) {
        TmmTreeNode node = this.getNodeFromCache(source);
        if (node != null) {
            this.firePropertyChange("nodeChanged", null, node);
        }
    }

    @Override
    public TmmTreeNode getRoot() {
        return this.root;
    }

    @Override
    public TmmTreeNode getParent(TmmTreeNode child) {
        if (child.getUserObject() instanceof MovieSet) {
            return this.root;
        }
        Object object = child.getUserObject();
        if (object instanceof Movie) {
            Movie movie = (Movie)object;
            TmmTreeNode node = this.getNodeFromCache(movie.getMovieSet());
            if (node == null && movie.getMovieSet() != null) {
                node = this.addMovieSet(movie.getMovieSet());
            }
            return node;
        }
        return null;
    }

    @Override
    public List<TmmTreeNode> getChildren(TmmTreeNode parent) {
        if (parent == this.root) {
            ArrayList<TmmTreeNode> nodes = new ArrayList<TmmTreeNode>();
            for (MovieSet movieSet : new ArrayList<MovieSet>(this.movieList.getMovieSetList())) {
                TmmTreeNode node = this.getOrCreateNode(movieSet);
                nodes.add(node);
            }
            return nodes;
        }
        ArrayList<TmmTreeNode> nodes = parent.getUserObject();
        if (nodes instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)((Object)nodes);
            nodes = new ArrayList<TmmTreeNode>();
            for (Movie movie : movieSet.getMoviesForDisplay()) {
                TmmTreeNode node;
                if (movie.getMovieSet() == movieSet) {
                    node = this.getOrCreateNode(movie);
                    nodes.add(node);
                    continue;
                }
                if (!(movie instanceof MovieSet.MovieSetMovie)) continue;
                node = this.getOrCreateNode(movie);
                nodes.add(node);
            }
            return nodes;
        }
        return null;
    }

    private TmmTreeNode getOrCreateNode(MediaEntity entity) {
        TmmTreeNode cachedNode = this.getNodeFromCache(entity);
        if (cachedNode != null) {
            return cachedNode;
        }
        if (entity instanceof MovieSet) {
            MovieSet movieSet = (MovieSet)entity;
            MovieSetTreeNode node = new MovieSetTreeNode((Object)movieSet, (TmmTreeDataProvider)this);
            this.putNodeToCache(movieSet, node);
            return node;
        }
        if (entity instanceof Movie) {
            Movie movie = (Movie)entity;
            MovieTreeNode node = new MovieTreeNode((Object)movie, (TmmTreeDataProvider)this);
            this.putNodeToCache(movie, node);
            return node;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isLeaf(TmmTreeNode node) {
        return node.getUserObject() instanceof Movie;
    }

    private TmmTreeNode addMovieSet(MovieSet movieSet) {
        TmmTreeNode cachedNode = this.getNodeFromCache(movieSet);
        if (cachedNode != null) {
            return cachedNode;
        }
        MovieSetTreeNode node = new MovieSetTreeNode((Object)movieSet, (TmmTreeDataProvider)this);
        this.putNodeToCache(movieSet, node);
        this.firePropertyChange("nodeInserted", null, node);
        for (Movie movie : movieSet.getMovies()) {
            this.addMovie(movie);
        }
        return node;
    }

    private void removeMovieSet(MovieSet movieSet) {
        TmmTreeNode cachedNode = this.removeNodeFromCache(movieSet);
        if (cachedNode == null) {
            return;
        }
        for (Movie movie : movieSet.getMovies()) {
            this.removeNodeFromCache(movie);
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    private void updateMovieSet(MovieSet movieSet) {
        TmmTreeNode movieSetTreeNode = this.getNodeFromCache(movieSet);
        if (movieSetTreeNode == null) {
            this.addMovieSet(movieSet);
            return;
        }
        this.mixinMovies(movieSet);
        this.nodeChanged(movieSet);
    }

    private void addMovie(Movie movie) {
        TmmTreeNode cachedNode = this.getNodeFromCache(movie);
        if (cachedNode != null) {
            TmmTreeNode parent = this.getNodeFromCache(movie.getMovieSet());
            if (parent == cachedNode.getParent()) {
                return;
            }
            this.removeNodeFromCache(movie);
        }
        MovieTreeNode node = new MovieTreeNode((Object)movie, (TmmTreeDataProvider)this);
        this.putNodeToCache(movie, node);
        this.firePropertyChange("nodeInserted", null, node);
    }

    private void removeMovie(Movie movie) {
        TmmTreeNode cachedNode = this.removeNodeFromCache(movie);
        if (cachedNode == null) {
            return;
        }
        this.firePropertyChange("nodeRemoved", null, cachedNode);
    }

    private void mixinMovies() {
        for (MovieSet movieSet : this.movieList.getMovieSetList()) {
            this.mixinMovies(movieSet);
        }
    }

    private void mixinMovies(MovieSet movieSet) {
        TmmTreeNode movieSetNode = this.getNodeFromCache(movieSet);
        if (movieSetNode == null) {
            return;
        }
        List<Movie> movies = movieSet.getMoviesForDisplay();
        ArrayList<TmmTreeNode> nodesToRemove = new ArrayList<TmmTreeNode>();
        for (int i = 0; i < movieSetNode.getChildCount(); ++i) {
            TmmTreeNode child = (TmmTreeNode)movieSetNode.getChildAt(i);
            if (movies.contains(child.getUserObject())) continue;
            nodesToRemove.add(child);
        }
        for (TmmTreeNode node : nodesToRemove) {
            if (!(node.getUserObject() instanceof Movie)) continue;
            this.removeMovie((Movie)node.getUserObject());
        }
        for (Movie movie : movies) {
            this.addMovie(movie);
        }
    }

    class MovieSetTreeNodeComparator
    extends AbstractTmmTreeTableNodeComparator {
        private final Comparator stringComparator = new TmmTableFormat.StringComparator();
        private Comparator sortComparator;

        private MovieSetTreeNodeComparator() {
            this.sortColumn = 0;
            this.sortDirection = ITmmTreeTableSortingStrategy.SortDirection.ASCENDING;
            this.sortComparator = this.getSortComparator();
        }

        @Override
        public int compare(TmmTreeNode o1, TmmTreeNode o2) {
            Object userObject1 = o1.getUserObject();
            Object userObject2 = o2.getUserObject();
            if (userObject1 instanceof MovieSet && userObject2 instanceof MovieSet) {
                int comparingResult = this.sortComparator.compare(this.getColumnValue(o1, this.sortColumn), this.getColumnValue(o2, this.sortColumn));
                if (comparingResult == 0 && this.sortColumn != 0) {
                    comparingResult = this.stringComparator.compare(this.getColumnValue(o1, 0), this.getColumnValue(o2, 0));
                } else if (this.sortDirection == ITmmTreeTableSortingStrategy.SortDirection.DESCENDING) {
                    comparingResult *= -1;
                }
                return comparingResult;
            }
            if (userObject1 instanceof Movie && userObject2 instanceof Movie) {
                Movie movie1 = (Movie)userObject1;
                Movie movie2 = (Movie)userObject2;
                if (movie1.getMovieSet() != null && movie1.getMovieSet() == movie2.getMovieSet()) {
                    List<Movie> moviesInSet = movie1.getMovieSet().getMoviesForDisplay();
                    return moviesInSet.indexOf(movie1) - moviesInSet.indexOf(movie2);
                }
            }
            return o1.toString().compareToIgnoreCase(o2.toString());
        }

        @Override
        public void columnClicked(int column, boolean shift, boolean control) {
            this.sortDirection = this.sortColumn == column ? (this.sortDirection == ITmmTreeTableSortingStrategy.SortDirection.ASCENDING ? ITmmTreeTableSortingStrategy.SortDirection.DESCENDING : ITmmTreeTableSortingStrategy.SortDirection.ASCENDING) : ITmmTreeTableSortingStrategy.SortDirection.ASCENDING;
            this.sortColumn = column;
            this.sortComparator = this.getSortComparator();
        }

        @Override
        public void fromString(String stringEncoded) {
            super.fromString(stringEncoded);
            this.sortComparator = this.getSortComparator();
        }

        private Comparator<?> getSortComparator() {
            if (this.sortColumn == 0) {
                return this.stringComparator;
            }
            return MovieSetTreeDataProvider.this.tableFormat.getColumnComparator(this.sortColumn - 1);
        }

        private Object getColumnValue(TmmTreeNode treeNode, int i) {
            if (i == 0) {
                return ((MovieSet)treeNode.getUserObject()).getTitleSortable();
            }
            return MovieSetTreeDataProvider.this.tableFormat.getColumnValue(treeNode, i - 1);
        }

        @Override
        public ITmmTreeTableSortingStrategy.SortDirection getSortDirection(int sortColumn) {
            if (sortColumn == this.sortColumn) {
                return this.sortDirection;
            }
            return null;
        }
    }

    public static class MovieSetTreeNode
    extends TmmTreeNode {
        public MovieSetTreeNode(Object userObject, TmmTreeDataProvider dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof MovieSet) {
                MovieSet MovieSet2 = (MovieSet)this.getUserObject();
                return MovieSet2.getTitleSortable();
            }
            return super.toString();
        }
    }

    static class MovieTreeNode
    extends TmmTreeNode {
        public MovieTreeNode(Object userObject, TmmTreeDataProvider dataProvider) {
            super(userObject, dataProvider);
        }

        @Override
        public String toString() {
            if (this.getUserObject() instanceof Movie) {
                Movie movie = (Movie)this.getUserObject();
                return movie.getTitleSortable();
            }
            return super.toString();
        }
    }
}

