/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import javax.swing.JLabel;
import javax.swing.SpinnerNumberModel;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractNumberMovieFilter;

public class MovieVideoBitdepthFilter
extends AbstractNumberMovieFilter {
    public MovieVideoBitdepthFilter() {
        this.spinnerLow.setEditor(this.prepareNumberEditor(this.spinnerLow, "#0 bit"));
        this.spinnerHigh.setEditor(this.prepareNumberEditor(this.spinnerHigh, "#0 bit"));
    }

    @Override
    public String getId() {
        return "movieVideoBitdepth";
    }

    @Override
    protected SpinnerNumberModel getNumberModel() {
        return new SpinnerNumberModel(0, 0, 99, 1);
    }

    @Override
    public boolean accept(Movie movie) {
        return this.matchInt(movie.getMainVideoFile().getBitDepth());
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.bitdepth"));
    }
}

