/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.movies.filters;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.tinymediamanager.core.MediaFileHelper;
import org.tinymediamanager.core.MediaFileType;
import org.tinymediamanager.core.TmmResourceBundle;
import org.tinymediamanager.core.bus.EventBus;
import org.tinymediamanager.core.entities.MediaFile;
import org.tinymediamanager.core.movie.entities.Movie;
import org.tinymediamanager.scraper.util.ListUtils;
import org.tinymediamanager.scraper.util.SetUtils;
import org.tinymediamanager.ui.components.label.TmmLabel;
import org.tinymediamanager.ui.movies.filters.AbstractCheckComboBoxMovieUIFilter;

public class MovieAudioChannelFilter
extends AbstractCheckComboBoxMovieUIFilter<String> {
    public MovieAudioChannelFilter() {
        this.checkComboBox.enableFilter((s, s2) -> s.substring(0, 1).equals(s2.substring(0, 1)));
        this.buildAndInstallAudioChannelArray();
        EventBus.registerListener(EventBus.TOPIC_MOVIES_UI, event -> this.buildAndInstallAudioChannelArray());
    }

    @Override
    public String getId() {
        return "movieAudioChannel";
    }

    @Override
    public boolean accept(Movie movie) {
        ArrayList<String> audioChannels = new ArrayList<String>();
        for (String values : this.checkComboBox.getSelectedItems()) {
            audioChannels.add(values.substring(0, 1));
        }
        List<MediaFile> mediaFiles = movie.getMediaFiles(MediaFileType.VIDEO, MediaFileType.AUDIO);
        for (MediaFile mf : mediaFiles) {
            for (String channels : mf.getAudioChannelsList()) {
                if (!audioChannels.contains(channels.substring(0, 1))) continue;
                return true;
            }
        }
        return false;
    }

    private void buildAndInstallAudioChannelArray() {
        HashSet<String> audioChannelsInMovies = new HashSet<String>();
        for (int channel : this.movieList.getAudioChannelsInMovies()) {
            audioChannelsInMovies.add(this.audioChannelNotation(channel));
        }
        if (!SetUtils.equals(this.oldValues, audioChannelsInMovies)) {
            this.oldValues.clear();
            this.oldValues.addAll(audioChannelsInMovies);
            List sortedChannelsTitles = ListUtils.asSortedList(audioChannelsInMovies);
            SwingUtilities.invokeLater(() -> this.setValues(sortedChannelsTitles));
        }
    }

    private String audioChannelNotation(int channels) {
        Object ret = "";
        switch (channels) {
            case 0: {
                ret = "0 (no audio)";
                break;
            }
            case 1: {
                ret = "1 (Mono)";
                break;
            }
            case 2: {
                ret = "2 (Stereo)";
                break;
            }
            default: {
                ret = channels + " (" + MediaFileHelper.audioChannelInDotNotation(channels) + ")";
            }
        }
        return ret;
    }

    @Override
    protected JLabel createLabel() {
        return new TmmLabel(TmmResourceBundle.getString("metatag.channels"));
    }

    @Override
    protected String parseTypeToString(String type) throws Exception {
        return type;
    }

    @Override
    protected String parseStringToType(String string) throws Exception {
        return string;
    }
}

