/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui.components.toast;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import javax.swing.JComponent;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;

public class TmmToast
extends JComponent {
    private static final WeakHashMap<Window, TmmToast> INSTANCES = new WeakHashMap();
    private final List<ToastMessage> toasts = new ArrayList<ToastMessage>();
    private final Timer animator;
    private static final int FPS = 60;
    private static final int TICK_MS = 16;
    private static final int MARGIN = 16;
    private static final int GAP = 12;
    private static final int MAX_WIDTH = 400;
    private static final int PADDING_H = 16;
    private static final int PADDING_V = 12;
    private static final int ARC = 8;
    private static final int TITLE_GAP = 4;
    private Window ownerWindow;
    private JComponent previousGlassPane;
    private boolean previousGlassPaneVisible;
    private ComponentAdapter resizeListener;

    private TmmToast() {
        this.setOpaque(false);
        this.animator = new Timer(16, e -> this.tick());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TmmToast install(Window window) {
        if (window == null) {
            throw new IllegalArgumentException("window must not be null");
        }
        WeakHashMap<Window, TmmToast> weakHashMap = INSTANCES;
        synchronized (weakHashMap) {
            TmmToast toast = INSTANCES.get(window);
            if (toast == null) {
                toast = new TmmToast();
                toast.ownerWindow = window;
                INSTANCES.put(window, toast);
                if (window instanceof RootPaneContainer) {
                    RootPaneContainer rpc = (RootPaneContainer)((Object)window);
                    Component component = rpc.getGlassPane();
                    if (component instanceof JComponent) {
                        JComponent gp;
                        toast.previousGlassPane = gp = (JComponent)component;
                        toast.previousGlassPaneVisible = gp.isVisible();
                    }
                    rpc.getRootPane().setGlassPane(toast);
                    toast.setVisible(true);
                    final TmmToast finalToast = toast;
                    toast.resizeListener = new ComponentAdapter(){

                        @Override
                        public void componentResized(ComponentEvent e) {
                            finalToast.repaint();
                        }
                    };
                    window.addComponentListener(toast.resizeListener);
                }
            }
            return toast;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uninstall(Window window) {
        if (window == null) {
            return;
        }
        WeakHashMap<Window, TmmToast> weakHashMap = INSTANCES;
        synchronized (weakHashMap) {
            TmmToast toast = INSTANCES.remove(window);
            if (toast != null) {
                toast.uninstallInternal();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isInstalled(Window window) {
        WeakHashMap<Window, TmmToast> weakHashMap = INSTANCES;
        synchronized (weakHashMap) {
            return INSTANCES.containsKey(window);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallInternal() {
        Window window;
        if (this.animator.isRunning()) {
            this.animator.stop();
        }
        List<ToastMessage> list = this.toasts;
        synchronized (list) {
            this.toasts.clear();
        }
        if (this.ownerWindow != null && this.resizeListener != null) {
            try {
                this.ownerWindow.removeComponentListener(this.resizeListener);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.resizeListener = null;
        }
        if ((window = this.ownerWindow) instanceof RootPaneContainer) {
            RootPaneContainer rpc = (RootPaneContainer)((Object)window);
            try {
                if (rpc.getGlassPane() == this && this.previousGlassPane != null) {
                    rpc.getRootPane().setGlassPane(this.previousGlassPane);
                    this.previousGlassPane.setVisible(this.previousGlassPaneVisible);
                } else if (rpc.getGlassPane() == this) {
                    JComponent defaultGp = new JComponent(){};
                    defaultGp.setVisible(false);
                    rpc.getRootPane().setGlassPane(defaultGp);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setVisible(false);
        this.previousGlassPane = null;
        this.ownerWindow = null;
    }

    public void showToast(String message, ToastType type, int durationMs) {
        if (message == null || message.trim().isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            List<ToastMessage> list = this.toasts;
            synchronized (list) {
                this.toasts.add(0, new ToastMessage(null, message, type, durationMs));
            }
            if (!this.animator.isRunning()) {
                this.animator.start();
            }
            this.repaint();
        });
    }

    public void showToast(String message) {
        this.showToast(message, ToastType.INFO, 3000);
    }

    public void showToast(String title, String message, ToastType type, int durationMs) {
        if (message == null || message.trim().isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(() -> {
            List<ToastMessage> list = this.toasts;
            synchronized (list) {
                this.toasts.add(0, new ToastMessage(title, message, type, durationMs));
            }
            if (!this.animator.isRunning()) {
                this.animator.start();
            }
            this.repaint();
        });
    }

    public void showToast(String title, String message) {
        this.showToast(title, message, ToastType.INFO, 3000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tick() {
        boolean needsRepaint = false;
        boolean hasActiveToasts = false;
        long now = System.currentTimeMillis();
        List<ToastMessage> list = this.toasts;
        synchronized (list) {
            Iterator<ToastMessage> it = this.toasts.iterator();
            while (it.hasNext()) {
                ToastMessage t = it.next();
                long life = now - t.createdAt;
                float oldAlpha = t.alpha;
                if (!t.fading && life >= (long)t.durationMs) {
                    t.fading = true;
                    t.fadeStart = now;
                }
                if (t.fading) {
                    long fadeElapsed = now - t.fadeStart;
                    float f = fadeElapsed;
                    Objects.requireNonNull(t);
                    float alpha = 1.0f - Math.min(1.0f, f / 600.0f);
                    t.alpha = Math.max(0.0f, alpha);
                    if (t.alpha <= 0.01f) {
                        it.remove();
                        needsRepaint = true;
                        continue;
                    }
                } else {
                    long since = now - t.createdAt;
                    float f = since;
                    Objects.requireNonNull(t);
                    t.alpha = Math.min(1.0f, Math.max(0.0f, f / 250.0f));
                }
                if (Math.abs(t.alpha - oldAlpha) > 0.001f) {
                    needsRepaint = true;
                }
                hasActiveToasts = true;
            }
        }
        if (!hasActiveToasts && this.animator.isRunning()) {
            this.animator.stop();
        }
        if (needsRepaint) {
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g.create();
        try {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            int windowWidth = this.getWidth();
            int y = 16;
            List<ToastMessage> list = this.toasts;
            synchronized (list) {
                for (ToastMessage toast : this.toasts) {
                    Dimension size = this.calculateToastSize(g2, toast);
                    int x = windowWidth - 16 - size.width;
                    float slideProgress = 1.0f - toast.alpha;
                    float easedProgress = 1.0f - (float)Math.pow(slideProgress, 3.0);
                    int slide = (int)((1.0f - easedProgress) * 30.0f);
                    this.drawToast(g2, toast, x += slide, y, size);
                    y += size.height + 12;
                }
            }
        }
        finally {
            g2.dispose();
        }
    }

    private Dimension calculateToastSize(Graphics2D g2, ToastMessage toast) {
        FontMetrics fm = g2.getFontMetrics();
        Font titleFont = g2.getFont().deriveFont(g2.getFont().getStyle() | 1);
        FontMetrics tfm = g2.getFontMetrics(titleFont);
        int windowWidth = this.getWidth();
        int maxTextWidth = Math.min(368, windowWidth - 64);
        List<String> messageLines = this.wrapText(toast.message, fm, maxTextWidth);
        int messageTextHeight = messageLines.size() * fm.getHeight();
        int messageTextWidth = 0;
        for (String line : messageLines) {
            messageTextWidth = Math.max(messageTextWidth, fm.stringWidth(line));
        }
        int titleTextHeight = 0;
        int titleTextWidth = 0;
        if (toast.title != null && !toast.title.trim().isEmpty()) {
            List<String> titleLines = this.wrapText(toast.title, tfm, maxTextWidth);
            titleTextHeight = titleLines.size() * tfm.getHeight();
            for (String line : titleLines) {
                titleTextWidth = Math.max(titleTextWidth, tfm.stringWidth(line));
            }
        }
        int contentWidth = Math.max(messageTextWidth, titleTextWidth);
        int width = Math.min(400, contentWidth + 32);
        int height = messageTextHeight + 24;
        if (titleTextHeight > 0) {
            height += titleTextHeight + 4;
        }
        return new Dimension(width, height);
    }

    private List<String> wrapText(String text, FontMetrics fm, int maxWidth) {
        ArrayList<String> lines = new ArrayList<String>();
        String[] words = text.split(" ");
        StringBuilder currentLine = new StringBuilder();
        for (String word : words) {
            String testLine;
            String string = testLine = currentLine.isEmpty() ? word : currentLine + " " + word;
            if (fm.stringWidth(testLine) <= maxWidth) {
                if (!currentLine.isEmpty()) {
                    currentLine.append(" ");
                }
                currentLine.append(word);
                continue;
            }
            if (!currentLine.isEmpty()) {
                lines.add(currentLine.toString());
                currentLine = new StringBuilder(word);
                continue;
            }
            lines.add(word);
        }
        if (!currentLine.isEmpty()) {
            lines.add(currentLine.toString());
        }
        return lines.isEmpty() ? List.of(text) : lines;
    }

    private void drawToast(Graphics2D g2, ToastMessage toast, int x, int y, Dimension size) {
        g2.setComposite(AlphaComposite.getInstance(3, toast.alpha));
        Color bg = toast.type.getBackgroundColor();
        g2.setColor(bg);
        g2.fillRoundRect(x, y, size.width, size.height, 8, 8);
        Color borderColor = toast.type.getBorderColor();
        g2.setColor(new Color(borderColor.getRed(), borderColor.getGreen(), borderColor.getBlue(), (int)(toast.alpha * 255.0f)));
        g2.drawRoundRect(x, y, size.width, size.height, 8, 8);
        g2.setColor(toast.type.getTextColor());
        FontMetrics fm = g2.getFontMetrics();
        int textX = x + 16;
        int textY = y + 12 + fm.getAscent();
        if (toast.title != null && !toast.title.trim().isEmpty()) {
            Font original = g2.getFont();
            Font bold = original.deriveFont(original.getStyle() | 1);
            g2.setFont(bold);
            FontMetrics tfm = g2.getFontMetrics();
            List<String> titleLines = this.wrapText(toast.title, tfm, size.width - 32);
            for (String line : titleLines) {
                g2.drawString(line, textX, textY);
                textY += tfm.getHeight();
            }
            textY += 4;
            g2.setFont(original);
            fm = g2.getFontMetrics();
        }
        List<String> lines = this.wrapText(toast.message, fm, size.width - 32);
        for (String line : lines) {
            g2.drawString(line, textX, textY);
            textY += fm.getHeight();
        }
    }

    public static enum ToastType {
        INFO,
        SUCCESS,
        WARNING,
        ERROR;


        Color getBackgroundColor() {
            switch (this) {
                case SUCCESS: {
                    return new Color(34, 197, 94);
                }
                case WARNING: {
                    return new Color(234, 179, 0);
                }
                case ERROR: {
                    return new Color(239, 68, 68);
                }
            }
            Color panelBg = UIManager.getColor("Panel.background");
            if (panelBg != null) {
                int brightness = (panelBg.getRed() + panelBg.getGreen() + panelBg.getBlue()) / 3;
                if (brightness > 128) {
                    return new Color(Math.max(0, panelBg.getRed() - 40), Math.max(0, panelBg.getGreen() - 40), Math.max(0, panelBg.getBlue() - 40));
                }
                return new Color(Math.min(255, panelBg.getRed() + 40), Math.min(255, panelBg.getGreen() + 40), Math.min(255, panelBg.getBlue() + 40));
            }
            return new Color(66, 66, 66);
        }

        Color getBorderColor() {
            return switch (this) {
                case SUCCESS -> new Color(46, 125, 50);
                case WARNING -> new Color(230, 120, 0);
                case ERROR -> new Color(198, 40, 40);
                default -> new Color(0, 0, 0, 100);
            };
        }

        Color getTextColor() {
            return Color.BLACK;
        }
    }

    private static class ToastMessage {
        final String title;
        final String message;
        final ToastType type;
        final long createdAt;
        final int durationMs;
        float alpha = 0.0f;
        boolean fading = false;
        long fadeStart = 0L;
        final int fadeInMs = 250;
        final int fadeDurationMs = 600;

        ToastMessage(String title, String message, ToastType type, int durationMs) {
            this.title = title;
            this.message = message;
            this.type = type == null ? ToastType.INFO : type;
            this.createdAt = System.currentTimeMillis();
            this.durationMs = Math.max(1000, durationMs);
        }
    }
}

