/*
 * Decompiled with CFR 0.152.
 */
package org.tinymediamanager.ui;

import java.awt.Canvas;
import java.awt.FontMetrics;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.apache.commons.lang3.StringUtils;
import org.tinymediamanager.core.AbstractModelObject;
import org.tinymediamanager.core.ImageUtils;
import org.tinymediamanager.scraper.MediaScraper;
import org.tinymediamanager.scraper.interfaces.IMediaProvider;
import org.tinymediamanager.ui.IconManager;
import org.tinymediamanager.ui.images.TmmSvgIcon;

public class ScraperInTable
extends AbstractModelObject {
    protected static final ResourceBundle BUNDLE = ResourceBundle.getBundle("messages");
    protected MediaScraper scraper;
    protected ImageIcon scraperLogo;
    protected boolean active;
    protected boolean enabled;

    public ScraperInTable(MediaScraper scraper) {
        this.scraper = scraper;
        this.scraperLogo = scraper.getMediaProvider() == null || scraper.getMediaProvider().getProviderInfo() == null || scraper.getMediaProvider().getProviderInfo().getProviderLogo() == null ? new ImageIcon() : this.getIcon(scraper.getMediaProvider().getProviderInfo().getProviderLogo());
        this.enabled = scraper.isEnabled();
    }

    protected ImageIcon getIcon(URL url) {
        try {
            URI uri = url.toURI();
            if (url.getFile().endsWith("svg")) {
                TmmSvgIcon svgIcon = new TmmSvgIcon(uri);
                svgIcon.setPreferredHeight(this.calculatePreferredHeight());
                return svgIcon;
            }
            return ImageUtils.createMultiResolutionImage(IconManager.loadImageFromURL(url), this.calculatePreferredHeight());
        }
        catch (Exception e) {
            return null;
        }
    }

    private int calculatePreferredHeight() {
        Canvas c = new Canvas();
        FontMetrics fm = c.getFontMetrics(new JPanel().getFont());
        return (int)((float)fm.getHeight() * 1.8f);
    }

    public String getScraperId() {
        return this.scraper.getId();
    }

    public String getScraperName() {
        Object scraperName = StringUtils.isNotBlank((CharSequence)this.scraper.getVersion()) ? this.scraper.getName() + " - " + this.scraper.getVersion() : this.scraper.getName();
        if (!this.enabled) {
            scraperName = "*PRO* " + (String)scraperName;
        }
        return scraperName;
    }

    public String getScraperDescription() {
        String description = null;
        try {
            description = BUNDLE.getString("scraper." + this.scraper.getId() + ".hint");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (StringUtils.isBlank(description)) {
            description = this.scraper.getDescription();
        }
        return description;
    }

    public Icon getScraperLogo() {
        return this.scraperLogo;
    }

    public Boolean getActive() {
        return this.active;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setActive(Boolean newValue) {
        Boolean oldValue = this.active;
        this.active = newValue;
        this.firePropertyChange("active", oldValue, newValue);
    }

    public IMediaProvider getMediaProvider() {
        return this.scraper.getMediaProvider();
    }
}

